/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.cms.signature;

import de.intarsys.asn1.cms.CMS;
import de.intarsys.asn1.cms.EncapsulatedContentInfo;
import de.intarsys.asn1.cms.SignedData;
import de.intarsys.security.algorithm.common.AlgorithmSpec;
import de.intarsys.security.app.validation.ISignatureContainerValidator;
import de.intarsys.security.method.cms.signature.CMSBasedSignatureContainer;
import de.intarsys.security.method.cms.signature.CMSSignature;
import de.intarsys.security.method.cms.signature.CMSSignatureEntry;
import de.intarsys.security.method.cms.timestamp.TimestampToken;
import de.intarsys.security.method.cms.timestamp.TimestampTokenContainer;
import de.intarsys.security.method.cms.validation.CMSSignatureContainerValidator;
import de.intarsys.security.signature.ISignatureContainer;
import de.intarsys.security.timestamp.ITimestampToken;
import de.intarsys.tools.attribute.Attribute;
import de.intarsys.tools.attribute.IAttributeSupport;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorSupport;
import de.intarsys.tools.locator.LocatorByReference;
import de.intarsys.tools.locator.LocatorTools;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;

public class CMSSignatureContainer
extends CMSBasedSignatureContainer<CMSSignatureEntry> {
    protected static final Attribute ATTR_SIGNATURECONTAINERS = new Attribute("signatureContainers");
    private CMSSignature cmsSignature;
    private List<CMSSignatureEntry> signatureEntries;

    public static ISignatureContainer getSignatureContainer(Object signedData, ILocator signatureLocator) throws IOException {
        CMS cms;
        CMSBasedSignatureContainer container = null;
        HashMap<ILocator, CMSBasedSignatureContainer> containers = null;
        if (signedData instanceof IAttributeSupport) {
            containers = (HashMap<ILocator, CMSBasedSignatureContainer>)((IAttributeSupport)signedData).getAttribute((Object)ATTR_SIGNATURECONTAINERS);
            if (containers == null) {
                containers = new HashMap<ILocator, CMSBasedSignatureContainer>();
                ((IAttributeSupport)signedData).setAttribute((Object)ATTR_SIGNATURECONTAINERS, containers);
            } else {
                container = (CMSBasedSignatureContainer)((Object)containers.get(signatureLocator));
            }
        }
        if (container == null && (cms = CMSBasedSignatureContainer.createCMS(signatureLocator)).isSignedData()) {
            SignedData sd = cms.getSignedData();
            EncapsulatedContentInfo eci = sd.getEncapContentInfo();
            if (eci.isContentTypeId(PKCSObjectIdentifiers.id_ct_TSTInfo) || "tsr".equals(LocatorTools.getExtension((ILocator)signatureLocator))) {
                ITimestampToken token = TimestampToken.create(cms);
                container = new TimestampTokenContainer(cms, token);
            } else if (eci.getContentBytes() == null) {
                container = new CMSSignatureContainer(cms);
            }
            if (container != null) {
                container.setLocator(signatureLocator);
                LocatorByReference signedDataLocator = null;
                if (signedData instanceof ILocatorSupport) {
                    signedDataLocator = new LocatorByReference((ILocatorSupport)signedData);
                } else if (signedData instanceof ILocator) {
                    signedDataLocator = (ILocator)signedData;
                }
                container.setSignedContentLocator((ILocator)signedDataLocator);
                if (containers != null) {
                    containers.put(signatureLocator, container);
                }
            }
        }
        return container;
    }

    public CMSSignatureContainer(CMS cms) {
        this(new CMSSignature(cms));
    }

    public CMSSignatureContainer(CMSSignature signature) {
        super(signature.getCMS());
        this.cmsSignature = signature;
    }

    public void clearCaches() {
        this.signatureEntries = null;
    }

    protected CMSSignatureEntry createEntry(int i) {
        return new CMSSignatureEntry(this, i);
    }

    protected ISignatureContainerValidator createSignatureContainerValidator() {
        return new CMSSignatureContainerValidator();
    }

    @Override
    public byte[] getBytes() {
        return this.getCmsSignature().getBytes();
    }

    public String getContentType() {
        return "application/pkcs7-signature";
    }

    public List<CMSSignatureEntry> getEntries() {
        if (this.signatureEntries == null) {
            this.signatureEntries = new ArrayList<CMSSignatureEntry>();
            int size = this.getCmsSignature().getSignerInfosSize();
            for (int i = 0; i < size; ++i) {
                this.signatureEntries.add(this.createEntry(i));
            }
        }
        return this.signatureEntries;
    }

    public CMSSignature getCmsSignature() {
        return this.cmsSignature;
    }

    public Set<String> getSignatureDigestAlgorithmsUsed() {
        HashSet<String> algoSet = new HashSet<String>();
        for (CMSSignatureEntry entry : this.getEntries()) {
            AlgorithmSpec spec = entry.getHashAlgorithmSpec();
            if (spec == null) continue;
            algoSet.add(spec.getAlgorithm().getOid());
        }
        return algoSet;
    }

    public byte[] getSignedContent() {
        return this.getCmsSignature().getSignedContent();
    }

    @Override
    public int getSize() {
        return this.getCmsSignature().getSignerInfosSize();
    }

    @Override
    protected String getTypedNameDefault() {
        return "signature.p7s";
    }
}

