/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.cms.signature;

import de.intarsys.document.model.DocumentEnvironment;
import de.intarsys.security.app.signature.ISigner;
import de.intarsys.security.method.cms.signature.CMSSignatureContainerBuilder;
import de.intarsys.security.method.cms.signature.ICMSSignatureContainerBuilder;
import de.intarsys.security.method.common.signature.AdESSignerTools;
import de.intarsys.security.method.common.signature.SignatureOptions;
import de.intarsys.tools.factory.CommonInstantiatingFactory;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.locator.ILocatorFactory;
import de.intarsys.tools.reflect.ObjectCreationException;
import java.io.IOException;

public abstract class CommonCMSSignatureContainerBuilderFactory
extends CommonInstantiatingFactory<ICMSSignatureContainerBuilder> {
    protected CommonCMSSignatureContainerBuilderFactory() {
    }

    protected ICMSSignatureContainerBuilder basicCreateInstance(IArgs args) throws ObjectCreationException {
        try {
            ISigner signer = AdESSignerTools.getSigner((IArgs)args);
            this.prepareDigestSigner(signer, args);
            CMSSignatureContainerBuilder builder = new CMSSignatureContainerBuilder();
            builder.setSigner(signer);
            builder.setDigest(CMSSignatureContainerBuilder.getDigest(args));
            builder.setContent(ArgTools.getLocator((IArgs)args, (String)"content", null, (ILocatorFactory)DocumentEnvironment.get().getLocatorFactory()));
            builder.setContentType(ArgTools.getString((IArgs)args, (String)"contentType", null));
            this.prepareCMSSigner(builder, args);
            return builder;
        }
        catch (IOException e) {
            throw new ObjectCreationException((Throwable)e);
        }
    }

    public Class<ICMSSignatureContainerBuilder> getResultType() {
        return ICMSSignatureContainerBuilder.class;
    }

    protected void prepareCMSSigner(ICMSSignatureContainerBuilder builder, IArgs args) throws ObjectCreationException {
    }

    protected void prepareDigestSigner(ISigner signer, IArgs args) throws ObjectCreationException {
        SignatureOptions signatureOptions = AdESSignerTools.getSignatureOptions((IArgs)args);
        signer.setSignatureOptions(signatureOptions);
    }
}

