/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.cms.timestamp;

import de.intarsys.security.app.validation.ISignatureContainerEntryDefaultStateFactory;
import de.intarsys.security.app.validation.common.TimestampEntryDefaultStateFactory;
import de.intarsys.security.method.cms.timestamp.TimestampTokenContainer;
import de.intarsys.security.signature.ITimestampEntry;
import de.intarsys.security.timestamp.ITimestampToken;
import de.intarsys.tools.adapter.IAdapterSupport;
import de.intarsys.tools.attribute.AttributeMap;
import de.intarsys.tools.locator.ILocator;
import java.io.IOException;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimestampTokenEntry
implements ITimestampEntry,
IAdapterSupport {
    private static final Logger Log = LoggerFactory.getLogger(TimestampTokenEntry.class);
    private final TimestampTokenContainer signatureContainer;
    private final ITimestampToken token;
    private final AttributeMap attributes = new AttributeMap();

    protected TimestampTokenEntry(TimestampTokenContainer signatureContainer, ITimestampToken token) {
        this.signatureContainer = signatureContainer;
        this.token = token;
    }

    public <T> T getAdapter(Class<T> clazz) {
        if (clazz == ISignatureContainerEntryDefaultStateFactory.class) {
            return (T)new TimestampEntryDefaultStateFactory();
        }
        return null;
    }

    public Object getAttribute(Object key) {
        return this.attributes.getAttribute(key);
    }

    public Date getCreationDate() {
        try {
            return this.getTimestamp().getTimestampInfo().getGenTime();
        }
        catch (IOException e) {
            Log.warn(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public Object getImpl() {
        return this.getTimestamp();
    }

    public TimestampTokenContainer getSignatureContainer() {
        return this.signatureContainer;
    }

    public ILocator getSignedDocument() throws IOException {
        return null;
    }

    public ITimestampToken getTimestamp() {
        return this.token;
    }

    public Object removeAttribute(Object key) {
        return this.attributes.removeAttribute(key);
    }

    public Object setAttribute(Object key, Object value) {
        return this.attributes.setAttribute(key, value);
    }
}

