/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.processor.common;

import de.intarsys.processor.common.CommonProcessorFactory;
import de.intarsys.processor.model.IProcessor;
import de.intarsys.tools.component.ComponentException;
import de.intarsys.tools.component.ComponentTargetException;
import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.component.IActivateDeactivate;
import de.intarsys.tools.component.IContextSupport;
import de.intarsys.tools.component.IDisposable;
import de.intarsys.tools.concurrent.ICompletionStageProvider;
import de.intarsys.tools.concurrent.ITaskCallback;
import de.intarsys.tools.concurrent.Promise;
import de.intarsys.tools.concurrent.TaskFailed;
import de.intarsys.tools.environment.file.FileEnvironment;
import de.intarsys.tools.environment.file.IFileEnvironment;
import de.intarsys.tools.event.ActivatedEvent;
import de.intarsys.tools.event.AttributeChangedEvent;
import de.intarsys.tools.event.CancelEvent;
import de.intarsys.tools.event.DeactivatedEvent;
import de.intarsys.tools.event.DestroyedEvent;
import de.intarsys.tools.event.Event;
import de.intarsys.tools.event.FailedEvent;
import de.intarsys.tools.event.OkEvent;
import de.intarsys.tools.event.StartedEvent;
import de.intarsys.tools.event.StopRequestedEvent;
import de.intarsys.tools.event.StoppedEvent;
import de.intarsys.tools.exception.EncodedRuntimeException;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.expression.EvaluationException;
import de.intarsys.tools.expression.ExpressionEvaluator;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.expression.MapResolver;
import de.intarsys.tools.expression.Mode;
import de.intarsys.tools.expression.ResolverMixin;
import de.intarsys.tools.expression.StaticArgsResolver;
import de.intarsys.tools.expression.TaggedStringEvaluator;
import de.intarsys.tools.factory.CommonObject;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.FunctorCancelledException;
import de.intarsys.tools.functor.FunctorException;
import de.intarsys.tools.functor.FunctorExecutionException;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.message.IMessage;
import de.intarsys.tools.message.LiteralMessage;
import de.intarsys.tools.monitor.IMonitor;
import de.intarsys.tools.monitor.MonitorTools;
import de.intarsys.tools.monitor.Trace;
import de.intarsys.tools.preferences.IPreferences;
import de.intarsys.tools.presentation.IPresentationSupport;
import de.intarsys.tools.progress.IProgressMonitor;
import de.intarsys.tools.progress.IProgressMonitorSupport;
import de.intarsys.tools.reporter.Reporter;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public abstract class CommonProcessor<R>
extends CommonObject
implements IProcessor<R>,
Future<R>,
IActivateDeactivate,
IProgressMonitorSupport,
IStringEvaluator,
IContextSupport,
ICompletionStageProvider<R>,
IDisposable {
    public static final String RESOLVER_SERIAL = "serial";
    public static final String RESOLVER_AUTOID = "autoid";
    public static final String ARG_RESOLVER = "resolver";
    private static final Logger Log = LoggerFactory.getLogger(CommonProcessor.class);
    public static final String RESOLVER_ARGS = "args";
    public static final String RESOLVER_PROCESSOR = "processor";
    public static final String ARG_WAIT_FOR_COMPLETION = "waitForCompletion";
    private IFileEnvironment fileEnvironment;
    private Exception exception;
    private Object lifecycleLock = new Object();
    private IMonitor monitor;
    private IProgressMonitor progressMonitor;
    private R result;
    private boolean started = false;
    private boolean stopped = false;
    private final Promise<R> promise;
    private final ResolverMixin resolver = new ResolverMixin(this){

        protected void createExpressionEvaluator(MapResolver resolver) {
            super.createExpressionEvaluator(resolver);
            CommonProcessor.this.createExpressionEvaluator(resolver);
        }

        protected Object evaluateFallback(String expression, IArgs args) throws EvaluationException {
            return CommonProcessor.this.evaluateFallback(expression, args);
        }
    };
    private final IStringEvaluator templateEvaluator = TaggedStringEvaluator.decorateLenient((IStringEvaluator[])new IStringEvaluator[]{this.resolver, ExpressionEvaluator.get((Mode)Mode.UNTRUSTED)});

    protected CommonProcessor(IFactory factory) {
        this.setFactory(factory);
        this.promise = new Promise("Promise-" + this.getLogLabel());
    }

    protected void acquireResources() throws IOException {
    }

    public final void activate() {
        if (!this.isStarted()) {
            return;
        }
        Object active = this.myFactory().getActive();
        if (active instanceof IActivateDeactivate && active != this) {
            ((IActivateDeactivate)active).deactivate();
        }
        this.basicActivate();
        this.myFactory().activated(this);
        ActivatedEvent event = new ActivatedEvent((Object)this);
        this.triggerEvent((Event)event);
    }

    public void addTaskCallback(ITaskCallback<R> callback) {
        this.promise.addTaskCallback(callback);
    }

    protected void basicActivate() {
    }

    protected void basicCancel() {
    }

    protected void basicDeactivate() {
    }

    protected Exception basicGetException() {
        return this.exception;
    }

    protected R basicGetResult() {
        return this.result;
    }

    protected void basicOK() {
    }

    protected void basicRun() throws Exception {
    }

    protected void basicStart() throws Exception {
    }

    protected void basicStop() throws Exception {
    }

    protected boolean basicStopRequested(Set visited) {
        return !this.hasUnsavedChanges();
    }

    public final void cancel() {
        this.exception = new FunctorCancelledException();
        this.basicCancel();
        CancelEvent event = new CancelEvent((Object)this);
        this.triggerEvent((Event)event);
        this.stop();
    }

    @Override
    public final boolean cancel(boolean interrupt) {
        this.cancel();
        return true;
    }

    protected Exception castException(Exception e) {
        return e;
    }

    protected void createExpressionEvaluator(MapResolver resolver) {
        resolver.put(RESOLVER_PROCESSOR, (Object)this.createPrefixedResolver());
        resolver.put(RESOLVER_ARGS, (Object)new StaticArgsResolver(this.getArgs()));
        this.createUnprefixedResolver(resolver);
    }

    protected final MapResolver createPrefixedResolver() {
        MapResolver tmpResolver = new MapResolver(true);
        this.createPrefixedResolver(tmpResolver);
        this.createUnprefixedResolver(tmpResolver);
        tmpResolver.setExceptionResolver(new IStringEvaluator(){

            public Object evaluate(String expression, IArgs pArgs) throws EvaluationException {
                return CommonProcessor.this.evaluateFallback(expression, pArgs);
            }
        });
        return tmpResolver;
    }

    protected void createPrefixedResolver(MapResolver resolver) {
    }

    protected void createUnprefixedResolver(MapResolver resolver) {
        resolver.put(RESOLVER_AUTOID, (Object)this.getAutoid());
        resolver.put(RESOLVER_SERIAL, (Object)this.getSerial());
    }

    public final void deactivate() {
        if (!this.isStarted()) {
            return;
        }
        this.basicDeactivate();
        this.myFactory().deactivated(this);
        DeactivatedEvent event = new DeactivatedEvent((Object)this);
        this.triggerEvent((Event)event);
    }

    public final void dispose() {
        this.stop();
        DestroyedEvent event = new DestroyedEvent((Object)this);
        this.triggerEvent((Event)event);
    }

    public final Object evaluate(String expression, IArgs args) throws EvaluationException {
        return this.resolver.evaluate(expression, args);
    }

    protected Object evaluateFallback(String expression, IArgs pArgs) throws EvaluationException {
        IStringEvaluator tempResolver = this.getArgResolver();
        if (tempResolver != null) {
            return tempResolver.evaluate(expression, pArgs);
        }
        throw new EvaluationException("can't evaluate '" + expression + "'");
    }

    protected void fail(Throwable t) {
        this.exception = (t = ExceptionTools.unwrap((Throwable)t)) instanceof Exception ? (Exception)t : new EncodedRuntimeException("ProcessFailed", ExceptionTools.getMessageShort((Throwable)t), t);
        this.exception = this.castException(this.exception);
        if (!ExceptionTools.isKnownReason((Throwable)this.exception)) {
            Log.debug("{} fail", (Object)this.getLogLabel(), (Object)t);
        }
        this.basicCancel();
        FailedEvent event = new FailedEvent((Object)this, this.exception);
        this.triggerEvent((Event)event);
        this.stop();
    }

    @Override
    public final R get() throws InterruptedException, ExecutionException {
        return (R)this.promise.get();
    }

    @Override
    public final R get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return (R)this.promise.get(timeout, unit);
    }

    protected IStringEvaluator getArgResolver() {
        return (IStringEvaluator)ArgTools.getObject((IArgs)this.getArgs(), (String)ARG_RESOLVER, null);
    }

    protected String getErrorMessage() {
        return "Processor failed";
    }

    public IFileEnvironment getFileEnvironment() {
        if (this.fileEnvironment == null) {
            return FileEnvironment.get();
        }
        return this.fileEnvironment;
    }

    protected IMonitor getMonitor() {
        return this.monitor;
    }

    protected IPreferences getPreferences() {
        return ((CommonProcessorFactory)this.getFactory()).getPreferences();
    }

    public IProgressMonitor getProgressMonitor() {
        if (this.progressMonitor == null) {
            IMessage message = LiteralMessage.create((String)(this.getClass().getName() + ".activity.main"), (String)"", (Object[])new Object[0]);
            this.progressMonitor = Reporter.get().reportActivityStart(message, 0);
        }
        return this.progressMonitor;
    }

    protected Promise<R> getPromise() {
        return this.promise;
    }

    protected String getReportTitle() {
        return "Error";
    }

    public final R getResult() throws FunctorException {
        this.start();
        if (this.exception == null) {
            return this.basicGetResult();
        }
        if (this.exception instanceof FunctorException) {
            throw (FunctorException)((Object)this.exception);
        }
        throw new FunctorExecutionException((Throwable)this.exception);
    }

    protected String getSaveChangesName() {
        return "";
    }

    public IStringEvaluator getTemplateEvaluator() {
        return this.templateEvaluator;
    }

    protected void handleThrowable(Throwable t) {
        Throwable unwrapped = ExceptionTools.unwrap((Throwable)t);
        if (ExceptionTools.isCancellation((Throwable)t)) {
            this.cancel(true);
            throw ExceptionTools.cancellation();
        }
        this.fail(unwrapped);
        throw ExceptionTools.completionException((Throwable)unwrapped);
    }

    protected boolean hasUnsavedChanges() {
        return false;
    }

    public boolean isActive() {
        return this.myFactory().getActive() == this;
    }

    @Override
    public final boolean isCancelled() {
        return this.promise.isCancelled();
    }

    @Override
    public final boolean isDone() {
        return this.promise.isDone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStarted() {
        Object object = this.lifecycleLock;
        synchronized (object) {
            return this.started;
        }
    }

    protected CommonProcessorFactory myFactory() {
        return (CommonProcessorFactory)this.getFactory();
    }

    public final void ok() {
        this.basicOK();
        OkEvent event = new OkEvent((Object)this, this.basicGetResult());
        this.triggerEvent((Event)event);
        this.stop();
    }

    protected void releaseResources() {
        this.getDispatcher().clear();
        this.getAttributes().clear();
    }

    public void removeTaskCallback(ITaskCallback<R> callback) {
        this.promise.removeTaskCallback(callback);
    }

    protected void reportError(Throwable t) {
        Reporter.get().reportError(this.getReportTitle(), this.getErrorMessage(), t, 0);
    }

    protected final void run() {
        try {
            this.basicRun();
        }
        catch (ComponentException e) {
            this.fail(e);
            throw e;
        }
        catch (Exception e) {
            Throwable tmpEx = ExceptionTools.unwrap((Throwable)e);
            if (ExceptionTools.isCancellation((Throwable)tmpEx)) {
                this.cancel();
            } else {
                this.fail(tmpEx);
            }
            throw new ComponentTargetException(tmpEx);
        }
        boolean waitForCompletion = ArgTools.getBoolStrict((IArgs)this.getArgs(), (String)ARG_WAIT_FOR_COMPLETION, (boolean)false);
        if (waitForCompletion) {
            this.activate();
            try {
                this.result = this.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected boolean saveChanges() {
        return true;
    }

    public void setContext(Object context) throws ConfigurationException {
        super.setContext(context);
        if (context instanceof IFileEnvironment) {
            this.setFileEnvironment((IFileEnvironment)context);
        }
    }

    public void setFileEnvironment(IFileEnvironment fileEnvironment) {
        this.fileEnvironment = fileEnvironment;
    }

    public void setProgressMonitor(IProgressMonitor progressMonitor) {
        this.progressMonitor = progressMonitor;
    }

    protected void setResult(R result) {
        this.result = result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() {
        Object object = this.lifecycleLock;
        synchronized (object) {
            if (this.started || this.stopped) {
                return;
            }
            this.started = true;
            this.monitor = MonitorTools.getMonitor((String)this.getFactory().getId());
            this.getMonitor().attach();
            this.exception = null;
            try {
                this.acquireResources();
                this.basicStart();
            }
            catch (ComponentException e) {
                this.fail(e);
                throw e;
            }
            catch (Exception e) {
                this.fail(e);
                throw new ComponentTargetException((Throwable)e);
            }
            this.myFactory().started(this);
        }
        Log.debug("{} started", (Object)this.getLogLabel());
        Log.trace("{} args\n{}", (Object)this.getLogLabel(), (Object)ArgTools.toPrintString((IArgs)this.getArgs(), (String)""));
        StartedEvent event = new StartedEvent((Object)this);
        this.triggerEvent((Event)event);
        Trace.get().sample(Level.INFO, "started '" + this.getFactory().getId() + "'");
        this.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        Object object = this.lifecycleLock;
        synchronized (object) {
            if (!this.started || this.stopped) {
                return;
            }
            this.deactivate();
            try {
                this.basicStop();
            }
            catch (Exception e) {
                Log.warn("{} stop raised exception", (Object)this.getLogLabel(), (Object)e);
            }
            this.myFactory().stopped(this);
            if (this.getMonitor() != null) {
                this.getMonitor().detach();
            }
            this.started = false;
            this.stopped = true;
        }
        Log.debug("{} stopped", (Object)this.getLogLabel());
        Trace.get().sample(Level.INFO, "stopped '" + this.getFactory().getId() + "'");
        StoppedEvent event = new StoppedEvent((Object)this);
        this.triggerEvent((Event)event);
        if (this.basicGetException() == null) {
            this.promise.finish(this.basicGetResult());
        } else {
            this.promise.fail((Throwable)this.basicGetException());
        }
        this.releaseResources();
    }

    public final boolean stopRequested(Set visited) {
        if (visited != null) {
            if (visited.contains(this)) {
                return true;
            }
            visited.add(this);
        }
        if (this.basicStopRequested(visited)) {
            Log.debug("{} stopRequested accept", (Object)this.getLogLabel());
            StopRequestedEvent event = new StopRequestedEvent((Object)this, visited);
            this.triggerEvent((Event)event);
            return !event.isVetoed();
        }
        Log.debug("{} stopRequested deny", (Object)this.getLogLabel());
        return false;
    }

    protected void triggerChangedAll() {
        AttributeChangedEvent event = new AttributeChangedEvent((Object)this, null, null, null);
        this.triggerEvent((Event)event);
    }

    protected void triggerEvent(Event event) {
        try {
            super.triggerEvent(event);
        }
        catch (RuntimeException e) {
            Log.warn("error in event handler", (Throwable)e);
        }
    }

    protected void triggerLabelChanged(Object oldValue, Object newValue) {
        AttributeChangedEvent event = new AttributeChangedEvent((Object)this, IPresentationSupport.ATTR_LABEL, oldValue, newValue);
        this.triggerEvent((Event)event);
    }

    public CompletionStage<R> wantResult() {
        this.start();
        final CompletableFuture stage = new CompletableFuture();
        this.promise.addTaskCallback(new ITaskCallback(){

            public void failed(TaskFailed exception) {
                if (exception.isCancellation()) {
                    stage.cancel(false);
                } else {
                    stage.completeExceptionally(exception.getCause());
                }
            }

            public void finished(Object result) {
                stage.complete(result);
            }
        });
        return stage;
    }
}

