/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.processor.common;

import de.intarsys.processor.common.CommonProcessor;
import de.intarsys.processor.model.IProcessor;
import de.intarsys.tools.component.IStartStop;
import de.intarsys.tools.factory.CommonInstantiatingFactory;
import de.intarsys.tools.factory.IBookkeepingFactory;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.reflect.ObjectCreationException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public abstract class CommonProcessorFactory<P extends IProcessor>
extends CommonInstantiatingFactory<P>
implements IBookkeepingFactory<P> {
    private static boolean BOOKKEEPING = false;
    private P active;
    private int counter = 0;
    private final List<P> instances = new ArrayList<P>();

    public static boolean isBookkeeping() {
        return BOOKKEEPING;
    }

    public static void setBookkeeping(boolean value) {
        BOOKKEEPING = value;
    }

    protected void activated(P processor) {
        this.setActive(processor);
    }

    protected void basicCreateInstanceConfig(P object, IArgs args) throws ObjectCreationException {
        if (object instanceof CommonProcessor) {
            ((CommonProcessor)object).setSerial(this.counter++);
        }
        super.basicCreateInstanceConfig(object, args);
    }

    protected void basicStop() {
        List<P> tempProcessors = this.getInstances();
        for (IProcessor instance : tempProcessors) {
            if (!(instance instanceof IStartStop)) continue;
            instance.stop();
        }
        super.basicStop();
    }

    protected boolean basicStopRequested(Set visited) {
        List<P> tempProcessors = this.getInstances();
        for (IProcessor instance : tempProcessors) {
            if (!(instance instanceof IStartStop) || instance.stopRequested(visited)) continue;
            return false;
        }
        return super.basicStopRequested(visited);
    }

    protected void deactivated(IProcessor processor) {
        if (processor == this.getActive()) {
            this.setActive(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public P getActive() {
        Object object = this.lock;
        synchronized (object) {
            return this.active;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<P> getInstances() {
        Object object = this.lock;
        synchronized (object) {
            return new ArrayList<P>(this.instances);
        }
    }

    public Class<P> getResultType() {
        return IProcessor.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setActive(P pActive) {
        Object object = this.lock;
        synchronized (object) {
            this.active = pActive;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.lock;
        synchronized (object) {
            return this.instances.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void started(P processor) {
        if (!CommonProcessorFactory.isBookkeeping()) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            this.instances.add(processor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopped(P processor) {
        if (!CommonProcessorFactory.isBookkeeping()) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            this.instances.remove(processor);
        }
    }
}

