/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.processor.document.common;

import de.intarsys.document.common.CommonDocument;
import de.intarsys.document.common.DocumentResolver;
import de.intarsys.document.common.DocumentTools;
import de.intarsys.document.model.IDocument;
import de.intarsys.processor.common.CommonProcessor;
import de.intarsys.processor.document.standard.IDocumentProcessor;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.event.AttributeChangedEvent;
import de.intarsys.tools.event.Event;
import de.intarsys.tools.event.INotificationListener;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.expression.MapResolver;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.presentation.IPresentationSupport;
import de.intarsys.tools.reflect.MethodException;
import java.io.IOException;

public abstract class CommonDocumentProcessor<D extends IDocument<M>, M, R>
extends CommonProcessor<R>
implements IDocumentProcessor<D, M, R> {
    private D document;
    private Object documentReferenceHandle;
    private INotificationListener listenDocumentAttributeChanged = new INotificationListener(){

        public void handleEvent(Event event) {
            CommonDocumentProcessor.this.onDocumentAttributeChanged((AttributeChangedEvent)event);
        }
    };
    private String longName = null;

    protected CommonDocumentProcessor(IFactory factory, D doc) {
        super(factory);
        this.document = doc;
    }

    @Override
    protected void acquireResources() throws IOException {
        if (this.getDocument() != null) {
            this.documentReferenceHandle = this.getDocument().acquire();
            this.getDocument().setAttribute((Object)this.getFactory(), (Object)this);
        }
        super.acquireResources();
    }

    @Override
    protected void basicStart() throws Exception {
        super.basicStart();
        this.checkDocumentHash(false);
        this.getDocument().addNotificationListener(AttributeChangedEvent.ID, this.listenDocumentAttributeChanged);
    }

    @Override
    protected void basicStop() throws Exception {
        this.getDocument().removeNotificationListener(AttributeChangedEvent.ID, this.listenDocumentAttributeChanged);
        super.basicStop();
    }

    protected void checkDocumentHash(boolean force) throws IOException {
        IDigest digest = ArgTools.getDigest((IArgs)this.getArgs(), (String)"documentHash");
        DocumentTools.checkHash(this.getDocument(), (Object)digest, (boolean)force);
    }

    protected void clearCache() {
    }

    @Override
    protected void createUnprefixedResolver(MapResolver resolver) {
        super.createUnprefixedResolver(resolver);
        resolver.put("doc", (Object)new DocumentResolver(this.getDocument()));
    }

    @Override
    public D getDocument() {
        return this.document;
    }

    @Override
    public String getLongName() {
        if (this.longName == null) {
            this.longName = "[" + this.getShortName() + "] - " + this.getDocument().getLongName();
        }
        return this.longName;
    }

    public M getModel() {
        return (M)this.document.getImpl();
    }

    @Override
    public String getShortName() {
        return this.getDocument().getShortName();
    }

    protected void onDocumentAttributeChanged(AttributeChangedEvent event) {
        if (IPresentationSupport.ATTR_LABEL.equals(event.getAttribute())) {
            this.longName = null;
            this.triggerLabelChanged(event.getOldValue(), event.getNewValue());
        }
        if (CommonDocument.ATTR_LOCATOR.equals(event.getAttribute())) {
            this.longName = null;
            this.triggerLabelChanged(event.getOldValue(), event.getNewValue());
        }
        if (CommonDocument.ATTR_CHANGED.equals(event.getAttribute())) {
            this.triggerChangedChanged();
        }
    }

    @Override
    protected void releaseResources() {
        if (this.document != null) {
            this.document.removeAttribute((Object)this.getFactory());
            this.document.release(this.documentReferenceHandle);
            this.document = null;
        }
        super.releaseResources();
    }

    protected void saveDocument(ILocator destination) throws Exception {
        Args args = Args.create();
        if (destination != null) {
            args.put("locator", (Object)destination);
        }
        try {
            this.getDocument().invoke("save", (IArgs)args);
        }
        catch (MethodException e) {
            throw (Exception)ExceptionTools.unwrap((Throwable)e);
        }
    }

    protected void triggerChangedChanged() {
        this.clearCache();
        AttributeChangedEvent event = new AttributeChangedEvent((Object)this, CommonDocument.ATTR_CHANGED, null, null);
        this.triggerEvent((Event)event);
    }
}

