/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.processor.document.standard;

import de.intarsys.document.model.IDocument;
import de.intarsys.processor.common.CommonProcessor;
import de.intarsys.processor.document.standard.DocumentViewerFactory;
import de.intarsys.processor.document.standard.IOpener;
import de.intarsys.processor.document.standard.IViewer;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.functor.FunctorTools;
import de.intarsys.tools.functor.IArgs;

public class DocumentOpener
extends CommonProcessor
implements IOpener {
    private IDocument document;
    private IViewer viewer;

    protected DocumentOpener(IFactory factory) {
        super(factory);
    }

    protected Object basicGetResult() {
        return this.viewer;
    }

    @Override
    protected void basicRun() throws Exception {
        IDocument idoc;
        try {
            idoc = (IDocument)FunctorTools.perform((Object)"de.intarsys.processor.document.standard.DocumentLoaderFactory", (IArgs)this.getArgs());
        }
        catch (Exception e) {
            if (ExceptionTools.isCancellation((Throwable)e)) {
                this.cancel();
                return;
            }
            throw (Exception)ExceptionTools.unwrap((Throwable)e);
        }
        this.getArgs().put("document", (Object)idoc);
        this.setDocument(idoc);
        if (this.getDocument() == null) {
            this.cancel();
            return;
        }
        try {
            this.viewer = (IViewer)((Object)FunctorTools.launch(DocumentViewerFactory.class, (IArgs)this.getArgs()));
            this.ok();
        }
        finally {
            this.getDocument().release((Object)this.getDocument());
        }
    }

    @Override
    public IDocument getDocument() {
        return this.document;
    }

    @Override
    public IViewer getViewer() {
        return this.viewer;
    }

    protected void setDocument(IDocument document) {
        this.document = document;
    }
}

