/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.freetype;

import de.intarsys.cwt.freetype.CharMap;
import de.intarsys.cwt.freetype.FreetypeException;
import de.intarsys.cwt.freetype.GlyphSlot;
import de.intarsys.cwt.freetype.SfntName;
import de.intarsys.cwt.freetype.nativec.FTBBox;
import de.intarsys.cwt.freetype.nativec.FTCharMap;
import de.intarsys.cwt.freetype.nativec.FTEnum;
import de.intarsys.cwt.freetype.nativec.FTFace;
import de.intarsys.cwt.freetype.nativec.FTSfntName;
import de.intarsys.cwt.freetype.nativec._FTNI;
import de.intarsys.nativec.type.NativeBuffer;
import java.awt.geom.Rectangle2D;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Face {
    private static final Logger Log = LoggerFactory.getLogger(Face.class);
    private static final long FT_FACE_FLAG_GLYPH_NAMES = 512L;
    private final FTFace face;
    private final NativeBuffer fontData;
    private final _FTNI ftni;
    private CharMap cachedCharMap = null;

    protected Face(_FTNI pFtni, FTFace pFace, NativeBuffer pFontData) {
        this.ftni = pFtni;
        this.face = pFace;
        this.fontData = pFontData;
    }

    public void clearCache() {
        this.cachedCharMap = null;
    }

    public void doneFace() {
        int rc = this.ftni.DoneFace(this.face);
        if (rc != 0) {
            Log.warn("error " + rc + " in DoneFace");
        }
    }

    public int getAscender() {
        return this.face.getAscender();
    }

    public Rectangle2D getBBox() {
        FTBBox faceBox = this.face.getBBox();
        Rectangle2D.Float result = new Rectangle2D.Float();
        result.x = faceBox.getMinX();
        result.y = faceBox.getMinY();
        result.width = faceBox.getMaxX() - faceBox.getMinX();
        result.height = faceBox.getMaxY() - faceBox.getMinY();
        return result;
    }

    public int getCharIndex(int code) {
        return this.ftni.GetCharIndex(this.face, code);
    }

    public CharMap getCharMap() {
        if (this.cachedCharMap == null) {
            this.cachedCharMap = CharMap.create(this.ftni, this.face.getCharMap());
        }
        return this.cachedCharMap;
    }

    public CharMap getCharMap(int index) {
        return new CharMap(this.ftni, (FTCharMap)((Object)this.face.getCharMaps().getValue(index)));
    }

    public int getDescender() {
        return this.face.getDescender();
    }

    public FTFace getFace() {
        return this.face;
    }

    public String getFamilyName() {
        return this.face.getFamilyName();
    }

    public int getFirstChar() {
        return this.ftni.GetFirstChar(this.face);
    }

    public NativeBuffer getFontData() {
        return this.fontData;
    }

    public String getGlyphName(int glyphIndex) {
        int numGlyphs = this.getNumGlyphs();
        if (glyphIndex < 0 || glyphIndex >= numGlyphs) {
            throw new IllegalArgumentException("index out of range: index=" + glyphIndex + ", numGlyphs=" + numGlyphs);
        }
        int nativeBufferSize = 256;
        NativeBuffer nativeBuffer = new NativeBuffer(256);
        int rc = this.ftni.GetGlyphName(this.face, glyphIndex, nativeBuffer, 256);
        if (rc != 0) {
            return null;
        }
        return nativeBuffer.getString(0);
    }

    public GlyphSlot getGlyphSlot() {
        return new GlyphSlot(this.ftni, this.face.getGlyphSlot());
    }

    public int getHeight() {
        return this.face.getHeight();
    }

    public int getNameIndex(String name) {
        return this.ftni.GetNameIndex(this.face, name);
    }

    public int getNumCharMaps() {
        return this.face.getNumCharMaps();
    }

    public int getNumGlyphs() {
        return this.safeLongToInt(this.face.getNumGlyphs());
    }

    public String getPostscriptName() {
        return this.ftni.GetPostscriptName(this.face);
    }

    public SfntName getSfntName(int index) {
        FTSfntName ftSfntName = new FTSfntName();
        int rc = this.ftni.GetSfntName(this.face, index, ftSfntName);
        if (rc != 0) {
            return null;
        }
        return new SfntName(this.ftni, ftSfntName);
    }

    public int getSfntNameCount() {
        return this.ftni.GetSfntNameCount(this.face);
    }

    public String getStyleName() {
        return this.face.getStyleName();
    }

    public int getUnderlinePosition() {
        return this.face.getUnderlinePosition();
    }

    public int getUnderlineThickness() {
        return this.face.getUnderlineThickness();
    }

    public int getUnitsPerEM() {
        return this.face.getUnitsPerEM();
    }

    public boolean hasGlyphNames() {
        return (this.face.getFaceFlags() & 0x200L) != 0L;
    }

    public void loadChar(int code, int flags) throws FreetypeException {
        int rc = this.ftni.LoadChar(this.face, code, flags);
        if (rc != 0) {
            throw new FreetypeException();
        }
    }

    public void loadGlyph(int index, int flags) throws FreetypeException {
        int rc = this.ftni.LoadGlyph(this.face, index, flags);
        if (rc != 0) {
            throw new FreetypeException();
        }
    }

    private int safeLongToInt(long value) {
        int intValue = (int)value;
        if ((long)intValue != value) {
            throw new IllegalArgumentException("out of int range: " + value);
        }
        return intValue;
    }

    public void selectCharMap(FTEnum id) throws FreetypeException {
        int rc = this.ftni.SelectCharMap(this.face, id);
        if (rc != 0) {
            throw new FreetypeException();
        }
    }

    public void setCharMap(CharMap charMap) {
        this.ftni.SetCharMap(this.face, charMap.getCharMap());
        this.clearCache();
    }

    public void setCharSize(int width, int height, int hRes, int vRes) {
        this.ftni.SetCharSize(this.face, width, height, hRes, vRes);
    }
}

