/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.freetype.nativec;

import de.intarsys.cwt.freetype.nativec.FTCharMap;
import de.intarsys.cwt.freetype.nativec.FTEnum;
import de.intarsys.cwt.freetype.nativec.FTFace;
import de.intarsys.cwt.freetype.nativec.FTGlyphSlot;
import de.intarsys.cwt.freetype.nativec.FTLibrary;
import de.intarsys.cwt.freetype.nativec.FTSfntName;
import de.intarsys.nativec.api.INativeFunction;
import de.intarsys.nativec.api.INativeInterface;
import de.intarsys.nativec.api.INativeLibrary;
import de.intarsys.nativec.api.NativeInterface;
import de.intarsys.nativec.type.NativeBuffer;
import de.intarsys.nativec.type.NativeReference;
import de.intarsys.tools.installresource.InstallFile;
import de.intarsys.tools.system.SystemTools;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class _FTNI {
    private static final Logger Log = LoggerFactory.getLogger(_FTNI.class);
    private INativeLibrary LIB;
    private INativeFunction doneFace;
    private INativeFunction doneFreeType;
    private INativeFunction getCharIndex;
    private INativeFunction getFirstChar;
    private INativeFunction getGlyphName;
    private INativeFunction getPostscriptName;
    private INativeFunction getNameIndex;
    private INativeFunction initFreeType;
    private INativeFunction loadChar;
    private INativeFunction loadGlyph;
    private INativeFunction newFace;
    private INativeFunction newMemoryFace;
    private INativeFunction renderGlyph;
    private INativeFunction selectCharMap;
    private INativeFunction setCharMap;
    private INativeFunction setCharSize;
    private INativeFunction getSfntNameCount;
    private INativeFunction getSfntName;

    public _FTNI() {
        this.init();
    }

    public synchronized int DoneFace(FTFace face) {
        return (Integer)this.doneFace.invoke(Integer.class, new Object[]{face});
    }

    public synchronized int DoneFreeType(FTLibrary library) {
        return (Integer)this.doneFreeType.invoke(Integer.class, new Object[]{library});
    }

    public synchronized int GetCharIndex(FTFace face, int code) {
        return (Integer)this.getCharIndex.invoke(Integer.class, new Object[]{face, code});
    }

    public synchronized int GetFirstChar(FTFace face) {
        return (Integer)this.getFirstChar.invoke(Integer.class, new Object[]{face, new byte[4]});
    }

    public synchronized int GetGlyphName(FTFace face, int glyph_index, NativeBuffer buffer, int buffer_max) {
        return (Integer)this.getGlyphName.invoke(Integer.class, new Object[]{face, glyph_index, buffer, buffer_max});
    }

    public synchronized int GetNameIndex(FTFace face, String name) {
        return (Integer)this.getNameIndex.invoke(Integer.class, new Object[]{face, name});
    }

    public synchronized String GetPostscriptName(FTFace face) {
        return (String)this.getPostscriptName.invoke(String.class, new Object[]{face});
    }

    public synchronized int GetSfntName(FTFace face, int index, FTSfntName sfntName) {
        return (Integer)this.getSfntName.invoke(Integer.class, new Object[]{face, index, sfntName});
    }

    public synchronized int GetSfntNameCount(FTFace face) {
        return (Integer)this.getSfntNameCount.invoke(Integer.class, new Object[]{face});
    }

    private void init() {
        block7: {
            INativeInterface nativeInterface = NativeInterface.get();
            String libraryName = SystemTools.mapLibraryName((String)"freetype", (String)"6");
            try {
                this.LIB = nativeInterface.createLibrary(libraryName);
            }
            catch (Throwable t) {
                if (SystemTools.isWindows() || SystemTools.isMac()) {
                    InstallFile install = new InstallFile("de/intarsys/cwt/freetype/nativec", libraryName, true);
                    try {
                        File file = install.load();
                        if (file == null) {
                            Log.warn("no bundled freetype available for this platform");
                        } else {
                            this.LIB = NativeInterface.get().createLibrary(file.getAbsolutePath());
                        }
                    }
                    catch (IOException ex) {
                        Log.error(ex.getMessage(), (Throwable)ex);
                    }
                }
                if (this.LIB != null) break block7;
                throw t;
            }
        }
        this.doneFace = this.LIB.getFunction("FT_Done_Face");
        this.doneFreeType = this.LIB.getFunction("FT_Done_FreeType");
        this.getCharIndex = this.LIB.getFunction("FT_Get_Char_Index");
        this.getFirstChar = this.LIB.getFunction("FT_Get_First_Char");
        this.getGlyphName = this.LIB.getFunction("FT_Get_Glyph_Name");
        this.getPostscriptName = this.LIB.getFunction("FT_Get_Postscript_Name");
        this.getNameIndex = this.LIB.getFunction("FT_Get_Name_Index");
        this.initFreeType = this.LIB.getFunction("FT_Init_FreeType");
        this.loadChar = this.LIB.getFunction("FT_Load_Char");
        this.loadGlyph = this.LIB.getFunction("FT_Load_Glyph");
        this.newFace = this.LIB.getFunction("FT_New_Face");
        this.newMemoryFace = this.LIB.getFunction("FT_New_Memory_Face");
        this.renderGlyph = this.LIB.getFunction("FT_Render_Glyph");
        this.selectCharMap = this.LIB.getFunction("FT_Select_Charmap");
        this.setCharMap = this.LIB.getFunction("FT_Set_Charmap");
        this.setCharSize = this.LIB.getFunction("FT_Set_Char_Size");
        this.getSfntNameCount = this.LIB.getFunction("FT_Get_Sfnt_Name_Count");
        this.getSfntName = this.LIB.getFunction("FT_Get_Sfnt_Name");
    }

    public synchronized int InitFreeType(NativeReference<FTLibrary> refLibrary) {
        int rc = (Integer)this.initFreeType.invoke(Integer.class, new Object[]{refLibrary});
        return rc;
    }

    public synchronized int LoadChar(FTFace face, int code, int flags) {
        return (Integer)this.loadChar.invoke(Integer.class, new Object[]{face, code, flags});
    }

    public synchronized int LoadGlyph(FTFace face, int index, int flags) {
        return (Integer)this.loadGlyph.invoke(Integer.class, new Object[]{face, index, flags});
    }

    public synchronized int NewFace(FTLibrary library, String name, int index, NativeReference<FTFace> refFace) {
        int rc = (Integer)this.newFace.invoke(Integer.class, new Object[]{library, name, index, refFace});
        return rc;
    }

    public synchronized int NewMemoryFace(FTLibrary library, NativeBuffer buffer, int fontIndex, NativeReference<FTFace> refFace) {
        int length = buffer.getSize();
        int rc = (Integer)this.newMemoryFace.invoke(Integer.class, new Object[]{library, buffer, length, fontIndex, refFace});
        return rc;
    }

    public synchronized int RenderGlyph(FTGlyphSlot glyph, int flags) {
        return (Integer)this.renderGlyph.invoke(Integer.class, new Object[]{glyph, flags});
    }

    public synchronized int SelectCharMap(FTFace face, FTEnum encoding) {
        return (Integer)this.selectCharMap.invoke(Integer.class, new Object[]{face, encoding.intValue()});
    }

    public synchronized int SetCharMap(FTFace face, FTCharMap map) {
        int rc = (Integer)this.setCharMap.invoke(Integer.class, new Object[]{face, map});
        return rc;
    }

    public synchronized int SetCharSize(FTFace face, int width, int height, int hRes, int vRes) {
        return (Integer)this.setCharSize.invoke(Integer.class, new Object[]{face, width, height, hRes, vRes});
    }
}

