/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.conversation.service.component.api;

import de.intarsys.conversation.service.component.api.Outcome;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.zones.IZone;
import de.intarsys.tools.zones.Zone;
import java.util.function.Consumer;

public class OutcomeConsumer<T>
implements Consumer<T> {
    private final IConversation conversation;
    private final IZone zone;

    public OutcomeConsumer(IConversation conversation) {
        this.conversation = conversation;
        this.zone = Zone.getCurrent();
    }

    @Override
    public final void accept(T value) {
        this.zone.enter();
        try {
            Outcome outcome = Outcome.create(value);
            if (outcome == null) {
                this.empty();
            } else if (outcome.isOk()) {
                this.ok();
            } else if (outcome.isCancel()) {
                this.cancel();
            } else if (outcome.isFail()) {
                this.fail();
            }
        }
        catch (Exception e) {
            this.unknown(value);
        }
        finally {
            this.zone.leave();
        }
    }

    protected void cancel() {
    }

    protected void empty() {
    }

    protected void fail() {
    }

    protected IConversation getConversation() {
        return this.conversation;
    }

    protected void ok() {
    }

    protected void unknown(T value) {
    }
}

