/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.document.type.digest.signature;

import de.intarsys.document.model.IDocument;
import de.intarsys.document.type.digest.DigestDocument;
import de.intarsys.security.document.type.digest.signature.DigestDocumentSignerFactory;
import de.intarsys.security.method.cms.signature.CMSSignatureContainer;
import de.intarsys.security.method.cms.signature.CMSSignatureContainerBuilder;
import de.intarsys.security.method.cms.signature.CMSSignatureContainerBuilderFactoryCAdES;
import de.intarsys.security.method.cms.signature.ICMSSignatureContainerBuilder;
import de.intarsys.security.processor.signature.AttachmentLocatorStrategy;
import de.intarsys.security.processor.signature.DeviceBasedDocumentSigner;
import de.intarsys.security.processor.signature.DocumentSignerException;
import de.intarsys.security.processor.signature.SignatureLocatorCreationStrategy;
import de.intarsys.security.signature.ISignatureContainer;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.conversation.impl.Conversation;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.digest.IDigester;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.LocatorTools;

public class DigestDocumentSigner
extends DeviceBasedDocumentSigner {
    private static final String FORMAT_CAdES_PAdES = "CAdES/PAdES";
    private static final String FORMAT_CAdES = "CAdES";

    protected DigestDocumentSigner(DigestDocumentSignerFactory factory, DigestDocument document) {
        super((IFactory)factory, (IDocument)document);
    }

    protected IConversation<ISignatureContainer> basicSign(IDigester digester) {
        try {
            ILocator source = this.getDocument().getLocator();
            ILocator destination = this.createDestinationLocator(source);
            IDigest digest = (IDigest)((DigestDocument)this.getDocument()).getImpl();
            IArgs args = this.getArgs().copy();
            args.put("hash", (Object)digest);
            args.put("signer", (Object)this.getDigestSigner());
            args.put("attributeCertificates", (Object)this.getAttributeCertificates());
            args.put("timestampDevice", this.getTimestampDevice());
            IFactory factory = CMSSignatureContainerBuilder.getFactory((IArgs)args, (Object)CMSSignatureContainerBuilderFactoryCAdES.get());
            ICMSSignatureContainerBuilder builder = (ICMSSignatureContainerBuilder)factory.createInstance(args);
            IConversation conversation = builder.run();
            return conversation.thenApply(container -> {
                container.setSignedContentLocator(source);
                this.saveToDestination((CMSSignatureContainer)container, destination);
                return container;
            });
        }
        catch (DocumentSignerException e) {
            return Conversation.failed((Throwable)e);
        }
        catch (Exception e) {
            return Conversation.failed((Throwable)new DocumentSignerException(e.getLocalizedMessage(), (Throwable)e));
        }
    }

    protected SignatureLocatorCreationStrategy getLocatorCreationStrategy() {
        AttachmentLocatorStrategy strategy = AttachmentLocatorStrategy.create((IArgs)this.getArgs());
        strategy.setExtension(AttachmentLocatorStrategy.getLocatorExtension((IArgs)this.getArgs(), (String)this.getLocatorExtensionDefault()));
        return strategy;
    }

    protected String getLocatorExtensionDefault() {
        return "p7s";
    }

    protected String getSignedDocManipulationMessage() {
        throw new UnsupportedOperationException();
    }

    protected void saveToDestination(CMSSignatureContainer container, ILocator destination) throws Exception {
        ILocator sourceLocator = container.getLocator();
        LocatorTools.copy((ILocator)sourceLocator, (ILocator)destination);
        container.setLocator(destination);
    }
}

