/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.report.etsi;

import java.util.Arrays;
import java.util.Optional;

public enum ChangeLevel {
    FORBIDDEN(99, "urn:intarsys:validation:changelevel:forbidden"),
    PERMITTED_ANNOTATE(5, "urn:intarsys:validation:changelevel:permitted:annotate"),
    PERMITTED_FILL(4, "urn:intarsys:validation:changelevel:permitted:fill"),
    PERMITTED_SIGN(3, "urn:intarsys:validation:changelevel:permitted:sign"),
    PERMITTED_BASIC(2, "urn:intarsys:validation:changelevel:permitted:basic"),
    IGNORABLE(1, "urn:intarsys:validation:changelevel:ignorable"),
    UNCHANGED(0, "urn:intarsys:validation:changelevel:unchanged"),
    UNDEFINED(-1, "urn:intarsys:validation:changelevel:undefined");

    private int value;
    private String uri;

    public static Optional<ChangeLevel> ofUri(String uri) {
        return Arrays.stream(ChangeLevel.values()).filter(e -> e.getUri().equals(uri)).findFirst();
    }

    public static Optional<ChangeLevel> ofValue(int value) {
        return Arrays.stream(ChangeLevel.values()).filter(e -> e.getValue() == value).findFirst();
    }

    private ChangeLevel(int value, String uri) {
        this.value = value;
        this.uri = uri;
    }

    public String getUri() {
        return this.uri;
    }

    public int getValue() {
        return this.value;
    }

    public boolean isForbidden() {
        return this == FORBIDDEN;
    }

    public boolean isIgnorable() {
        return this == IGNORABLE;
    }

    public boolean isMax(ChangeLevel maxLevel) {
        return this.getValue() <= maxLevel.getValue();
    }

    public boolean isPermittedAnnotate() {
        return this == PERMITTED_ANNOTATE;
    }

    public boolean isPermittedBasic() {
        return this == PERMITTED_BASIC;
    }

    public boolean isPermittedFill() {
        return this == PERMITTED_FILL;
    }

    public boolean isPermittedSign() {
        return this == PERMITTED_SIGN;
    }

    public boolean isUnchanged() {
        return this == UNCHANGED;
    }

    public boolean isUndefined() {
        return this == UNDEFINED;
    }
}

