/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.report.etsi;

import de.intarsys.evr.v1_2.ExtendedValidationReportType;
import de.intarsys.security.report.etsi.view.IValidationObjectProvider;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.stream.StreamTools;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.namespace.QName;
import org.etsi.uri._019102.v1_2.ValidationObjectListType;
import org.etsi.uri._019102.v1_2.ValidationReportType;

public class ETSIReportTools {
    public static String NS_ValidationReport_1_2 = "http://uri.etsi.org/19102/v1.2.1#";
    public static String NS_ExtendedValidationReport_1_2 = "http://www.intarsys.de/schema/evr/v1.2.1#";
    private static JAXBContext jaxbContext;

    protected static void basicSerializeReport(Object report, QName qName, ILocator locator) throws IOException {
        try {
            String encoding = "UTF-8";
            Marshaller jaxbMarshaller = ETSIReportTools.getJaxbContext().createMarshaller();
            jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
            jaxbMarshaller.setProperty("jaxb.encoding", (Object)encoding);
            JAXBElement root = new JAXBElement(qName, report.getClass(), report);
            try (Writer writer = locator.getWriter(encoding);){
                jaxbMarshaller.marshal((Object)root, writer);
            }
        }
        catch (JAXBException e) {
            throw new IOException(e);
        }
    }

    protected static IValidationObjectProvider createValidationObjectProvider(ValidationObjectListType validationObjectList) {
        return id -> {
            if (validationObjectList == null) {
                return null;
            }
            return validationObjectList.getValidationObject().stream().filter(vo -> id.equals(vo.getId())).findFirst().orElse(null);
        };
    }

    private static synchronized JAXBContext getJaxbContext() throws JAXBException {
        if (jaxbContext == null) {
            String contextPath = Stream.of(ValidationReportType.class, ExtendedValidationReportType.class).map(c -> c.getPackage().getName()).collect(Collectors.joining(":"));
            jaxbContext = JAXBContext.newInstance((String)contextPath);
        }
        return jaxbContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExtendedValidationReportType parseExtendedReport(ILocator locator) throws IOException {
        ExtendedValidationReportType extendedValidationReportType;
        Unmarshaller jaxbUnmarshaller = ETSIReportTools.getJaxbContext().createUnmarshaller();
        InputStream is = null;
        try {
            is = locator.getInputStream();
            JAXBElement element = (JAXBElement)jaxbUnmarshaller.unmarshal(is);
            extendedValidationReportType = (ExtendedValidationReportType)element.getValue();
        }
        catch (Throwable throwable) {
            try {
                StreamTools.close((Closeable)is);
                throw throwable;
            }
            catch (JAXBException e) {
                throw new IOException(e);
            }
        }
        StreamTools.close((Closeable)is);
        return extendedValidationReportType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ValidationReportType parseReport(ILocator locator) throws IOException {
        ValidationReportType validationReportType;
        Unmarshaller jaxbUnmarshaller = ETSIReportTools.getJaxbContext().createUnmarshaller();
        InputStream is = null;
        try {
            is = locator.getInputStream();
            JAXBElement element = (JAXBElement)jaxbUnmarshaller.unmarshal(is);
            validationReportType = (ValidationReportType)element.getValue();
        }
        catch (Throwable throwable) {
            try {
                StreamTools.close((Closeable)is);
                throw throwable;
            }
            catch (JAXBException e) {
                throw new IOException(e);
            }
        }
        StreamTools.close((Closeable)is);
        return validationReportType;
    }

    public static void serializeReport(ExtendedValidationReportType report, ILocator locator) throws IOException {
        QName qName = new QName(NS_ExtendedValidationReport_1_2, "ExtendedValidationReport");
        ETSIReportTools.basicSerializeReport(report, qName, locator);
    }

    public static void serializeReport(ValidationReportType report, ILocator locator) throws IOException {
        QName qName = new QName(NS_ValidationReport_1_2, "ValidationReport");
        ETSIReportTools.basicSerializeReport(report, qName, locator);
    }

    private ETSIReportTools() {
    }
}

