/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.report.etsi;

import java.util.Arrays;

public enum MessageType {
    INFO(2, "Info", "urn:intarsys:validation:message:info"),
    WARNING(1, "Warning", "urn:intarsys:validation:message:warning"),
    ERROR(0, "Error", "urn:intarsys:validation:message:error");

    private final int severity;
    private final String label;
    private final String uri;

    public static MessageType ofSeverity(int severity) {
        return Arrays.stream(MessageType.values()).filter(e -> e.getSeverity() == severity).findFirst().orElse(null);
    }

    public static MessageType ofUri(String uri) {
        return Arrays.stream(MessageType.values()).filter(e -> e.getUri().equals(uri)).findFirst().orElse(null);
    }

    private MessageType(int severity, String label, String uri) {
        this.severity = severity;
        this.label = label;
        this.uri = uri;
    }

    public String getLabel() {
        return this.label;
    }

    public int getSeverity() {
        return this.severity;
    }

    public String getUri() {
        return this.uri;
    }
}

