/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.report.etsi;

import java.util.Arrays;

public enum RevocationReason {
    unspecified(0, "urn:etsi:019102:revocationReason:unspecified"),
    keyCompromise(1, "urn:etsi:019102:revocationReason:keyCompromise"),
    cACompromise(2, "urn:etsi:019102:revocationReason:cACompromise"),
    affiliationChanged(3, "urn:etsi:019102:revocationReason:affiliationChanged"),
    superseded(4, "urn:etsi:019102:revocationReason:superseded"),
    cessationOfOperation(5, "urn:etsi:019102:revocationReason:cessationOfOperation"),
    certificateHold(6, "urn:etsi:019102:revocationReason:certificateHold"),
    privilegeWithdrawn(9, "urn:etsi:019102:revocationReason:privilegeWithdrawn");

    private int value;
    private String uri;

    public static RevocationReason ofUri(String uri) {
        return Arrays.stream(RevocationReason.values()).filter(e -> e.getUri().equals(uri)).findFirst().orElse(null);
    }

    public static RevocationReason ofValue(int value) {
        return Arrays.stream(RevocationReason.values()).filter(e -> e.getValue() == value).findFirst().orElse(null);
    }

    private RevocationReason(int value, String uri) {
        this.value = value;
        this.uri = uri;
    }

    public String getUri() {
        return this.uri;
    }

    public int getValue() {
        return this.value;
    }
}

