/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.report.etsi;

import java.util.Arrays;

public enum SignatureQuality {
    ELDIVESIG("ElDI-V", "ElDI-V Electronic Signature", "urn:intarsys:signature:signatureQualification:ElDIV"),
    REGESIG("RegESig", "Regulated Electronic Signature", "urn:intarsys:signature:signatureQualification:RegESig"),
    REGESEAL("RegESeal", "Regulated Electronic Seal", "urn:intarsys:signature:signatureQualification:RegESeal"),
    REGES("RegES?", "Regulated Electronic Signature or Seal", "urn:intarsys:signature:signatureQualification:RegES"),
    QESIG("QESig", "Qualified Electronic Signature", "urn:etsi:019102:signatureQualification:QESig"),
    QESEAL("QESeal", "Qualified Electronic Seal", "urn:etsi:019102:signatureQualification:QESeal"),
    QES("QES?", "Qualified Electronic Signature or Seal", "urn:etsi:019102:signatureQualification:QES"),
    ADESIG_QC("AdESig-QC", "Advanced Electronic Signature supported by a Qualified Certificate", "urn:etsi:019102:signatureQualification:AdESigQC"),
    ADESEAL_QC("AdESeal-QC", "Advanced Electronic Seal supported by a Qualified Certificate", "urn:etsi:019102:signatureQualification:AdESealQC"),
    ADES_QC("AdES?-QC", "Advanced Electronic Signature or Seal supported by a Qualified Certificate", "urn:etsi:019102:signatureQualification:AdESQC"),
    ADESIG("AdESig", "Advanced Electronic Signature", "urn:etsi:019102:signatureQualification:AdESig"),
    ADESEAL("AdESeal", "Advanced Electronic Seal", "urn:etsi:019102:signatureQualification:AdESeal"),
    ADES("AdES?", "Advanced Electronic Signature or Seal", "urn:etsi:019102:signatureQualification:AdES"),
    INDETERMINATE_QESIG("Indeterminate QESig", "Indeterminate Qualified Electronic Signature", "urn:etsi:019102:signatureQualification:indeterminateQESig"),
    INDETERMINATE_QESEAL("Indeterminate QESeal", "Indeterminate Qualified Electronic Seal", "urn:etsi:019102:signatureQualification:indeterminateQESeal"),
    INDETERMINATE_QES("Indeterminate QES?", "Indeterminate Qualified Electronic Signature or Seal", "urn:etsi:019102:signatureQualification:indeterminateQES"),
    INDETERMINATE_ADESIG_QC("Indeterminate AdESig-QC", "Indeterminate Advanced Electronic Signature supported by a Qualified Certificate", "urn:etsi:019102:signatureQualification:indeterminateAdESigQC"),
    INDETERMINATE_ADESEAL_QC("Indeterminate AdESeal-QC", "Indeterminate Advanced Electronic Seal supported by a Qualified Certificate", "urn:etsi:019102:signatureQualification:indeterminateAdESealQC"),
    INDETERMINATE_ADES_QC("Indeterminate AdES?-QC", "Indeterminate Advanced Electronic Signature or Seal supported by a Qualified Certificate", "urn:etsi:019102:signatureQualification:indeterminateAdESQC"),
    INDETERMINATE_ADESIG("Indeterminate AdESig", "Indeterminate Advanced Electronic Signature", "urn:etsi:019102:signatureQualification:indeterminateAdESig"),
    INDETERMINATE_ADESEAL("Indeterminate AdESeal", "Indeterminate Advanced Electronic Seal", "urn:etsi:019102:signatureQualification:indeterminateAdESeal"),
    INDETERMINATE_ADES("Indeterminate AdES?", "Indeterminate Advanced Electronic Signature or Seal", "urn:etsi:019102:signatureQualification:indeterminateAdES"),
    NOT_ADES_QC_QSCD("Not AdES but QC with QSCD", "Not Advanced Electronic Signature but supported by a Qualified Certificate and a Qualified Signature Creation Device", "urn:etsi:019102:signatureQualification:notAdESbutQCwithQSCD"),
    NOT_ADES_QC("Not AdES but QC", "Not Advanced Electronic Signature but supported by a Qualified Certificate", "urn:etsi:019102:signatureQualification:notAdESbutQC"),
    NOT_ADES("Not AdES", "Not Advanced Electronic Signature", "urn:etsi:019102:signatureQualification:notAdES"),
    NA("N/A", "Not applicable", "urn:etsi:019102:signatureQualification:notApplicable");

    private final String readable;
    private final String label;
    private final String uri;

    public static SignatureQuality ofUri(String uri) {
        return Arrays.stream(SignatureQuality.values()).filter(e -> e.getUri().equals(uri)).findFirst().orElse(null);
    }

    private SignatureQuality(String readable, String label, String uri) {
        this.readable = readable;
        this.label = label;
        this.uri = uri;
    }

    public String getLabel() {
        return this.label;
    }

    public String getReadable() {
        return this.readable;
    }

    public String getUri() {
        return this.uri;
    }
}

