/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.report.etsi;

import java.util.Arrays;
import java.util.Optional;

public enum StatusMainIndication {
    TOTAL_PASSED("TOTAL-PASSED", "urn:etsi:019102:mainindication:total-passed", 0),
    PASSED("PASSED", "urn:etsi:019102:mainindication:passed", 1),
    TOTAL_FAILED("TOTAL-FAILED", "urn:etsi:019102:mainindication:total-failed", 10),
    FAILED("FAILED", "urn:etsi:019102:mainindication:failed", 9),
    INDETERMINATE("INDETERMINATE", "urn:etsi:019102:mainindication:indeterminate", 5);

    private String name;
    private String uri;
    private int severity;

    public static StatusMainIndication getWorse(StatusMainIndication status1, StatusMainIndication status2) {
        if (status2.getSeverity() > status1.getSeverity()) {
            return status2;
        }
        return status1;
    }

    public static Optional<StatusMainIndication> ofName(String name) {
        return Arrays.stream(StatusMainIndication.values()).filter(e -> e.getName().equals(name)).findFirst();
    }

    public static Optional<StatusMainIndication> ofUri(String uri) {
        return Arrays.stream(StatusMainIndication.values()).filter(e -> e.getUri().equals(uri)).findFirst();
    }

    private StatusMainIndication(String name, String uri, int severity) {
        this.name = name;
        this.uri = uri;
        this.severity = severity;
    }

    public String getName() {
        return this.name;
    }

    private int getSeverity() {
        return this.severity;
    }

    public String getUri() {
        return this.uri;
    }

    public boolean isFailed() {
        return this == TOTAL_FAILED || this == FAILED;
    }

    public boolean isIndeterminate() {
        return this == INDETERMINATE;
    }

    public boolean isPassed() {
        return this == TOTAL_PASSED || this == PASSED;
    }
}

