/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.report.etsi;

import java.util.Arrays;
import java.util.Optional;

public enum TypeOfProof {
    VALIDATION("urn:etsi:019102:poetype:validation"),
    PROVIDED("urn:etsi:019102:poetype:provided"),
    POLICY("urn:etsi:019102:poetype:policy");

    private String uri;

    public static Optional<TypeOfProof> ofUri(String uri) {
        return Arrays.stream(TypeOfProof.values()).filter(e -> e.getUri().equals(uri)).findFirst();
    }

    private TypeOfProof(String uri) {
        this.uri = uri;
    }

    public String getUri() {
        return this.uri;
    }

    public boolean isPolicy() {
        return this == POLICY;
    }

    public boolean isProvided() {
        return this == PROVIDED;
    }

    public boolean isValidation() {
        return this == VALIDATION;
    }
}

