/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.report.etsi;

import java.util.Arrays;

public enum ValidationObjectType {
    CERTIFICATE("urn:etsi:019102:validationObject:certificate"),
    CRL("urn:etsi:019102:validationObject:CRL"),
    OCSPRESPONSE("urn:etsi:019102:validationObject:OCSPResponse"),
    TIMESTAMP("urn:etsi:019102:validationObject:timestamp"),
    EVIDENCERECORD("urn:etsi:019102:validationObject:evidencerecord"),
    PUBLICKEY("urn:etsi:019102:validationObject:publicKey"),
    SIGNEDDATA("urn:etsi:019102:validationObject:signedData"),
    OTHER("urn:etsi:019102:validationObject:other");

    private String uri;

    public static ValidationObjectType ofUri(String uri) {
        return Arrays.stream(ValidationObjectType.values()).filter(e -> e.getUri().equals(uri)).findFirst().orElse(null);
    }

    private ValidationObjectType(String uri) {
        this.uri = uri;
    }

    public String getUri() {
        return this.uri;
    }
}

