/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.report.etsi;

import java.util.Arrays;
import java.util.Optional;

public enum ValidationProcessIdentifier {
    Basic("urn:etsi:019102:validationprocess:Basic"),
    LTVM("urn:etsi:019102:validationprocess:LTVM"),
    LTA("urn:etsi:019102:validationprocess:LTA");

    private String uri;

    public static Optional<ValidationProcessIdentifier> ofUri(String uri) {
        return Arrays.stream(ValidationProcessIdentifier.values()).filter(e -> e.getUri().equals(uri)).findFirst();
    }

    private ValidationProcessIdentifier(String uri) {
        this.uri = uri;
    }

    public String getUri() {
        return this.uri;
    }

    public boolean isBasic() {
        return this == Basic;
    }

    public boolean isLTA() {
        return this == LTA;
    }

    public boolean isLTVM() {
        return this == LTVM;
    }
}

