/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.report.etsi.builder;

import de.intarsys.security.report.etsi.builder.BuilderException;
import de.intarsys.security.report.etsi.builder.IValidationObjectContext;
import de.intarsys.security.report.etsi.builder.ValidationObjectContext;
import de.intarsys.security.report.etsi.builder.ValidationReportBuilderContext;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.etsi.uri._019102.v1_2.ObjectFactory;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AbstractBuilder<T> {
    protected static final ObjectFactory VR12F = new ObjectFactory();
    protected static final de.intarsys.evr.v1_2.ObjectFactory EVR12F = new de.intarsys.evr.v1_2.ObjectFactory();
    protected static final org.w3._2000._09.xmldsig.ObjectFactory XmlDSigOF = new org.w3._2000._09.xmldsig.ObjectFactory();
    protected static final org.etsi.uri._01903.v1_3.ObjectFactory XadesOF = new org.etsi.uri._01903.v1_3.ObjectFactory();
    protected static final org.etsi.uri._02231.v2.ObjectFactory TslOF = new org.etsi.uri._02231.v2.ObjectFactory();
    private final ValidationReportBuilderContext context;
    private IValidationObjectContext validationObjectContext;

    public static Duration toDuration(BigInteger seconds, BigInteger millis, BigInteger micros) throws BuilderException {
        Duration duration;
        if (seconds == null && millis == null && micros == null) {
            return null;
        }
        BigDecimal decSeconds = BigDecimal.ZERO;
        if (seconds != null) {
            decSeconds.add(BigDecimal.valueOf(seconds.longValue()));
        }
        if (millis != null) {
            decSeconds.add(BigDecimal.valueOf(millis.longValue()).divide(BigDecimal.valueOf(1000L)));
        }
        if (micros != null) {
            decSeconds.add(BigDecimal.valueOf(micros.longValue()).divide(BigDecimal.valueOf(1000000L)));
        }
        try {
            duration = DatatypeFactory.newInstance().newDuration(true, BigInteger.ZERO, BigInteger.ZERO, BigInteger.ZERO, BigInteger.ZERO, BigInteger.ZERO, decSeconds);
        }
        catch (DatatypeConfigurationException e) {
            throw new BuilderException(e.getLocalizedMessage(), e);
        }
        return duration;
    }

    public static Element toElement(String value) throws BuilderException {
        DocumentBuilder builder;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new BuilderException(e);
        }
        DOMImplementation impl = builder.getDOMImplementation();
        Document doc = impl.createDocument(null, null, null);
        Element element = doc.createElement("stringvalue");
        element.setTextContent(value);
        return element;
    }

    public static XMLGregorianCalendar toXMLGregorianCalender(Date date) throws BuilderException {
        XMLGregorianCalendar xmlCalendar;
        if (date == null) {
            return null;
        }
        GregorianCalendar calendar = (GregorianCalendar)GregorianCalendar.getInstance();
        calendar.setTime(date);
        try {
            xmlCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(calendar);
        }
        catch (DatatypeConfigurationException e) {
            throw new BuilderException(e.getLocalizedMessage(), e);
        }
        return xmlCalendar;
    }

    public AbstractBuilder(ValidationReportBuilderContext context) {
        this.context = context;
    }

    public abstract T build() throws BuilderException;

    protected <U> U delegateBuild(AbstractBuilder<U> delegateBuilder) throws BuilderException {
        delegateBuilder.setValidationObjectContext(this.getValidationObjectContext());
        U result = delegateBuilder.build();
        return result;
    }

    public ValidationReportBuilderContext getContext() {
        return this.context;
    }

    public IValidationObjectContext getValidationObjectContext() {
        if (this.validationObjectContext == null) {
            this.validationObjectContext = new ValidationObjectContext();
        }
        return this.validationObjectContext;
    }

    public void setValidationObjectContext(IValidationObjectContext validationObjectContext) {
        this.validationObjectContext = validationObjectContext;
    }
}

