/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.report.etsi.builder;

import de.intarsys.evr.v1_2.CertificateContentType;
import de.intarsys.evr.v1_2.ExtensionsType;
import de.intarsys.evr.v1_2.ValidityPeriodType;
import de.intarsys.security.algorithm.common.SignatureAlgorithm;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.method.xml.common.XMLDSigTools;
import de.intarsys.security.report.etsi.builder.AbstractBuilder;
import de.intarsys.security.report.etsi.builder.BuilderException;
import de.intarsys.security.report.etsi.builder.ExtensionsBuilder;
import de.intarsys.security.report.etsi.builder.ValidationReportBuilderContext;
import de.intarsys.security.validation.IVSCertificate;
import de.intarsys.security.validation.IValidationState;
import java.math.BigInteger;
import java.security.cert.X509Extension;
import java.util.function.Predicate;

class CertificateContentBuilder
extends AbstractBuilder<CertificateContentType> {
    private final IVSCertificate certificateState;

    public CertificateContentBuilder(ValidationReportBuilderContext context, IVSCertificate certificateState) {
        super(context);
        this.certificateState = certificateState;
    }

    @Override
    public CertificateContentType build() throws BuilderException {
        CertificateContentType certificateContent = EVR12F.createCertificateContentType();
        certificateContent.setVersion(this.createVersion());
        certificateContent.setSerialNumber(this.getCertificate().getSerialNumber());
        certificateContent.setSignatureAlgorithm(this.createSignatureAlgorithm());
        certificateContent.setIssuer(this.getCertificate().getIssuerX500Principal().toString());
        certificateContent.setSubject(this.getCertificate().getSubjectX500Principal().toString());
        certificateContent.setValidityPeriod(this.createValidityPeriod());
        certificateContent.setExtensions(this.createExtensions());
        return certificateContent;
    }

    private ExtensionsType createExtensions() throws BuilderException {
        return this.delegateBuild(new ExtensionsBuilder(this.getContext(), (X509Extension)this.getCertificate(), (IValidationState)this.certificateState));
    }

    private String createSignatureAlgorithm() {
        String sigAlgOID = this.getCertificate().getSigAlgOID();
        if ("1.2.840.113549.1.1.10".equals(sigAlgOID)) {
            return SignatureAlgorithm.ALG_RSASSA_PSS.getName();
        }
        String jcaEnc = SignatureAlgorithm.getEncryptionAlgorithmName((String)sigAlgOID);
        String jcaDigest = SignatureAlgorithm.getHashAlgorithmName((String)this.getCertificate().getSigAlgOID());
        SignatureAlgorithm algorithm = XMLDSigTools.searchSignatureAlgorithm((Predicate[])new Predicate[]{a -> jcaEnc.equals(a.getEncryptionAlgorithm().getName()), a -> jcaDigest.equals(a.getDigestAlgorithm().getName())});
        return algorithm == null ? null : algorithm.getName();
    }

    private ValidityPeriodType createValidityPeriod() throws BuilderException {
        ValidityPeriodType validityPeriod = EVR12F.createValidityPeriodType();
        validityPeriod.setNotAfter(CertificateContentBuilder.toXMLGregorianCalender(this.getCertificate().getNotAfter()));
        validityPeriod.setNotBefore(CertificateContentBuilder.toXMLGregorianCalender(this.getCertificate().getNotBefore()));
        return validityPeriod;
    }

    private BigInteger createVersion() {
        return BigInteger.valueOf(this.getCertificate().getVersion());
    }

    protected IX509Certificate getCertificate() {
        return this.certificateState.getX509Certificate();
    }
}

