/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.report.etsi.builder;

import de.intarsys.evr.v1_2.ExtensionBaseType;
import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.report.etsi.ETSIReportTools;
import de.intarsys.security.report.etsi.builder.AbstractBuilder;
import de.intarsys.security.report.etsi.builder.BuilderException;
import de.intarsys.security.report.etsi.builder.ValidationReportBuilderContext;
import jakarta.xml.bind.JAXBElement;
import java.io.IOException;
import javax.xml.namespace.QName;
import org.bouncycastle.asn1.ASN1Primitive;
import org.etsi.uri._01903.v1_3.IdentifierType;
import org.etsi.uri._01903.v1_3.ObjectIdentifierType;
import org.etsi.uri._01903.v1_3.QualifierType;

public abstract class CommonExtensionBuilder
extends AbstractBuilder<JAXBElement<? extends ExtensionBaseType>> {
    private byte[] value;
    private boolean critical;
    private String oid;

    protected CommonExtensionBuilder(ValidationReportBuilderContext context) {
        super(context);
    }

    protected abstract ExtensionBaseType basicBuild() throws BuilderException;

    @Override
    public JAXBElement<? extends ExtensionBaseType> build() throws BuilderException {
        ExtensionBaseType extension = this.basicBuild();
        extension.setExtensionId(this.createObjectIdentifier(this.getOid()));
        extension.setCritical(this.isCritical());
        return new JAXBElement(new QName(ETSIReportTools.NS_ExtendedValidationReport_1_2, this.getElementName()), extension.getClass(), (Object)extension);
    }

    protected ObjectIdentifierType createObjectIdentifier(String oid) {
        ObjectIdentifierType objId = XadesOF.createObjectIdentifierType();
        IdentifierType identifier = XadesOF.createIdentifierType();
        identifier.setValue("urn:oid:" + oid);
        identifier.setQualifier(QualifierType.OID_AS_URN);
        objId.setIdentifier(identifier);
        return objId;
    }

    protected abstract String getElementName();

    public String getOid() {
        return this.oid;
    }

    public byte[] getValue() {
        return this.value;
    }

    public boolean isCritical() {
        return this.critical;
    }

    public void setCritical(boolean critical) {
        this.critical = critical;
    }

    public void setOid(String oid) {
        this.oid = oid;
    }

    public void setValue(byte[] value) {
        this.value = value;
    }

    protected ASN1Primitive unwrapValue() throws BuilderException {
        try {
            return CertificateTools.unwrapExtensionValue((byte[])this.getValue());
        }
        catch (IOException e) {
            throw new BuilderException(e);
        }
    }
}

