/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.report.etsi.builder;

import de.intarsys.security.report.etsi.builder.AbstractBuilder;
import de.intarsys.security.report.etsi.builder.BuilderException;
import de.intarsys.security.report.etsi.builder.DigestAlgAndValueBuilder;
import de.intarsys.security.report.etsi.builder.ValidationReportBuilderContext;
import de.intarsys.tools.digest.DigestTools;
import de.intarsys.tools.digest.IDigest;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;
import org.etsi.uri._01903.v1_3.DigestAlgAndValueType;
import org.etsi.uri._019102.v1_2.POEProvisioningType;
import org.etsi.uri._019102.v1_2.POEType;
import org.etsi.uri._019102.v1_2.SignatureValidationReportType;
import org.etsi.uri._019102.v1_2.ValidationObjectRepresentationType;
import org.etsi.uri._019102.v1_2.ValidationObjectType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommonValidationObjectBuilder
extends AbstractBuilder<ValidationObjectType> {
    private static final Logger Log = LoggerFactory.getLogger(CommonValidationObjectBuilder.class);
    private boolean includeBinary = true;

    public CommonValidationObjectBuilder(ValidationReportBuilderContext context) {
        super(context);
    }

    @Override
    public ValidationObjectType build() throws BuilderException {
        ValidationObjectType validationObject = VR12F.createValidationObjectType();
        validationObject.setId(UUID.randomUUID().toString());
        validationObject.setObjectType(this.getObjectType());
        ValidationObjectRepresentationType representation = VR12F.createValidationObjectRepresentationType();
        byte[] encoded = this.getEncoded();
        if (this.isIncludeBinary()) {
            representation.setBase64(encoded);
        }
        try {
            IDigest digest = this.getDigest(encoded);
            if (digest != null) {
                DigestAlgAndValueType digestAlgAndValue = new DigestAlgAndValueBuilder(this.getContext()).withDigest(digest).build();
                representation.setDigestAlgAndValue(digestAlgAndValue);
            }
        }
        catch (NoSuchAlgorithmException e) {
            Log.warn(e.getMessage(), (Throwable)e);
        }
        representation.setURI(null);
        validationObject.setValidationObject(representation);
        validationObject.setPOE(this.createPOE());
        validationObject.setPOEProvisioning(this.createPOEProvisioning());
        SignatureValidationReportType validationReport = this.createValidationReport();
        validationObject.setValidationReport(validationReport);
        return validationObject;
    }

    protected POEType createPOE() {
        return null;
    }

    protected POEProvisioningType createPOEProvisioning() throws BuilderException {
        return null;
    }

    protected abstract SignatureValidationReportType createValidationReport() throws BuilderException;

    protected IDigest getDigest(byte[] encoded) throws NoSuchAlgorithmException {
        IDigest digest = DigestTools.createDigester((String)"SHA-256").digest(encoded);
        return digest;
    }

    protected abstract byte[] getEncoded() throws BuilderException;

    protected abstract String getObjectType();

    public boolean isIncludeBinary() {
        return this.includeBinary;
    }

    public void setIncludeBinary(boolean includeBinary) {
        this.includeBinary = includeBinary;
    }
}

