/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.report.etsi.builder;

import de.intarsys.security.algorithm.common.DigestAlgorithm;
import de.intarsys.security.method.xml.common.XMLDSigTools;
import de.intarsys.security.report.etsi.builder.AbstractBuilder;
import de.intarsys.security.report.etsi.builder.BuilderException;
import de.intarsys.security.report.etsi.builder.ValidationReportBuilderContext;
import de.intarsys.security.validation.IVSDigest;
import de.intarsys.tools.digest.IDigest;
import org.etsi.uri._01903.v1_3.DigestAlgAndValueType;
import org.w3._2000._09.xmldsig.DigestMethodType;

public class DigestAlgAndValueBuilder
extends AbstractBuilder<DigestAlgAndValueType> {
    private byte[] digestValue;
    private String digestAlgo;

    public DigestAlgAndValueBuilder(ValidationReportBuilderContext context) {
        super(context);
    }

    @Override
    public DigestAlgAndValueType build() throws BuilderException {
        if (this.digestValue == null) {
            return null;
        }
        DigestAlgAndValueType digestAlgAndValue = XadesOF.createDigestAlgAndValueType();
        digestAlgAndValue.setDigestValue(this.digestValue);
        DigestMethodType digestMethod = XmlDSigOF.createDigestMethodType();
        DigestAlgorithm algo = XMLDSigTools.lookupDigestAlgorithm((String)this.digestAlgo);
        String algoUri = algo.getName();
        digestMethod.setAlgorithm(algoUri);
        digestAlgAndValue.setDigestMethod(digestMethod);
        return digestAlgAndValue;
    }

    public DigestAlgAndValueBuilder withDigest(IDigest digest) {
        this.digestValue = digest.getBytes();
        this.digestAlgo = digest.getAlgorithmName();
        return this;
    }

    public DigestAlgAndValueBuilder withDigestState(IVSDigest digestState) {
        if (digestState.getCalculatedDigest() != null && digestState.getAlgorithmSpec() != null) {
            this.digestValue = digestState.getCalculatedDigest();
            this.digestAlgo = digestState.getAlgorithmSpec().getAlgorithm().getOid();
        }
        return this;
    }
}

