/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.report.etsi.builder;

import de.intarsys.evr.v1_2.ExtExtendedKeyUsageType;
import de.intarsys.evr.v1_2.ExtensionBaseType;
import de.intarsys.security.report.etsi.ETSIReportTools;
import de.intarsys.security.report.etsi.builder.BuilderException;
import de.intarsys.security.report.etsi.builder.CommonExtensionBuilder;
import de.intarsys.security.report.etsi.builder.ValidationReportBuilderContext;
import jakarta.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.KeyPurposeId;

public class ExtExtendedKeyUsageBuilder
extends CommonExtensionBuilder {
    public ExtExtendedKeyUsageBuilder(ValidationReportBuilderContext context) {
        super(context);
    }

    @Override
    protected ExtensionBaseType basicBuild() throws BuilderException {
        ExtendedKeyUsage eku = ExtendedKeyUsage.getInstance((Object)this.unwrapValue());
        ExtExtendedKeyUsageType extension = EVR12F.createExtExtendedKeyUsageType();
        extension.setExtensionId(this.createObjectIdentifier(this.getOid()));
        extension.setCritical(this.isCritical());
        for (KeyPurposeId id : eku.getUsages()) {
            JAXBElement<String> element = this.idToElement(id);
            extension.getServerAuthOrClientAuthOrCodeSigning().add(element);
        }
        return extension;
    }

    @Override
    protected String getElementName() {
        return "ExtendedKeyUsage";
    }

    protected JAXBElement<String> idToElement(KeyPurposeId id) {
        String name = null;
        if (KeyPurposeId.id_kp_capwapAC.equals((Object)id)) {
            name = "CapwapAC";
        } else if (KeyPurposeId.id_kp_capwapWTP.equals((Object)id)) {
            name = "CapwapWTP";
        } else if (KeyPurposeId.id_kp_clientAuth.equals((Object)id)) {
            name = "ClientAuth";
        } else if (KeyPurposeId.id_kp_codeSigning.equals((Object)id)) {
            name = "CodeSigning";
        } else if (KeyPurposeId.id_kp_dvcs.equals((Object)id)) {
            name = "Dvcs";
        } else if (KeyPurposeId.id_kp_eapOverLAN.equals((Object)id)) {
            name = "EapOverLAN";
        } else if (KeyPurposeId.id_kp_eapOverPPP.equals((Object)id)) {
            name = "EapOverPPP";
        } else if (KeyPurposeId.id_kp_emailProtection.equals((Object)id)) {
            name = "EmailProtection";
        } else if (KeyPurposeId.id_kp_ipsecEndSystem.equals((Object)id)) {
            name = "IpsecEndSystem";
        } else if (KeyPurposeId.id_kp_ipsecIKE.equals((Object)id)) {
            name = "IpsecIKE";
        } else if (KeyPurposeId.id_kp_ipsecTunnel.equals((Object)id)) {
            name = "IpsecTunnel";
        } else if (KeyPurposeId.id_kp_ipsecUser.equals((Object)id)) {
            name = "IpsecUser";
        } else if (KeyPurposeId.id_kp_macAddress.equals((Object)id)) {
            name = "MacAddress";
        } else if (KeyPurposeId.id_kp_msSGC.equals((Object)id)) {
            name = "MsSGC";
        } else if (KeyPurposeId.id_kp_nsSGC.equals((Object)id)) {
            name = "NsSGC";
        } else if (KeyPurposeId.id_kp_OCSPSigning.equals((Object)id)) {
            name = "OCSPSigning";
        } else if (KeyPurposeId.id_kp_sbgpCertAAServerAuth.equals((Object)id)) {
            name = "SbgpCertAAServerAuth";
        } else if (KeyPurposeId.id_kp_scvp_responder.equals((Object)id)) {
            name = "Scvp_responder";
        } else if (KeyPurposeId.id_kp_scvpClient.equals((Object)id)) {
            name = "ScvpClient";
        } else if (KeyPurposeId.id_kp_scvpServer.equals((Object)id)) {
            name = "ScvpServer";
        } else if (KeyPurposeId.id_kp_serverAuth.equals((Object)id)) {
            name = "ServerAuth";
        } else if (KeyPurposeId.id_kp_smartcardlogon.equals((Object)id)) {
            name = "Smartcardlogon";
        } else if (KeyPurposeId.id_kp_timeStamping.equals((Object)id)) {
            name = "TimeStamping";
        }
        String value = null;
        if (name == null) {
            name = "Other";
            value = id.getId();
        }
        return new JAXBElement(new QName(ETSIReportTools.NS_ExtendedValidationReport_1_2, name), String.class, (Object)value);
    }
}

