/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.report.etsi.builder;

import de.intarsys.evr.v1_2.ExtKeyUsageType;
import de.intarsys.evr.v1_2.ExtensionBaseType;
import de.intarsys.security.report.etsi.builder.BuilderException;
import de.intarsys.security.report.etsi.builder.CommonExtensionBuilder;
import de.intarsys.security.report.etsi.builder.ValidationReportBuilderContext;
import org.bouncycastle.asn1.x509.KeyUsage;

public class ExtKeyUsageBuilder
extends CommonExtensionBuilder {
    public ExtKeyUsageBuilder(ValidationReportBuilderContext context) {
        super(context);
    }

    @Override
    protected ExtensionBaseType basicBuild() throws BuilderException {
        KeyUsage keyUsage = KeyUsage.getInstance((Object)this.unwrapValue());
        ExtKeyUsageType extension = EVR12F.createExtKeyUsageType();
        extension.setExtensionId(this.createObjectIdentifier(this.getOid()));
        extension.setCritical(this.isCritical());
        extension.setCRLSign(keyUsage.hasUsages(2));
        extension.setDataEncipherment(keyUsage.hasUsages(16));
        extension.setDecipherOnly(keyUsage.hasUsages(32768));
        extension.setDigitalSignature(keyUsage.hasUsages(128));
        extension.setEncipherOnly(keyUsage.hasUsages(1));
        extension.setKeyAgreement(keyUsage.hasUsages(8));
        extension.setKeyCertSign(keyUsage.hasUsages(4));
        extension.setKeyEncipherment(keyUsage.hasUsages(32));
        extension.setNonRepudiation(keyUsage.hasUsages(64));
        return extension;
    }

    @Override
    protected String getElementName() {
        return "KeyUsage";
    }
}

