/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.report.etsi.builder;

import de.intarsys.evr.v1_2.ExtensionBaseType;
import de.intarsys.evr.v1_2.ExtensionsType;
import de.intarsys.security.report.etsi.builder.AbstractBuilder;
import de.intarsys.security.report.etsi.builder.BuilderException;
import de.intarsys.security.report.etsi.builder.CommonExtensionBuilder;
import de.intarsys.security.report.etsi.builder.ExtExtendedKeyUsageBuilder;
import de.intarsys.security.report.etsi.builder.ExtGenericBuilder;
import de.intarsys.security.report.etsi.builder.ExtKeyUsageBuilder;
import de.intarsys.security.report.etsi.builder.ValidationReportBuilderContext;
import de.intarsys.security.validation.IValidationState;
import jakarta.xml.bind.JAXBElement;
import java.security.cert.X509Extension;

class ExtensionsBuilder
extends AbstractBuilder<ExtensionsType> {
    private final X509Extension x509Extensions;
    private final IValidationState targetState;

    public ExtensionsBuilder(ValidationReportBuilderContext context, X509Extension x509Extensions, IValidationState targetState) {
        super(context);
        this.x509Extensions = x509Extensions;
        this.targetState = targetState;
    }

    @Override
    public ExtensionsType build() throws BuilderException {
        JAXBElement<? extends ExtensionBaseType> extension;
        ExtensionsType extensionsType = EVR12F.createExtensionsType();
        for (String oid : this.x509Extensions.getCriticalExtensionOIDs()) {
            extension = this.createExtension(oid, true);
            extensionsType.getExtensionOrKeyUsageOrExtendedKeyUsage().add(extension);
        }
        for (String oid : this.x509Extensions.getNonCriticalExtensionOIDs()) {
            extension = this.createExtension(oid, false);
            extensionsType.getExtensionOrKeyUsageOrExtendedKeyUsage().add(extension);
        }
        return extensionsType;
    }

    protected CommonExtensionBuilder createBuilder(String oid) {
        switch (oid) {
            case "2.5.29.15": {
                return new ExtKeyUsageBuilder(this.getContext());
            }
            case "2.5.29.37": {
                return new ExtExtendedKeyUsageBuilder(this.getContext());
            }
        }
        return new ExtGenericBuilder(this.getContext());
    }

    private JAXBElement<? extends ExtensionBaseType> createExtension(String oid, boolean critical) throws BuilderException {
        CommonExtensionBuilder builder = this.createBuilder(oid);
        builder.setOid(oid);
        builder.setCritical(critical);
        byte[] extensionValue = this.x509Extensions.getExtensionValue(oid);
        builder.setValue(extensionValue);
        return this.delegateBuild(builder);
    }
}

