/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.report.etsi.builder;

import de.intarsys.evr.v1_2.SAOtherAttributeType;
import de.intarsys.security.certificate.IX509Attribute;
import de.intarsys.security.certificate.IX509AttributeCertificate;
import de.intarsys.security.report.etsi.ETSIReportTools;
import de.intarsys.security.report.etsi.EndorsementType;
import de.intarsys.security.report.etsi.builder.AbstractBuilder;
import de.intarsys.security.report.etsi.builder.BuilderException;
import de.intarsys.security.report.etsi.builder.VOTimestampBuilder;
import de.intarsys.security.report.etsi.builder.ValidationReportBuilderContext;
import de.intarsys.security.signature.ISignatureEntry;
import de.intarsys.security.signature.additionalinfo.IAdditionalInfoSet;
import de.intarsys.security.signature.attribute.IAttribute;
import de.intarsys.security.signature.attribute.IAttributeMap;
import de.intarsys.security.signature.attribute.IOtherAttribute;
import de.intarsys.security.signature.attribute.ISignatureTimestampAttribute;
import de.intarsys.security.signature.attribute.ISignerAttributesAttribute;
import de.intarsys.security.signature.attribute.ISignerAttributesV2Attribute;
import de.intarsys.security.validation.IVSSignatureEntry;
import de.intarsys.security.validation.IVSTimestamp;
import de.intarsys.security.validation.IVSTimestampEntry;
import de.intarsys.tools.adapter.AdapterTools;
import de.intarsys.tools.string.StringTools;
import jakarta.xml.bind.JAXBElement;
import java.io.IOException;
import java.util.List;
import javax.xml.namespace.QName;
import org.etsi.uri._019102.v1_2.AttributeBaseType;
import org.etsi.uri._019102.v1_2.SAContactInfoType;
import org.etsi.uri._019102.v1_2.SANameType;
import org.etsi.uri._019102.v1_2.SAOneSignerRoleType;
import org.etsi.uri._019102.v1_2.SAReasonType;
import org.etsi.uri._019102.v1_2.SASignerRoleType;
import org.etsi.uri._019102.v1_2.SATimestampType;
import org.etsi.uri._019102.v1_2.SignatureAttributesType;
import org.etsi.uri._019102.v1_2.VOReferenceType;
import org.etsi.uri._019102.v1_2.ValidationObjectType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignatureAttributesBuilder
extends AbstractBuilder<SignatureAttributesType> {
    private static final Logger Log = LoggerFactory.getLogger(SignatureAttributesBuilder.class);
    private IVSSignatureEntry state;
    private List<IVSTimestampEntry> documentTimestampStates;

    public SignatureAttributesBuilder(ValidationReportBuilderContext context, IVSSignatureEntry signatureEntryState) {
        super(context);
        this.state = signatureEntryState;
    }

    protected void addAttribute(QName attributeName, AttributeBaseType attribute, SignatureAttributesType resultAttributes) {
        JAXBElement attributeElement = new JAXBElement(attributeName, attribute.getClass(), (Object)attribute);
        resultAttributes.getSigningTimeOrSigningCertificateOrDataObjectFormat().add(attributeElement);
    }

    @Override
    public SignatureAttributesType build() throws BuilderException {
        SignatureAttributesType signatureAttributes = VR12F.createSignatureAttributesType();
        ISignatureEntry entry = this.getState().getEntry();
        this.processAttributes(entry.getSignedAttributes(), true, signatureAttributes);
        this.processAttributes(entry.getUnsignedAttributes(), false, signatureAttributes);
        this.processDocumentTimestamps(this.getDocumentTimestampStates(), signatureAttributes);
        IAdditionalInfoSet additionalInfoSet = (IAdditionalInfoSet)AdapterTools.getAdapter((Object)entry, IAdditionalInfoSet.class, null);
        if (additionalInfoSet != null) {
            this.processAdditionalInfos(additionalInfoSet, signatureAttributes);
        }
        return signatureAttributes;
    }

    protected AttributeBaseType createAttributeType(IAttribute attribute, boolean signed) {
        return null;
    }

    protected SATimestampType createDocumentTimestamp(IVSTimestampEntry timestampEntry) throws BuilderException {
        IVSTimestamp timestampState = timestampEntry.getTimestampState();
        return this.createTimestamp(timestampState);
    }

    protected AttributeBaseType createOther(IAttribute iAttribute) throws BuilderException {
        SAOtherAttributeType attributeType = EVR12F.createSAOtherAttributeType();
        attributeType.setType(iAttribute.getOID());
        if (iAttribute instanceof IOtherAttribute) {
            IOtherAttribute otherAttribute = (IOtherAttribute)iAttribute;
            for (int i = 0; i < otherAttribute.size(); ++i) {
                attributeType.getValue().add(otherAttribute.getValue(i));
            }
        }
        return attributeType;
    }

    protected SATimestampType createSignatureTimestamp(ISignatureTimestampAttribute iAttribute) throws BuilderException {
        if (this.getState().getTimestampStates().size() != 1) {
            return null;
        }
        IVSTimestamp timestampState = (IVSTimestamp)this.getState().getTimestampStates().get(0);
        return this.createTimestamp(timestampState);
    }

    protected SASignerRoleType createSignerAttributes(ISignerAttributesAttribute iAttribute) throws BuilderException {
        return this.createSignerAttributes(iAttribute.getClaimedAttributes(), iAttribute.getCertifiedAttributes());
    }

    protected SASignerRoleType createSignerAttributes(ISignerAttributesV2Attribute iAttribute) throws BuilderException {
        return this.createSignerAttributes(iAttribute.getClaimedAttributes(), iAttribute.getCertifiedAttributes());
    }

    protected SASignerRoleType createSignerAttributes(IX509Attribute[] claimedAttributes, IX509AttributeCertificate[] certifiedAttributes) throws BuilderException {
        SASignerRoleType signerRoles = VR12F.createSASignerRoleType();
        for (IX509Attribute iX509Attribute : claimedAttributes) {
            SAOneSignerRoleType signerRole = this.createSignerRole(iX509Attribute, EndorsementType.claimed);
            if (signerRole == null) continue;
            signerRoles.getRoleDetails().add(signerRole);
        }
        for (IX509Attribute iX509Attribute : certifiedAttributes) {
            IX509Attribute[] attributes;
            for (IX509Attribute attribute : attributes = iX509Attribute.getX509Attributes()) {
                SAOneSignerRoleType signerRole = this.createSignerRole(attribute, EndorsementType.certified);
                if (signerRole == null) continue;
                signerRoles.getRoleDetails().add(signerRole);
            }
        }
        if (signerRoles.getRoleDetails().isEmpty()) {
            return null;
        }
        return signerRoles;
    }

    protected SAOneSignerRoleType createSignerRole(IX509Attribute attribute, EndorsementType endorsementType) {
        SAOneSignerRoleType signerRole = VR12F.createSAOneSignerRoleType();
        signerRole.setEndorsementType(endorsementType.name());
        signerRole.setRole(attribute.getStringValue());
        return signerRole;
    }

    protected SATimestampType createTimestamp(IVSTimestamp timestampState) throws BuilderException {
        ValidationObjectType vo = this.getValidationObjectContext().getOrCreateValidationObject(timestampState, () -> this.delegateBuild(new VOTimestampBuilder(this.getContext(), timestampState)));
        VOReferenceType voReference = VR12F.createVOReferenceType();
        voReference.getVOReference().add(vo);
        SATimestampType timestampType = VR12F.createSATimestampType();
        timestampType.setTimeStampValue(vo.getPOEProvisioning().getPOETime());
        timestampType.getAttributeObject().add(voReference);
        return timestampType;
    }

    public List<IVSTimestampEntry> getDocumentTimestampStates() {
        return this.documentTimestampStates;
    }

    private IVSSignatureEntry getState() {
        return this.state;
    }

    protected void processAdditionalInfos(IAdditionalInfoSet additionalInfoSet, SignatureAttributesType resultAttributes) {
        QName attributeName;
        AttributeBaseType attribute;
        String value = additionalInfoSet.getValue("Reason");
        if (!StringTools.isEmpty((String)value)) {
            attribute = VR12F.createSAReasonType();
            attribute.setSigned(true);
            ((SAReasonType)attribute).setReasonElement(value);
            attributeName = new QName(ETSIReportTools.NS_ValidationReport_1_2, "Reason");
            this.addAttribute(attributeName, attribute, resultAttributes);
        }
        if (!StringTools.isEmpty((String)(value = additionalInfoSet.getValue("Name")))) {
            attribute = VR12F.createSANameType();
            attribute.setSigned(true);
            ((SANameType)attribute).setNameElement(value);
            attributeName = new QName(ETSIReportTools.NS_ValidationReport_1_2, "Name");
            this.addAttribute(attributeName, attribute, resultAttributes);
        }
        if (!StringTools.isEmpty((String)(value = additionalInfoSet.getValue("ContactInfo")))) {
            attribute = VR12F.createSAContactInfoType();
            attribute.setSigned(true);
            ((SAContactInfoType)attribute).setContactInfoElement(value);
            attributeName = new QName(ETSIReportTools.NS_ValidationReport_1_2, "ContactInfo");
            this.addAttribute(attributeName, attribute, resultAttributes);
        }
    }

    protected void processAttributes(IAttributeMap attributes, boolean signed, SignatureAttributesType resultAttributes) {
        if (attributes == null) {
            return;
        }
        QName attributeName = null;
        for (String oid : attributes.getOIDs()) {
            IAttribute iAttribute;
            try {
                iAttribute = attributes.get(oid);
            }
            catch (IOException e) {
                Log.debug("Undecodable attribute {}: {}", (Object)oid, (Object)e.getMessage());
                continue;
            }
            AttributeBaseType attribute = null;
            if (iAttribute instanceof ISignatureTimestampAttribute) {
                attribute = this.createSignatureTimestamp((ISignatureTimestampAttribute)iAttribute);
                attributeName = new QName(ETSIReportTools.NS_ValidationReport_1_2, "SignatureTimeStamp");
            } else if (iAttribute instanceof ISignerAttributesAttribute) {
                attribute = this.createSignerAttributes((ISignerAttributesAttribute)iAttribute);
                attributeName = new QName(ETSIReportTools.NS_ValidationReport_1_2, "SignerRole");
            } else if (iAttribute instanceof ISignerAttributesV2Attribute) {
                attribute = this.createSignerAttributes((ISignerAttributesV2Attribute)iAttribute);
                attributeName = new QName(ETSIReportTools.NS_ValidationReport_1_2, "SignerRole");
            }
            if (attribute == null) {
                attribute = this.createOther(iAttribute);
                attributeName = new QName(ETSIReportTools.NS_ExtendedValidationReport_1_2, "OtherAttribute");
            }
            attribute.setSigned(signed);
            this.addAttribute(attributeName, attribute, resultAttributes);
        }
    }

    protected void processDocumentTimestamps(List<IVSTimestampEntry> documentTimestampStates, SignatureAttributesType resultAttributes) {
        if (documentTimestampStates == null) {
            return;
        }
        for (IVSTimestampEntry documentTimestampState : documentTimestampStates) {
            SATimestampType attribute = this.createDocumentTimestamp(documentTimestampState);
            attribute.setSigned(false);
            JAXBElement attributeElement = new JAXBElement(new QName(ETSIReportTools.NS_ValidationReport_1_2, "DocTimeStamp"), attribute.getClass(), (Object)attribute);
            resultAttributes.getSigningTimeOrSigningCertificateOrDataObjectFormat().add(attributeElement);
        }
    }

    public void setDocumentTimestampStates(List<IVSTimestampEntry> documentTimestampStates) {
        this.documentTimestampStates = documentTimestampStates;
    }
}

