/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.report.etsi.builder;

import de.intarsys.evr.v1_2.CertificateContentType;
import de.intarsys.evr.v1_2.CertificateValidationType;
import de.intarsys.evr.v1_2.DocumentInfoType;
import de.intarsys.evr.v1_2.IntegrityValidationType;
import de.intarsys.evr.v1_2.RevocationValidationType;
import de.intarsys.evr.v1_2.SignatureValidationProcessDetailType;
import de.intarsys.evr.v1_2.TSLInformationType;
import de.intarsys.evr.v1_2.TimestampValidationType;
import de.intarsys.evr.v1_2.TrustServiceType;
import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.certificate.ITrustService;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.IX509CertificatePath;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certificate.TrustServiceTools;
import de.intarsys.security.certificate.filter.IX509CertificateFilter;
import de.intarsys.security.certificate.provider.CertificateProvider;
import de.intarsys.security.certificate.provider.ICertificateProvider;
import de.intarsys.security.certificate.provider.standard.StandardCertificateProviderTools;
import de.intarsys.security.certificate.provider.standard.TrustedCertificateProvider;
import de.intarsys.security.document.validation.ISignedDocument;
import de.intarsys.security.document.validation.ISignedDocumentProvider;
import de.intarsys.security.report.etsi.AdESLevel;
import de.intarsys.security.report.etsi.ChangeLevel;
import de.intarsys.security.report.etsi.ETSIReportTools;
import de.intarsys.security.report.etsi.RevocationReason;
import de.intarsys.security.report.etsi.SignatureQuality;
import de.intarsys.security.report.etsi.StatusMainIndication;
import de.intarsys.security.report.etsi.StatusSubIndication;
import de.intarsys.security.report.etsi.TypeOfProof;
import de.intarsys.security.report.etsi.builder.AbstractBuilder;
import de.intarsys.security.report.etsi.builder.BuilderException;
import de.intarsys.security.report.etsi.builder.CertificateContentBuilder;
import de.intarsys.security.report.etsi.builder.DigestAlgAndValueBuilder;
import de.intarsys.security.report.etsi.builder.SignatureAttributesBuilder;
import de.intarsys.security.report.etsi.builder.VOCRLBuilder;
import de.intarsys.security.report.etsi.builder.VOCertificateBuilder;
import de.intarsys.security.report.etsi.builder.VOOCSPResponseBuilder;
import de.intarsys.security.report.etsi.builder.VOSignedDataBuilder;
import de.intarsys.security.report.etsi.builder.ValidationReportBuilderContext;
import de.intarsys.security.report.etsi.builder.ValidationStatusBuilder;
import de.intarsys.security.signature.ISignatureEntry;
import de.intarsys.security.validation.IQCInfo;
import de.intarsys.security.validation.IVSAdESLTV;
import de.intarsys.security.validation.IVSCertificate;
import de.intarsys.security.validation.IVSCertificatePath;
import de.intarsys.security.validation.IVSCrypto;
import de.intarsys.security.validation.IVSDigest;
import de.intarsys.security.validation.IVSModification;
import de.intarsys.security.validation.IVSOCSP;
import de.intarsys.security.validation.IVSQualification;
import de.intarsys.security.validation.IVSQualificationCertificate;
import de.intarsys.security.validation.IVSRevocation;
import de.intarsys.security.validation.IVSRevocationRequest;
import de.intarsys.security.validation.IVSSignature;
import de.intarsys.security.validation.IVSSignatureEntry;
import de.intarsys.security.validation.IVSTimestamp;
import de.intarsys.security.validation.IVSTimestampEntry;
import de.intarsys.security.validation.IVTCertificate;
import de.intarsys.security.validation.IValidationAspect;
import de.intarsys.security.validation.IValidationState;
import de.intarsys.security.validation.QCType;
import de.intarsys.tools.collection.NestedIterator;
import de.intarsys.tools.date.DateEnvironment;
import de.intarsys.tools.function.Predicates;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.streaming.StreamingTools;
import de.intarsys.tools.string.StringTools;
import jakarta.xml.bind.JAXBElement;
import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.xml.namespace.QName;
import org.etsi.uri._01903.v1_3.DigestAlgAndValueType;
import org.etsi.uri._019102.v1_2.CertificateChainType;
import org.etsi.uri._019102.v1_2.POEType;
import org.etsi.uri._019102.v1_2.RevocationStatusInformationType;
import org.etsi.uri._019102.v1_2.SignatureAttributesType;
import org.etsi.uri._019102.v1_2.SignatureIdentifierType;
import org.etsi.uri._019102.v1_2.SignatureQualityType;
import org.etsi.uri._019102.v1_2.SignatureValidationProcessType;
import org.etsi.uri._019102.v1_2.SignatureValidationReportType;
import org.etsi.uri._019102.v1_2.SignerInformationType;
import org.etsi.uri._019102.v1_2.SignersDocumentType;
import org.etsi.uri._019102.v1_2.VOReferenceType;
import org.etsi.uri._019102.v1_2.ValidationObjectType;
import org.etsi.uri._019102.v1_2.ValidationReportDataType;
import org.etsi.uri._019102.v1_2.ValidationStatusType;
import org.etsi.uri._019102.v1_2.ValidationTimeInfoType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignatureValidationReportBuilder
extends AbstractBuilder<SignatureValidationReportType> {
    private static final Logger Log = LoggerFactory.getLogger(SignatureValidationReportBuilder.class);
    private final IVSSignatureEntry state;
    private boolean totalStatus = true;
    private ISignedDocumentProvider signedDocumentProvider;
    private List<IVSTimestampEntry> documentTimestampStates;

    public SignatureValidationReportBuilder(ValidationReportBuilderContext context, IVSSignatureEntry signatureEntryState) {
        super(context);
        this.state = signatureEntryState;
    }

    @Override
    public SignatureValidationReportType build() throws BuilderException {
        SignatureValidationReportType signatureValidationReport = VR12F.createSignatureValidationReportType();
        signatureValidationReport.setSignatureIdentifier(this.createSignatureIdentifier());
        signatureValidationReport.setSignerInformation(this.createSignerInformation());
        signatureValidationReport.setValidationTimeInfo(this.createValidationTimeInfo());
        signatureValidationReport.setSignersDocument(this.createSignersDocument());
        signatureValidationReport.setSignatureQuality(this.createSignatureQuality());
        signatureValidationReport.setSignatureValidationProcess(this.createSignatureValidationProcess());
        signatureValidationReport.setSignatureAttributes(this.createSignatureAttributes());
        signatureValidationReport.setSignatureValidationStatus(this.createSignatureValidationStatus());
        return signatureValidationReport;
    }

    private Boolean checkStoredOnSSCD(IVSCertificate certificateState) {
        IVSQualificationCertificate qcState = certificateState.getQcState();
        boolean indicated = Optional.ofNullable(qcState).map(s -> s.getQcInfo()).map(i -> i.isStoredOnSSCD()).orElse(false);
        if (indicated) {
            return true;
        }
        return null;
    }

    private CertificateChainType createCertificateChain() {
        VOReferenceType voReference;
        ValidationObjectType voCertificate;
        IVSCertificate currentCertificateState;
        IVSCertificate certificateState = this.getState().getCertificateState();
        IVSCertificatePath certificatePathState = certificateState.getCertificatePathState();
        if (certificatePathState == null) {
            return null;
        }
        CertificateChainType certificateChain = VR12F.createCertificateChainType();
        IX509CertificatePath certPath = certificatePathState.getCertPath();
        IX509Certificate certificate = certPath.getLeafCertificate();
        IX509Certificate trustAnchor = certificatePathState.getTrustAnchor();
        if (certificate != null) {
            currentCertificateState = certificatePathState.getCertificateState(certificate);
            voCertificate = this.getValidationObjectContext().getOrCreateValidationObject(currentCertificateState, () -> this.delegateBuild(new VOCertificateBuilder(this.getContext(), currentCertificateState)));
            voReference = VR12F.createVOReferenceType();
            voReference.getVOReference().add(voCertificate);
            certificateChain.setSigningCertificate(voReference);
        }
        certificate = certPath.getIssuerCertificate(certificate);
        while (certificate != null && !certificate.equals(trustAnchor)) {
            currentCertificateState = certificatePathState.getCertificateState(certificate);
            voCertificate = this.getValidationObjectContext().getOrCreateValidationObject(currentCertificateState, () -> this.delegateBuild(new VOCertificateBuilder(this.getContext(), currentCertificateState)));
            voReference = VR12F.createVOReferenceType();
            voReference.getVOReference().add(voCertificate);
            certificateChain.getIntermediateCertificate().add(voReference);
            certificate = certPath.getIssuerCertificate(certificate);
        }
        if (certificate != null) {
            currentCertificateState = certificatePathState.getCertificateState(certificate);
            voCertificate = this.getValidationObjectContext().getOrCreateValidationObject(currentCertificateState, () -> this.delegateBuild(new VOCertificateBuilder(this.getContext(), currentCertificateState)));
            voReference = VR12F.createVOReferenceType();
            voReference.getVOReference().add(voCertificate);
            certificateChain.setTrustAnchor(voReference);
        }
        return certificateChain;
    }

    protected List<String> createCertificateStatusSubIndication() throws BuilderException {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        if (this.getState().getCertificateState() != null) {
            if (this.getState().getCertificateState().isInvalid()) {
                this.createCertificateStatusSubIndicationFailed(result);
            } else if (this.getState().getCertificateState().isUnknown()) {
                this.createCertificateStatusSubIndicationIndeterminate(result);
            }
        }
        return new ArrayList<String>(result);
    }

    protected void createCertificateStatusSubIndicationFailed(Set<String> result) throws BuilderException {
        if (this.getState().getCertificateState() != null && this.getState().getCertificateState().isInvalid()) {
            IVSOCSP revState;
            if (this.getState().getCertificateState().getValidityPeriodState().isInvalid()) {
                IX509PublicKeyCertificate certificate = (IX509PublicKeyCertificate)this.getState().getCertificateState().getValidationTarget().getImpl();
                Date refTime = this.getState().getReferenceDate();
                if (refTime.before(certificate.getNotBefore())) {
                    result.add(StatusSubIndication.NOT_YET_VALID.getUri());
                } else if (refTime.after(certificate.getNotAfter())) {
                    result.add(StatusSubIndication.EXPIRED.getUri());
                }
            }
            if ((revState = this.getState().getCertificateState().getOCSPState()) != null && revState.getSeverity() == 0 && revState.isInvalid()) {
                result.add(StatusSubIndication.REVOKED.getUri());
            }
            if ((revState = this.getState().getCertificateState().getCRLState()) != null && revState.getSeverity() == 0 && revState.isInvalid()) {
                result.add(StatusSubIndication.REVOKED.getUri());
            }
        }
    }

    protected void createCertificateStatusSubIndicationIndeterminate(Set<String> result) throws BuilderException {
        if (this.getState().getCertificateState() != null && this.getState().getCertificateState().isUnknown()) {
            IVSOCSP revState;
            IVSCertificatePath pathState = this.getState().getCertificateState().getCertificatePathState();
            if (pathState != null && !pathState.isValid() && pathState.getTrustAnchor() == null) {
                result.add(StatusSubIndication.NO_CERTIFICATE_CHAIN_FOUND.getUri());
            }
            if ((revState = this.getState().getCertificateState().getOCSPState()) != null && revState.getSeverity() == 0 && revState.isUnknown()) {
                result.add(StatusSubIndication.TRY_LATER.getUri());
            }
            if ((revState = this.getState().getCertificateState().getCRLState()) != null && revState.getSeverity() == 0 && revState.isUnknown()) {
                result.add(StatusSubIndication.TRY_LATER.getUri());
            }
            if (pathState != null && !pathState.isUnknown()) {
                result.add(StatusSubIndication.CERTIFICATE_CHAIN_GENERAL_FAILURE.getUri());
            }
        }
    }

    private CertificateValidationType createCertificateValidation() {
        CertificateValidationType result = EVR12F.createCertificateValidationType();
        result.setRevocationValidation(this.createRevocationValidation());
        ValidationStatusType validationStatus = this.delegateBuild(new ValidationStatusBuilder(this.getContext(), (IValidationState)this.getState().getCertificateState(), false));
        List<String> statusSubIndication = this.createCertificateStatusSubIndication();
        validationStatus.getSubIndication().addAll(statusSubIndication);
        result.setValidationStatus(validationStatus);
        result.setStoredOnSSCD(this.checkStoredOnSSCD(this.getState().getCertificateState()));
        return result;
    }

    protected void createCryptoStatusSubIndicationIndeterminate(Set<String> result) throws BuilderException {
        IValidationAspect cryptoAspect = this.getState().getAspect(IVSCrypto.class.getName());
        if (cryptoAspect == null) {
            return;
        }
        IVSCrypto cryptoState = (IVSCrypto)cryptoAspect.getState();
        if (cryptoState.isInvalid()) {
            result.add(StatusSubIndication.CRYPTO_CONSTRAINTS_FAILURE.getUri());
        }
    }

    private DigestAlgAndValueType createDigestAlgAndValue(IVSDigest digestState) {
        if (digestState == null) {
            return null;
        }
        return this.delegateBuild(new DigestAlgAndValueBuilder(this.getContext()).withDigestState(digestState));
    }

    protected List<String> createIntegrityStatusSubIndication() throws BuilderException {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        if (this.getState().getSignatureState() != null) {
            if (this.getState().getSignatureState().isInvalid()) {
                this.createIntegrityStatusSubIndicationFailed(result);
            } else if (this.getState().getSignatureState().isUnknown()) {
                this.createIntegrityStatusSubIndicationIndeterminate(result);
            }
        }
        return new ArrayList<String>(result);
    }

    protected void createIntegrityStatusSubIndicationFailed(Set<String> result) throws BuilderException {
        IVSSignature signatureState = this.getState().getSignatureState();
        if (signatureState != null) {
            for (IVSDigest digestState : signatureState.getDigestStates()) {
                if (!digestState.isInvalid()) continue;
                result.add(StatusSubIndication.HASH_FAILURE.getUri());
            }
            if (signatureState.getSignatureState() != null && signatureState.getSignatureState().isInvalid()) {
                result.add(StatusSubIndication.SIG_CRYPTO_FAILURE.getUri());
            }
        }
    }

    protected void createIntegrityStatusSubIndicationIndeterminate(Set<String> result) throws BuilderException {
        IVSSignature signatureState = this.getState().getSignatureState();
        if (signatureState != null) {
            for (IVSDigest digestState : signatureState.getDigestStates()) {
                if (!digestState.isUndefined() && !digestState.isUnknown()) continue;
                result.add(StatusSubIndication.SIGNED_DATA_NOT_FOUND.getUri());
            }
        }
    }

    private IntegrityValidationType createIntegrityValidation() {
        IntegrityValidationType result = EVR12F.createIntegrityValidationType();
        ValidationStatusType signatureStatus = this.delegateBuild(new ValidationStatusBuilder(this.getContext(), (IValidationState)this.getState().getSignatureState(), false));
        signatureStatus.getSubIndication().addAll(this.createIntegrityStatusSubIndication());
        ValidationStatusType modificationStatus = this.delegateBuild(new ValidationStatusBuilder(this.getContext(), (IValidationState)this.getState().getModificationState(), false));
        modificationStatus.getSubIndication().addAll(this.createModificationStatusSubIndication());
        ValidationStatusType validationStatus = this.merge(signatureStatus, modificationStatus);
        result.setValidationStatus(validationStatus);
        int changeLevel = this.getState().getModificationState().getChangeLevel();
        Optional<ChangeLevel> changeLevelObj = ChangeLevel.ofValue(changeLevel);
        if (changeLevelObj.isPresent()) {
            result.setChangeLevel(changeLevelObj.get().getUri());
        }
        return result;
    }

    protected List<String> createModificationStatusSubIndication() throws BuilderException {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        if (this.getState().getModificationState() != null) {
            if (this.getState().getModificationState().isInvalid()) {
                this.createModificationStatusSubIndicationFailed(result);
            } else if (this.getState().getModificationState().isUnknown()) {
                this.createModificationStatusSubIndicationIndeterminate(result);
            }
        }
        return new ArrayList<String>(result);
    }

    protected void createModificationStatusSubIndicationFailed(Set<String> result) throws BuilderException {
        IVSModification modificationState = this.getState().getModificationState();
        if (modificationState.isInvalid()) {
            result.add(StatusSubIndication.INVALID_MODIFICATIONS.getUri());
        }
    }

    protected void createModificationStatusSubIndicationIndeterminate(Set<String> result) throws BuilderException {
        IVSModification modificationState = this.getState().getModificationState();
        if (modificationState.isInvalid()) {
            result.add(StatusSubIndication.INVALID_MODIFICATIONS.getUri());
        }
    }

    private RevocationStatusInformationType createRevocationStatusInformation() {
        IVSCertificate certificateState = this.getState().getCertificateState();
        RevocationStatusInformationType result = this.createRevocationStatusInformation((IVSRevocation)certificateState.getOCSPState());
        ValidationObjectType revocationObject = null;
        if (result == null) {
            result = this.createRevocationStatusInformation((IVSRevocation)certificateState.getCRLState());
            if (result != null) {
                revocationObject = this.getValidationObjectContext().getOrCreateValidationObject(certificateState.getCRLState(), () -> this.delegateBuild(new VOCRLBuilder(this.getContext(), certificateState.getCRLState())));
            }
        } else {
            revocationObject = this.getValidationObjectContext().getOrCreateValidationObject(certificateState.getOCSPState(), () -> this.delegateBuild(new VOOCSPResponseBuilder(this.getContext(), certificateState.getOCSPState())));
        }
        if (result != null) {
            VOReferenceType revocationObjectReference = VR12F.createVOReferenceType();
            revocationObjectReference.getVOReference().add(revocationObject);
            result.setRevocationObject(revocationObjectReference);
            ValidationObjectType voCertificate = this.getValidationObjectContext().getOrCreateValidationObject(certificateState, () -> this.delegateBuild(new VOCertificateBuilder(this.getContext(), certificateState)));
            VOReferenceType certificateReference = VR12F.createVOReferenceType();
            certificateReference.getVOReference().add(voCertificate);
            result.setValidationObjectId(certificateReference);
        }
        return result;
    }

    private RevocationStatusInformationType createRevocationStatusInformation(IVSRevocation revocationState) {
        if (revocationState == null || revocationState.isUndefined() || revocationState.isValid()) {
            return null;
        }
        IVSRevocationRequest requestState = revocationState.getSuccessfulRequestState();
        if (requestState == null) {
            return null;
        }
        if (requestState.getRevocationDate() == null) {
            return null;
        }
        RevocationStatusInformationType revocationStatusInformation = VR12F.createRevocationStatusInformationType();
        revocationStatusInformation.setRevocationTime(SignatureValidationReportBuilder.toXMLGregorianCalender(requestState.getRevocationDate()));
        RevocationReason reason = RevocationReason.ofValue(requestState.getRevocationReason());
        if (reason == null) {
            reason = RevocationReason.unspecified;
        }
        revocationStatusInformation.setRevocationReason(reason.getUri());
        return revocationStatusInformation;
    }

    private RevocationValidationType createRevocationValidation() {
        RevocationValidationType result = EVR12F.createRevocationValidationType();
        IVSOCSP revState = null;
        if (this.getState().getCertificateState() != null) {
            IVSOCSP revStateCandidate = this.getState().getCertificateState().getOCSPState();
            if (revStateCandidate != null && revStateCandidate.getSeverity() == 0) {
                revState = revStateCandidate;
            } else {
                revStateCandidate = this.getState().getCertificateState().getCRLState();
                if (revStateCandidate != null && revStateCandidate.getSeverity() == 0) {
                    revState = revStateCandidate;
                }
            }
        }
        if (revState == null) {
            return null;
        }
        ValidationStatusType validationStatus = this.delegateBuild(new ValidationStatusBuilder(this.getContext(), (IValidationState)revState, false));
        result.setValidationStatus(validationStatus);
        return result;
    }

    private SignatureAttributesType createSignatureAttributes() {
        SignatureAttributesBuilder builder = new SignatureAttributesBuilder(this.getContext(), this.getState());
        builder.setDocumentTimestampStates(this.getDocumentTimestampStates());
        SignatureAttributesType signatureAttributes = this.delegateBuild(builder);
        return signatureAttributes;
    }

    private SignatureIdentifierType createSignatureIdentifier() {
        List digestStates;
        SignatureIdentifierType signatureIdentifier = VR12F.createSignatureIdentifierType();
        IVSSignature signatureState = this.getState().getSignatureState();
        if (signatureState != null && (digestStates = signatureState.getDigestStates()) != null && !digestStates.isEmpty()) {
            DigestAlgAndValueType digestAlgAndValue = this.createDigestAlgAndValue((IVSDigest)digestStates.iterator().next());
            signatureIdentifier.setDigestAlgAndValue(digestAlgAndValue);
        }
        signatureIdentifier.setHashOnly(false);
        signatureIdentifier.setDocHashOnly(false);
        return signatureIdentifier;
    }

    private SignatureQualityType createSignatureQuality() {
        IVSCertificate certificateState = this.getState().getCertificateState();
        if (certificateState == null || certificateState.isUndefined()) {
            return null;
        }
        String country = null;
        if (certificateState.getValidationTarget() instanceof IVTCertificate) {
            IVTCertificate vtCertificate = (IVTCertificate)certificateState.getValidationTarget();
            country = vtCertificate.getCountry();
        }
        if ("CH".equalsIgnoreCase(country)) {
            return this.createSignatureQualityCH();
        }
        return this.createSignatureQualityGeneral();
    }

    private SignatureQualityType createSignatureQualityCH() {
        IQCInfo qcInfo = null;
        IVSQualification qualificationState = this.getState().getQualificationState();
        if (qualificationState != null && !qualificationState.isUndefined()) {
            qcInfo = qualificationState.getQcInfo();
        }
        List qcTypes = qcInfo == null ? Collections.emptyList() : qcInfo.getQcTypes();
        SignatureQualityType signatureQualityType = VR12F.createSignatureQualityType();
        Optional<SignatureQuality> certificateQuality = this.getCertificateQualityFromPolicies(this.getState().getCertificateState());
        if (certificateQuality.isPresent()) {
            SignatureQuality regQuality = certificateQuality.get();
            if (regQuality == SignatureQuality.REGES) {
                if (qcTypes.contains(QCType.esign)) {
                    regQuality = SignatureQuality.REGESIG;
                } else if (qcTypes.contains(QCType.eseal)) {
                    regQuality = SignatureQuality.REGESEAL;
                }
            } else if (regQuality == SignatureQuality.QES) {
                regQuality = SignatureQuality.QESIG;
            }
            signatureQualityType.getSignatureQualityInformation().add(regQuality.getUri());
        }
        if (this.isElDIV(this.getState().getCertificateState())) {
            signatureQualityType.getSignatureQualityInformation().add(SignatureQuality.ELDIVESIG.getUri());
        }
        if (signatureQualityType.getSignatureQualityInformation().isEmpty()) {
            if (qualificationState != null && qualificationState.isValid()) {
                signatureQualityType.getSignatureQualityInformation().add(SignatureQuality.QES.getUri());
            } else {
                signatureQualityType.getSignatureQualityInformation().add(SignatureQuality.ADES.getUri());
            }
        }
        return signatureQualityType;
    }

    private SignatureQualityType createSignatureQualityGeneral() {
        IVSQualification qualificationState = this.getState().getQualificationState();
        if (qualificationState == null || qualificationState.isUndefined()) {
            return null;
        }
        IQCInfo qcInfo = qualificationState.getQcInfo();
        List qcTypes = qcInfo == null ? Collections.emptyList() : qcInfo.getQcTypes();
        SignatureQualityType signatureQualityType = VR12F.createSignatureQualityType();
        if (qualificationState.isValid()) {
            boolean defined = false;
            if (qcTypes.contains(QCType.esign)) {
                signatureQualityType.getSignatureQualityInformation().add(SignatureQuality.QESIG.getUri());
                defined = true;
            }
            if (qcTypes.contains(QCType.eseal)) {
                signatureQualityType.getSignatureQualityInformation().add(SignatureQuality.QESEAL.getUri());
                defined = true;
            }
            if (!defined) {
                signatureQualityType.getSignatureQualityInformation().add(SignatureQuality.QES.getUri());
            }
        }
        if (signatureQualityType.getSignatureQualityInformation().isEmpty()) {
            signatureQualityType.getSignatureQualityInformation().add(SignatureQuality.ADES.getUri());
        }
        return signatureQualityType;
    }

    private SignatureValidationProcessType createSignatureValidationProcess() {
        SignatureValidationProcessType signatureValidationProcess = VR12F.createSignatureValidationProcessType();
        SignatureValidationProcessDetailType processDetail = EVR12F.createSignatureValidationProcessDetailType();
        JAXBElement processDetailElement = new JAXBElement(new QName(ETSIReportTools.NS_ExtendedValidationReport_1_2, "SignatureValidationProcessDetail"), SignatureValidationProcessDetailType.class, (Object)processDetail);
        signatureValidationProcess.setAny(processDetailElement);
        processDetail.setAdESLevel(this.getAdESLevel());
        processDetail.setIntegrityValidation(this.createIntegrityValidation());
        processDetail.setCertificateValidation(this.createCertificateValidation());
        processDetail.setTimestampValidation(this.createTimestampValidation());
        processDetail.getTrustService().addAll(this.getTrustServices());
        return signatureValidationProcess;
    }

    private ValidationStatusType createSignatureValidationStatus() throws BuilderException {
        ValidationStatusType validationStatus = this.delegateBuild(new ValidationStatusBuilder(this.getContext(), (IValidationState)this.getState(), this.isTotalStatus()));
        validationStatus.getSubIndication().addAll(this.createStatusSubIndication());
        ValidationReportDataType validationReportData = new ValidationReportDataType();
        validationReportData.setCertificateChain(this.createCertificateChain());
        validationReportData.setRevocationStatusInformation(this.createRevocationStatusInformation());
        validationStatus.getAssociatedValidationReportData().add(validationReportData);
        return validationStatus;
    }

    private SignerInformationType createSignerInformation() {
        IVSCertificate certificateState;
        if (this.getState().getCertificateState() == null) {
            return null;
        }
        IVSCertificate baseCertificateState = this.getState().getCertificateState();
        IVSCertificatePath certificatePathState = baseCertificateState.getCertificatePathState();
        IVSCertificate iVSCertificate = certificateState = certificatePathState == null ? null : certificatePathState.getCertificateState(baseCertificateState.getX509Certificate());
        if (certificateState == null) {
            return null;
        }
        ValidationObjectType voCertificate = this.getValidationObjectContext().getOrCreateValidationObject(certificateState, () -> this.delegateBuild(new VOCertificateBuilder(this.getContext(), certificateState)));
        SignerInformationType signerInformation = VR12F.createSignerInformationType();
        VOReferenceType signerReference = VR12F.createVOReferenceType();
        signerReference.getVOReference().add(voCertificate);
        CertificateContentType certificateContent = this.delegateBuild(new CertificateContentBuilder(this.getContext(), certificateState));
        JAXBElement certificateContentElement = new JAXBElement(new QName(ETSIReportTools.NS_ExtendedValidationReport_1_2, "CertificateContent"), CertificateContentType.class, (Object)certificateContent);
        signerReference.setAny(certificateContentElement);
        signerInformation.setSignerCertificate(signerReference);
        IVTCertificate certificate = (IVTCertificate)certificateState.getValidationTarget();
        if (certificate != null && !StringTools.isEmpty((String)certificate.getPseudonym())) {
            signerInformation.setPseudonym(true);
        }
        return signerInformation;
    }

    private SignersDocumentType createSignersDocument() {
        ISignedDocument signedDocument;
        List digestStates;
        SignersDocumentType signersDocument = VR12F.createSignersDocumentType();
        IVSSignature signatureState = this.getState().getSignatureState();
        if (signatureState != null && (digestStates = signatureState.getDigestStates()) != null && !digestStates.isEmpty()) {
            DigestAlgAndValueType digestAlgAndValue = this.createDigestAlgAndValue((IVSDigest)digestStates.iterator().next());
            signersDocument.setDigestAlgAndValue(digestAlgAndValue);
        }
        if (this.getSignedDocumentProvider() != null && (signedDocument = this.getSignedDocumentProvider().getSignedDocument()) != null) {
            ILocator locator = signedDocument.getDocument().getLocator();
            VOSignedDataBuilder voSignedDataBuilder = new VOSignedDataBuilder(this.getContext(), signedDocument.getDocument());
            voSignedDataBuilder.setIncludeBinary(false);
            ValidationObjectType vo = this.getValidationObjectContext().getOrCreateValidationObject(locator, () -> this.delegateBuild(voSignedDataBuilder));
            DocumentInfoType documentInfo = EVR12F.createDocumentInfoType();
            documentInfo.setName(locator.getName());
            try {
                documentInfo.setSize(BigInteger.valueOf(locator.getLength()));
            }
            catch (IOException e) {
                Log.warn(e.getMessage(), (Throwable)e);
                documentInfo.setSize(BigInteger.valueOf(-1L));
            }
            vo.getValidationObject().setDirect(documentInfo);
            VOReferenceType voReference = VR12F.createVOReferenceType();
            voReference.getVOReference().add(vo);
            voReference.setAny(new JAXBElement(new QName(ETSIReportTools.NS_ExtendedValidationReport_1_2, "DocumentInfo"), DocumentInfoType.class, (Object)documentInfo));
            signersDocument.setSignersDocumentRef(voReference);
        }
        return signersDocument;
    }

    protected List<String> createStatusSubIndication() throws BuilderException {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        if (this.getState().isInvalid()) {
            this.createStatusSubIndicationFailed(result);
        }
        if (this.getState().isUnknown()) {
            this.createStatusSubIndicationIndeterminate(result);
        }
        return new ArrayList<String>(result);
    }

    protected void createStatusSubIndicationFailed(Set<String> result) throws BuilderException {
        this.createIntegrityStatusSubIndicationFailed(result);
        this.createModificationStatusSubIndicationFailed(result);
        this.createCertificateStatusSubIndicationFailed(result);
    }

    protected void createStatusSubIndicationIndeterminate(Set<String> result) throws BuilderException {
        this.createIntegrityStatusSubIndicationIndeterminate(result);
        this.createModificationStatusSubIndicationIndeterminate(result);
        this.createCertificateStatusSubIndicationIndeterminate(result);
        this.createCryptoStatusSubIndicationIndeterminate(result);
    }

    private TimestampValidationType createTimestampValidation() {
        TimestampValidationType result = EVR12F.createTimestampValidationType();
        List timestampStates = this.getState().getTimestampStates();
        if (timestampStates.isEmpty()) {
            return null;
        }
        IVSTimestamp timestampState = (IVSTimestamp)timestampStates.get(0);
        ValidationStatusType validationStatus = this.delegateBuild(new ValidationStatusBuilder(this.getContext(), (IValidationState)timestampState, false));
        result.setValidationStatus(validationStatus);
        return result;
    }

    private TrustServiceType createTrustServiceInfo(ITrustService trustService) {
        TrustServiceType trustServiceInfo = EVR12F.createTrustServiceType();
        trustServiceInfo.setServiceTypeIdentifier("");
        trustServiceInfo.setServiceName("");
        trustServiceInfo.setServiceProviderName("");
        TSLInformationType tslInfo = EVR12F.createTSLInformationType();
        tslInfo.setSchemeName("");
        tslInfo.getSchemeTerritory().addAll(trustService.getTerritories());
        trustServiceInfo.setTSLInformation(tslInfo);
        return trustServiceInfo;
    }

    private ValidationTimeInfoType createValidationTimeInfo() {
        ValidationTimeInfoType validationTimeInfo = VR12F.createValidationTimeInfoType();
        Date now = DateEnvironment.get().now();
        validationTimeInfo.setValidationTime(SignatureValidationReportBuilder.toXMLGregorianCalender(now));
        Date bestDate = this.getState().getCreationDate();
        if (bestDate == null) {
            bestDate = now;
        }
        POEType poeTime = VR12F.createPOEType();
        poeTime.setPOETime(SignatureValidationReportBuilder.toXMLGregorianCalender(bestDate));
        poeTime.setTypeOfProof(TypeOfProof.VALIDATION.getUri());
        validationTimeInfo.setBestSignatureTime(poeTime);
        return validationTimeInfo;
    }

    private String getAdESLevel() {
        boolean hasValidTimestamp = this.getState().getTimestampStates().stream().filter(s -> s.isValid()).findAny().isPresent();
        if (hasValidTimestamp) {
            IValidationAspect ltvAspect = this.getState().getAspect(IVSAdESLTV.class.getName());
            if (ltvAspect != null && ltvAspect.getState().isValid()) {
                return AdESLevel.B_LT.getName();
            }
            return AdESLevel.B_T.getName();
        }
        return AdESLevel.B_B.getName();
    }

    private Optional<SignatureQuality> getCertificateQualityFromPolicies(IVSCertificate certificateState) {
        if (certificateState == null) {
            return Optional.empty();
        }
        IX509Certificate certificate = certificateState.getX509Certificate();
        try {
            List policyNoticeTexts = CertificateTools.getPolicyNoticeTexts((IX509Certificate)certificate);
            if (policyNoticeTexts.stream().filter(text -> Pattern.matches("(?i).*qualified.*certificate.*|.*qualifiziertes zertifikat.*", text)).findAny().isPresent()) {
                return Optional.of(SignatureQuality.QES);
            }
            if (policyNoticeTexts.stream().filter(text -> Pattern.matches("(?i).*geregelt.*siegel.*", text)).findAny().isPresent()) {
                return Optional.of(SignatureQuality.REGESEAL);
            }
            if (policyNoticeTexts.stream().filter(text -> Pattern.matches("(?i).*geregelt.*signatur*", text)).findAny().isPresent()) {
                return Optional.of(SignatureQuality.REGESIG);
            }
            if (policyNoticeTexts.stream().filter(text -> Pattern.matches("(?i).*regulated certificate.*|.*geregelt.*zertifikat.*", text)).findAny().isPresent()) {
                return Optional.of(SignatureQuality.REGES);
            }
        }
        catch (IOException e) {
            Log.warn(e.getMessage(), (Throwable)e);
        }
        return Optional.empty();
    }

    public List<IVSTimestampEntry> getDocumentTimestampStates() {
        return this.documentTimestampStates;
    }

    private ISignatureEntry getSignatureEntry() {
        return this.getState().getEntry();
    }

    public ISignedDocumentProvider getSignedDocumentProvider() {
        return this.signedDocumentProvider;
    }

    private IVSSignatureEntry getState() {
        return this.state;
    }

    private List<TrustServiceType> getTrustServices() {
        if (this.getState().getCertificateState() == null || this.getState().getCertificateState().getValidationTarget() == null) {
            return Collections.emptyList();
        }
        IX509Certificate signerCertificate = (IX509Certificate)this.getState().getCertificateState().getValidationTarget().getImpl();
        if (signerCertificate == null) {
            return Collections.emptyList();
        }
        IX509Certificate storedSignerCertificate = StandardCertificateProviderTools.lookupStoredCertificate((ICertificateProvider)TrustedCertificateProvider.get(), (IX509Certificate)signerCertificate);
        signerCertificate = storedSignerCertificate == null ? signerCertificate : storedSignerCertificate;
        Stream<IX509Certificate> issuerCertificates = this.lookupIssuers(signerCertificate);
        return Stream.concat(Stream.of(signerCertificate), issuerCertificates).filter(Predicates.isNotNull()).map(TrustServiceTools::getTrustService).filter(Predicates.isNotNull()).distinct().map(this::createTrustServiceInfo).toList();
    }

    private boolean isElDIV(IVSCertificate certificateState) {
        if (certificateState == null || !certificateState.isValid()) {
            return false;
        }
        IX509Certificate certificate = certificateState.getX509Certificate();
        try {
            if (CertificateTools.hasPolicyNotice((IX509Certificate)certificate, (String)"(?i).*eldi-v.*|.*eldiv.*")) {
                return true;
            }
        }
        catch (IOException | CertificateException e) {
            Log.warn(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    public boolean isTotalStatus() {
        return this.totalStatus;
    }

    protected Stream<IX509Certificate> lookupIssuers(IX509Certificate signerCertificate) {
        IX509CertificateFilter[] issuerSelectors = CertificateTools.createIssuerSelectors((IX509Certificate)signerCertificate);
        ArrayList<Iterator> result = new ArrayList<Iterator>();
        for (IX509CertificateFilter issuerSelector : issuerSelectors) {
            if (issuerSelector == null) continue;
            Iterator iIssuerCertificates = CertificateProvider.get().lookupCertificates(issuerSelector);
            result.add(iIssuerCertificates);
        }
        return StreamingTools.asStream((Iterator)new NestedIterator(result.iterator()));
    }

    protected ValidationStatusType merge(ValidationStatusType ... statusTypes) {
        if (statusTypes.length == 0) {
            return null;
        }
        if (statusTypes.length == 1) {
            return statusTypes[0];
        }
        ValidationStatusType validationStatus = VR12F.createValidationStatusType();
        for (ValidationStatusType current : statusTypes) {
            if (validationStatus.getMainIndication() == null) {
                validationStatus.setMainIndication(current.getMainIndication());
            } else {
                validationStatus.setMainIndication(StatusMainIndication.getWorse(StatusMainIndication.ofUri(validationStatus.getMainIndication()).get(), StatusMainIndication.ofUri(current.getMainIndication()).get()).getUri());
            }
            validationStatus.getSubIndication().addAll(current.getSubIndication());
            validationStatus.getAssociatedValidationReportData().addAll(current.getAssociatedValidationReportData());
        }
        return validationStatus;
    }

    public void setDocumentTimestampStates(List<IVSTimestampEntry> documentTimestampStates) {
        this.documentTimestampStates = documentTimestampStates;
    }

    public void setSignedDocumentProvider(ISignedDocumentProvider signedDocumentProvider) {
        this.signedDocumentProvider = signedDocumentProvider;
    }

    public void setTotalStatus(boolean totalStatus) {
        this.totalStatus = totalStatus;
    }
}

