/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.report.etsi.builder;

import de.intarsys.security.report.etsi.ValidationObjectType;
import de.intarsys.security.report.etsi.builder.BuilderException;
import de.intarsys.security.report.etsi.builder.CommonValidationObjectBuilder;
import de.intarsys.security.report.etsi.builder.ValidationReportBuilderContext;
import de.intarsys.security.validation.IVSCertificate;
import java.security.cert.CertificateEncodingException;
import org.etsi.uri._019102.v1_2.SignatureValidationReportType;

public class VOCertificateBuilder
extends CommonValidationObjectBuilder {
    private final IVSCertificate state;

    public VOCertificateBuilder(ValidationReportBuilderContext context, IVSCertificate state) {
        super(context);
        this.state = state;
    }

    @Override
    protected SignatureValidationReportType createValidationReport() throws BuilderException {
        return null;
    }

    @Override
    protected byte[] getEncoded() throws BuilderException {
        try {
            return this.getState().getX509Certificate().getEncoded();
        }
        catch (CertificateEncodingException e) {
            throw new BuilderException(e);
        }
    }

    @Override
    protected String getObjectType() {
        return ValidationObjectType.CERTIFICATE.getUri();
    }

    private IVSCertificate getState() {
        return this.state;
    }
}

