/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.report.etsi.builder;

import de.intarsys.security.report.etsi.StatusSubIndication;
import de.intarsys.security.report.etsi.ValidationObjectType;
import de.intarsys.security.report.etsi.builder.BuilderException;
import de.intarsys.security.report.etsi.builder.CommonValidationObjectBuilder;
import de.intarsys.security.report.etsi.builder.SignatureValidationReportBuilder;
import de.intarsys.security.report.etsi.builder.ValidationReportBuilderContext;
import de.intarsys.security.report.etsi.builder.ValidationStatusBuilder;
import de.intarsys.security.validation.IVSSignatureContainer;
import de.intarsys.security.validation.IVSSignatureEntry;
import de.intarsys.security.validation.IVSTimestamp;
import de.intarsys.security.validation.IValidationState;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import org.etsi.uri._019102.v1_2.POEProvisioningType;
import org.etsi.uri._019102.v1_2.SignatureValidationReportType;
import org.etsi.uri._019102.v1_2.ValidationStatusType;

public class VOTimestampBuilder
extends CommonValidationObjectBuilder {
    private final IVSTimestamp state;

    public VOTimestampBuilder(ValidationReportBuilderContext context, IVSTimestamp state) {
        super(context);
        this.state = state;
    }

    @Override
    protected POEProvisioningType createPOEProvisioning() throws BuilderException {
        try {
            Date genTime = this.getState().getTimestamp().getTimestampInfo().getGenTime();
            POEProvisioningType poeProvisioning = VR12F.createPOEProvisioningType();
            poeProvisioning.setPOETime(VOTimestampBuilder.toXMLGregorianCalender(genTime));
            return poeProvisioning;
        }
        catch (IOException e) {
            throw new BuilderException(e);
        }
    }

    @Override
    protected SignatureValidationReportType createValidationReport() throws BuilderException {
        IVSSignatureContainer signatureContainerState = this.getState().getSignatureState();
        if (signatureContainerState == null) {
            return null;
        }
        List entryStates = signatureContainerState.getEntryStates();
        if (entryStates == null || entryStates.isEmpty()) {
            return null;
        }
        IVSSignatureEntry signatureEntryState = (IVSSignatureEntry)entryStates.get(0);
        SignatureValidationReportBuilder builder = new SignatureValidationReportBuilder(this.getContext(), signatureEntryState);
        builder.setTotalStatus(false);
        SignatureValidationReportType result = this.delegateBuild(builder);
        ValidationStatusType overallValidationStatus = this.delegateBuild(new ValidationStatusBuilder(this.getContext(), (IValidationState)this.getState(), false));
        result.getSignatureValidationStatus().setMainIndication(overallValidationStatus.getMainIndication());
        if (this.getState().getDigestState().isInvalid()) {
            result.getSignatureValidationStatus().getSubIndication().add(StatusSubIndication.HASH_FAILURE.getUri());
        }
        return result;
    }

    @Override
    protected byte[] getEncoded() throws BuilderException {
        try {
            return this.getState().getTimestamp().getEncoded();
        }
        catch (IOException e) {
            throw new BuilderException(e);
        }
    }

    @Override
    protected String getObjectType() {
        return ValidationObjectType.TIMESTAMP.getUri();
    }

    private IVSTimestamp getState() {
        return this.state;
    }
}

