/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.report.etsi.builder;

import de.intarsys.security.report.etsi.builder.IValidationObjectContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.etsi.uri._019102.v1_2.ValidationObjectType;

public class ValidationObjectContext
implements IValidationObjectContext {
    private Map<Object, List<ValidationObjectType>> validationObjects = new HashMap<Object, List<ValidationObjectType>>();

    protected void addValidationObject(Object baseObject, ValidationObjectType validationObject) {
        List<ValidationObjectType> validationObjectList = this.validationObjects.get(baseObject);
        if (validationObjectList == null) {
            validationObjectList = new ArrayList<ValidationObjectType>();
            this.validationObjects.put(baseObject, validationObjectList);
        }
        validationObjectList.add(validationObject);
    }

    @Override
    public ValidationObjectType getOrCreateValidationObject(Object baseObject, Supplier<ValidationObjectType> supplier) {
        List<ValidationObjectType> values = this.validationObjects.get(baseObject);
        if (values == null) {
            ValidationObjectType validationObject = supplier.get();
            this.addValidationObject(baseObject, validationObject);
            return validationObject;
        }
        return values.iterator().next();
    }

    @Override
    public Optional<ValidationObjectType> getValidationObject(Object baseObject) {
        List<ValidationObjectType> values = this.validationObjects.get(baseObject);
        if (values == null || values.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(values.iterator().next());
    }

    @Override
    public Map<Object, List<ValidationObjectType>> getValidationObjects() {
        return new HashMap<Object, List<ValidationObjectType>>(this.validationObjects);
    }
}

