/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.report.etsi.builder;

import de.intarsys.evr.v1_2.DocumentInfoType;
import de.intarsys.security.document.validation.ISignedDocument;
import de.intarsys.security.document.validation.ISignedDocumentProvider;
import de.intarsys.security.document.validation.IVSDocument;
import de.intarsys.security.document.validation.VSDocument;
import de.intarsys.security.report.etsi.builder.AbstractBuilder;
import de.intarsys.security.report.etsi.builder.BuilderException;
import de.intarsys.security.report.etsi.builder.SignatureValidationReportBuilder;
import de.intarsys.security.report.etsi.builder.VOSignedDataBuilder;
import de.intarsys.security.report.etsi.builder.VOTimestampBuilder;
import de.intarsys.security.report.etsi.builder.ValidationReportBuilderContext;
import de.intarsys.security.validation.IVSSignatureContainerEntry;
import de.intarsys.security.validation.IVSSignatureEntry;
import de.intarsys.security.validation.IVSTimestamp;
import de.intarsys.security.validation.IVSTimestampEntry;
import de.intarsys.tools.locator.ILocator;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.etsi.uri._019102.v1_2.SignatureValidationReportType;
import org.etsi.uri._019102.v1_2.SignatureValidatorType;
import org.etsi.uri._019102.v1_2.ValidationObjectListType;
import org.etsi.uri._019102.v1_2.ValidationObjectType;
import org.etsi.uri._019102.v1_2.ValidationReportType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationReportBuilder
extends AbstractBuilder<ValidationReportType> {
    private static final Logger Log = LoggerFactory.getLogger(ValidationReportBuilder.class);
    private IVSDocument documentState;

    public ValidationReportBuilder(ValidationReportBuilderContext context) {
        super(context);
    }

    @Override
    public ValidationReportType build() throws BuilderException {
        ValidationReportType validationReport = VR12F.createValidationReportType();
        List entryStates = this.getEntryStates().collect(Collectors.toList());
        ArrayList<SignatureValidationReportType> signatureReports = new ArrayList<SignatureValidationReportType>();
        ArrayList<IVSTimestampEntry> documentTimestampReports = new ArrayList<IVSTimestampEntry>();
        ListIterator i = entryStates.listIterator(entryStates.size());
        while (i.hasPrevious()) {
            IVSSignatureContainerEntry entryState = (IVSSignatureContainerEntry)i.previous();
            if (entryState instanceof IVSSignatureEntry) {
                SignatureValidationReportType signatureReport = this.createSignatureReport((IVSSignatureEntry)entryState, documentTimestampReports);
                signatureReports.add(0, signatureReport);
                continue;
            }
            if (!(entryState instanceof IVSTimestampEntry)) continue;
            this.processDocumentTimestamp((IVSTimestampEntry)entryState, documentTimestampReports);
            documentTimestampReports.add(0, (IVSTimestampEntry)entryState);
        }
        if (signatureReports.isEmpty()) {
            this.createSignersDocument();
        } else {
            signatureReports.forEach(sr -> validationReport.getSignatureValidationReport().add((SignatureValidationReportType)sr));
        }
        validationReport.setSignatureValidator(this.createValidator());
        validationReport.setSignatureValidationObjects(this.createValidationObjects());
        return validationReport;
    }

    private SignatureValidationReportType createSignatureReport(IVSSignatureEntry signatureEntryState, List<IVSTimestampEntry> documentTimestampStates) throws BuilderException {
        SignatureValidationReportBuilder builder = new SignatureValidationReportBuilder(this.getContext(), signatureEntryState);
        builder.setSignedDocumentProvider((ISignedDocumentProvider)this.getDocumentState());
        builder.setDocumentTimestampStates(documentTimestampStates);
        SignatureValidationReportType result = this.delegateBuild(builder);
        return result;
    }

    private void createSignersDocument() {
        if (this.getDocumentState() == null) {
            return;
        }
        ISignedDocument signedDocument = this.getDocumentState().getSignedDocument();
        if (signedDocument == null) {
            return;
        }
        ILocator locator = signedDocument.getDocument().getLocator();
        VOSignedDataBuilder voSignedDataBuilder = new VOSignedDataBuilder(this.getContext(), signedDocument.getDocument());
        voSignedDataBuilder.setIncludeBinary(false);
        ValidationObjectType vo = this.getValidationObjectContext().getOrCreateValidationObject(locator, () -> this.delegateBuild(voSignedDataBuilder));
        DocumentInfoType documentInfo = EVR12F.createDocumentInfoType();
        documentInfo.setName(locator.getName());
        try {
            documentInfo.setSize(BigInteger.valueOf(locator.getLength()));
        }
        catch (IOException e) {
            Log.warn(e.getMessage(), (Throwable)e);
            documentInfo.setSize(BigInteger.valueOf(-1L));
        }
        vo.getValidationObject().setDirect(documentInfo);
    }

    private ValidationObjectListType createValidationObjects() {
        ValidationObjectListType validationObjectList = VR12F.createValidationObjectListType();
        this.getValidationObjectContext().getValidationObjects().values().stream().flatMap(l -> l.stream()).forEach(vo -> validationObjectList.getValidationObject().add((ValidationObjectType)vo));
        return validationObjectList;
    }

    private SignatureValidatorType createValidator() {
        return null;
    }

    private IVSDocument getDocumentState() {
        if (this.documentState == null) {
            this.documentState = new VSDocument(null);
        }
        return this.documentState;
    }

    private Stream<IVSSignatureContainerEntry> getEntryStates() {
        return this.getDocumentState().getSignatureContainerStates().stream().flatMap(cs -> cs.getEntryStates().stream());
    }

    private ValidationObjectType processDocumentTimestamp(IVSTimestampEntry timestampEntryState, List<IVSTimestampEntry> documentTimestampStates) throws BuilderException {
        IVSTimestamp timestampState = timestampEntryState.getTimestampState();
        ValidationObjectType vo = this.getValidationObjectContext().getOrCreateValidationObject(timestampState, () -> this.delegateBuild(new VOTimestampBuilder(this.getContext(), timestampState)));
        return vo;
    }

    public ValidationReportBuilder withDocumentState(IVSDocument signedDocumentState) {
        this.documentState = signedDocumentState;
        return this;
    }
}

