/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.report.etsi.builder;

import de.intarsys.security.report.etsi.MessageType;
import de.intarsys.security.report.etsi.StatusMainIndication;
import de.intarsys.security.report.etsi.builder.AbstractBuilder;
import de.intarsys.security.report.etsi.builder.BuilderException;
import de.intarsys.security.report.etsi.builder.ValidationReportBuilderContext;
import de.intarsys.security.validation.IValidationMessage;
import de.intarsys.security.validation.IValidationState;
import org.etsi.uri._019102.v1_2.AdditionalValidationReportDataType;
import org.etsi.uri._019102.v1_2.TypedDataType;
import org.etsi.uri._019102.v1_2.ValidationReportDataType;
import org.etsi.uri._019102.v1_2.ValidationStatusType;

public class ValidationStatusBuilder
extends AbstractBuilder<ValidationStatusType> {
    private boolean totalStatus;
    private final IValidationState state;

    public ValidationStatusBuilder(ValidationReportBuilderContext context, IValidationState state) {
        this(context, state, true);
    }

    public ValidationStatusBuilder(ValidationReportBuilderContext context, IValidationState state, boolean totalStatus) {
        super(context);
        this.state = state;
        this.totalStatus = totalStatus;
    }

    @Override
    public ValidationStatusType build() throws BuilderException {
        ValidationStatusType validationStatus = VR12F.createValidationStatusType();
        StatusMainIndication smi = this.getStatusMainIndication();
        validationStatus.setMainIndication(smi.getUri());
        ValidationReportDataType reportData = VR12F.createValidationReportDataType();
        AdditionalValidationReportDataType additionalValidationReportData = VR12F.createAdditionalValidationReportDataType();
        reportData.setAdditionalValidationReportData(additionalValidationReportData);
        for (IValidationMessage message : this.getState().getMessages()) {
            TypedDataType messageElement = this.toReportElement(message);
            additionalValidationReportData.getReportData().add(messageElement);
        }
        validationStatus.getAssociatedValidationReportData().add(reportData);
        return validationStatus;
    }

    private IValidationState getState() {
        return this.state;
    }

    private StatusMainIndication getStatusMainIndication() {
        switch (this.getState().getState()) {
            case 0: {
                return this.isTotalStatus() ? StatusMainIndication.TOTAL_PASSED : StatusMainIndication.PASSED;
            }
            case 3: {
                return this.isTotalStatus() ? StatusMainIndication.TOTAL_FAILED : StatusMainIndication.FAILED;
            }
        }
        return StatusMainIndication.INDETERMINATE;
    }

    private boolean isTotalStatus() {
        return this.totalStatus;
    }

    protected TypedDataType toReportElement(IValidationMessage message) {
        TypedDataType typedData = VR12F.createTypedDataType();
        typedData.setType(MessageType.ofSeverity(message.getSeverity()).getUri());
        typedData.setValue(message.getText());
        return typedData;
    }
}

