/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.report.etsi.conformity.builder;

import de.intarsys.evr.v1_2.ConformityCheckReportType;
import de.intarsys.evr.v1_2.ExtendedValidationReportType;
import de.intarsys.security.document.validation.IVSDocument;
import de.intarsys.security.report.etsi.ETSIReportTools;
import de.intarsys.security.report.etsi.StatusMainIndication;
import de.intarsys.security.report.etsi.builder.AbstractBuilder;
import de.intarsys.security.report.etsi.builder.BuilderException;
import de.intarsys.security.report.etsi.builder.ValidationReportBuilder;
import de.intarsys.security.report.etsi.builder.ValidationReportBuilderContext;
import jakarta.xml.bind.JAXBElement;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.xml.namespace.QName;
import org.etsi.uri._019102.v1_2.SignatureValidationReportType;
import org.etsi.uri._019102.v1_2.ValidationReportType;
import org.etsi.uri._019102.v1_2.ValidationStatusType;

public class ExtendedValidationReportBuilder
extends AbstractBuilder<ExtendedValidationReportType> {
    private ValidationReportType baseReport;
    private IVSDocument documentState;
    private String policyId;
    private ConformityCheckReportType conformityCheckReport;
    private ConformityCheckReportType[] signatureConformityCheckReports = new ConformityCheckReportType[5];

    public ExtendedValidationReportBuilder(ValidationReportBuilderContext context) {
        super(context);
    }

    @Override
    public ExtendedValidationReportType build() throws BuilderException {
        ExtendedValidationReportType extendedValidationReport = EVR12F.createExtendedValidationReportType();
        if (this.baseReport == null) {
            this.baseReport = this.buildBaseReport();
            if (this.baseReport == null) {
                throw new BuilderException("no base report available");
            }
        }
        int index = 0;
        for (SignatureValidationReportType svr : this.baseReport.getSignatureValidationReport()) {
            SignatureValidationReportType esvr = this.extend(index, svr);
            extendedValidationReport.getSignatureValidationReport().add(esvr);
            ++index;
        }
        extendedValidationReport.setSignatureValidationObjects(this.baseReport.getSignatureValidationObjects());
        extendedValidationReport.setSignatureValidator(this.baseReport.getSignatureValidator());
        if (this.conformityCheckReport == null) {
            throw new BuilderException("no conformity check report available");
        }
        extendedValidationReport.setConformityCheckReport(this.conformityCheckReport);
        return extendedValidationReport;
    }

    private ValidationReportType buildBaseReport() throws BuilderException {
        if (this.documentState == null) {
            throw new BuilderException("no document state available");
        }
        return new ValidationReportBuilder(this.getContext()).withDocumentState(this.documentState).build();
    }

    private ConformityCheckReportType createConformityCheckReport(StatusMainIndication statusMainIndication) {
        return this.createConformityCheckReport(statusMainIndication.getUri());
    }

    private ConformityCheckReportType createConformityCheckReport(String statusMainIndicationUri) {
        ConformityCheckReportType conformityCheckReport = EVR12F.createConformityCheckReportType();
        conformityCheckReport.setRuleIdentifier(this.getPolicyId());
        ValidationStatusType validationStatus = VR12F.createValidationStatusType();
        validationStatus.setMainIndication(statusMainIndicationUri);
        conformityCheckReport.setValidationStatus(validationStatus);
        return conformityCheckReport;
    }

    private SignatureValidationReportType extend(int index, SignatureValidationReportType signatureValidationReport) throws BuilderException {
        SignatureValidationReportType extended = VR12F.createSignatureValidationReportType();
        extended.setSignatureAttributes(signatureValidationReport.getSignatureAttributes());
        extended.setSignatureIdentifier(signatureValidationReport.getSignatureIdentifier());
        extended.setSignatureQuality(signatureValidationReport.getSignatureQuality());
        extended.setSignatureValidationProcess(signatureValidationReport.getSignatureValidationProcess());
        extended.setSignerInformation(signatureValidationReport.getSignerInformation());
        extended.setSignersDocument(signatureValidationReport.getSignersDocument());
        extended.setValidationConstraintsEvaluationReport(signatureValidationReport.getValidationConstraintsEvaluationReport());
        extended.setSignatureValidationStatus(signatureValidationReport.getSignatureValidationStatus());
        extended.setValidationTimeInfo(signatureValidationReport.getValidationTimeInfo());
        extended.getAny().addAll(signatureValidationReport.getAny());
        ConformityCheckReportType conformityCheckReport = this.getSignatureConformityCheckReport(index, true);
        JAXBElement conformityCheckReportElement = new JAXBElement(new QName(ETSIReportTools.NS_ExtendedValidationReport_1_2, "ConformityCheckReport"), ConformityCheckReportType.class, (Object)conformityCheckReport);
        extended.getAny().add(conformityCheckReportElement);
        return extended;
    }

    public ConformityCheckReportType failed(int index, String statusSubIndicationUri) {
        return this.withSignatureConformityCheckResult(index, StatusMainIndication.FAILED, statusSubIndicationUri);
    }

    public ConformityCheckReportType failed(String ... statusSubIndicationUri) {
        return this.withConformityCheckResult(StatusMainIndication.TOTAL_FAILED, statusSubIndicationUri);
    }

    public ValidationReportType getBaseReport() {
        return this.baseReport;
    }

    public ConformityCheckReportType getConformityCheckReport() {
        return this.conformityCheckReport;
    }

    public String getPolicyId() {
        return this.policyId;
    }

    private ConformityCheckReportType getSignatureConformityCheckReport(int index, boolean create) {
        ConformityCheckReportType signatureConformityCheckReport = null;
        if (index < this.signatureConformityCheckReports.length) {
            signatureConformityCheckReport = this.signatureConformityCheckReports[index];
        }
        if (signatureConformityCheckReport == null && create) {
            signatureConformityCheckReport = this.createConformityCheckReport(StatusMainIndication.PASSED);
            if (index >= this.signatureConformityCheckReports.length) {
                this.signatureConformityCheckReports = Arrays.copyOf(this.signatureConformityCheckReports, index + 5);
            }
            this.signatureConformityCheckReports[index] = signatureConformityCheckReport;
        }
        return signatureConformityCheckReport;
    }

    public Stream<ConformityCheckReportType> getSignatureConformityCheckReports() {
        return Arrays.stream(this.signatureConformityCheckReports).filter(r -> r != null);
    }

    public Stream<ConformityCheckReportType> getSignatureStatusFailed() {
        return this.getSignatureConformityCheckReports().filter(r -> StatusMainIndication.FAILED.getUri().equals(r.getValidationStatus().getMainIndication()));
    }

    public Stream<ConformityCheckReportType> getSignatureStatusIndeterminate() {
        return this.getSignatureConformityCheckReports().filter(r -> StatusMainIndication.INDETERMINATE.getUri().equals(r.getValidationStatus().getMainIndication()));
    }

    public Stream<String> getSignatureStatusSubIndications() {
        return this.getSignatureConformityCheckReports().map(cc -> cc.getValidationStatus().getSubIndication()).flatMap(l -> l.stream()).distinct();
    }

    protected String getWorseMainStatus(String status1, String status2) {
        Optional<StatusMainIndication> status1value = StatusMainIndication.ofUri(status1);
        Optional<StatusMainIndication> status2value = StatusMainIndication.ofUri(status2);
        if (status1value.isPresent()) {
            if (status2value.isPresent()) {
                return StatusMainIndication.getWorse(status1value.get(), status2value.get()).getUri();
            }
            return status1;
        }
        if (status2value.isPresent()) {
            return status2;
        }
        return status1;
    }

    public ConformityCheckReportType indeterminate(int index, String ... statusSubIndicationUri) {
        return this.withSignatureConformityCheckResult(index, StatusMainIndication.INDETERMINATE, Arrays.asList(statusSubIndicationUri));
    }

    public ConformityCheckReportType indeterminate(String ... statusSubIndicationUri) {
        return this.withConformityCheckResult(StatusMainIndication.INDETERMINATE, statusSubIndicationUri);
    }

    public ConformityCheckReportType passed() {
        return this.withConformityCheckResult(StatusMainIndication.TOTAL_PASSED, new String[0]);
    }

    public ConformityCheckReportType passed(int index) {
        return this.withSignatureConformityCheckResult(index, StatusMainIndication.PASSED, Collections.emptyList());
    }

    public ConformityCheckReportType withConformityCheckResult(StatusMainIndication statusMainIndication, List<String> statusSubIndicationUri) {
        return this.withConformityCheckResult(statusMainIndication.getUri(), statusSubIndicationUri);
    }

    public ConformityCheckReportType withConformityCheckResult(StatusMainIndication statusMainIndication, String ... statusSubIndicationUri) {
        return this.withConformityCheckResult(statusMainIndication, Arrays.asList(statusSubIndicationUri));
    }

    public ConformityCheckReportType withConformityCheckResult(String statusMainIndicationUri, List<String> statusSubIndicationUri) {
        if (this.conformityCheckReport == null) {
            this.conformityCheckReport = this.createConformityCheckReport(statusMainIndicationUri);
        } else {
            String newMainStatus = this.getWorseMainStatus(this.conformityCheckReport.getValidationStatus().getMainIndication(), statusMainIndicationUri);
            this.conformityCheckReport.getValidationStatus().setMainIndication(newMainStatus);
        }
        this.conformityCheckReport.getValidationStatus().getSubIndication().addAll(statusSubIndicationUri);
        return this.conformityCheckReport;
    }

    public ExtendedValidationReportBuilder withDocumentState(IVSDocument signedDocumentState) {
        this.documentState = signedDocumentState;
        return this;
    }

    public ExtendedValidationReportBuilder withPolicyId(String policyId) {
        this.policyId = policyId;
        return this;
    }

    public ConformityCheckReportType withSignatureConformityCheckReport(int index) {
        ConformityCheckReportType signatureConformityCheckReport = this.getSignatureConformityCheckReport(index, true);
        return signatureConformityCheckReport;
    }

    public ConformityCheckReportType withSignatureConformityCheckResult(int index, StatusMainIndication statusMainIndication, List<String> statusSubIndicationUri) {
        ConformityCheckReportType signatureConformityCheckReport = this.withSignatureConformityCheckReport(index);
        String newMainStatus = this.getWorseMainStatus(signatureConformityCheckReport.getValidationStatus().getMainIndication(), statusMainIndication.getUri());
        signatureConformityCheckReport.getValidationStatus().setMainIndication(newMainStatus);
        signatureConformityCheckReport.getValidationStatus().getSubIndication().addAll(statusSubIndicationUri);
        return signatureConformityCheckReport;
    }

    public ConformityCheckReportType withSignatureConformityCheckResult(int index, StatusMainIndication statusMainIndication, String ... statusSubIndicationUri) {
        return this.withSignatureConformityCheckResult(index, statusMainIndication, Arrays.asList(statusSubIndicationUri));
    }

    public ExtendedValidationReportBuilder withValidationReport(ValidationReportType validationReport) {
        this.baseReport = validationReport;
        return this;
    }
}

