/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.report.etsi.view;

import de.intarsys.evr.v1_2.ConformityCheckReportType;
import de.intarsys.evr.v1_2.SignatureValidationProcessDetailType;
import de.intarsys.security.report.etsi.view.ProcessDetailView;
import jakarta.xml.bind.JAXBElement;
import java.util.Optional;
import org.etsi.uri._019102.v1_2.AdditionalValidationReportDataType;
import org.etsi.uri._019102.v1_2.TypedDataType;
import org.etsi.uri._019102.v1_2.ValidationStatusType;

public class ConformityCheckReportView {
    private final ConformityCheckReportType report;
    private Optional<ProcessDetailView> processDetail;

    public ConformityCheckReportView(ConformityCheckReportType report) {
        this.report = report;
    }

    public Optional<TypedDataType> getAdditionalData(String urn) {
        AdditionalValidationReportDataType additionalValidationReportData = this.getReport().getAdditionalValidationReportData();
        if (additionalValidationReportData == null) {
            return Optional.empty();
        }
        return additionalValidationReportData.getReportData().stream().filter(rd -> urn.equals(rd.getType())).findFirst();
    }

    public Optional<ProcessDetailView> getProcessDetail() {
        if (this.processDetail == null) {
            this.processDetail = this.getReport().getAny().stream().filter(JAXBElement.class::isInstance).map(JAXBElement.class::cast).map(JAXBElement::getValue).filter(SignatureValidationProcessDetailType.class::isInstance).map(SignatureValidationProcessDetailType.class::cast).findAny().map(ProcessDetailView::new);
        }
        return this.processDetail;
    }

    private ConformityCheckReportType getReport() {
        return this.report;
    }

    public Optional<String> getRuleIdentifier() {
        return Optional.ofNullable(this.report.getRuleIdentifier());
    }

    public Optional<ValidationStatusType> getValidationStatus() {
        return Optional.ofNullable(this.report.getValidationStatus());
    }
}

