/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.report.etsi.view;

import de.intarsys.evr.v1_2.SignatureValidationProcessDetailType;
import de.intarsys.security.report.etsi.AdESLevel;
import java.util.Optional;
import java.util.stream.Stream;
import org.etsi.uri._019102.v1_2.ValidationStatusType;

public class ProcessDetailView {
    private final SignatureValidationProcessDetailType processDetail;

    public ProcessDetailView(SignatureValidationProcessDetailType processDetail) {
        this.processDetail = processDetail;
    }

    public Optional<ValidationStatusType> getCertificateRevocationValidationStatus() {
        return this.getProcessDetail().map(d -> d.getCertificateValidation()).map(d -> d.getRevocationValidation()).map(v -> v.getValidationStatus());
    }

    public Optional<ValidationStatusType> getCertificateValidationStatus() {
        return this.getProcessDetail().map(d -> d.getCertificateValidation()).map(v -> v.getValidationStatus());
    }

    public Optional<ValidationStatusType> getIntegrityValidationStatus() {
        return this.getProcessDetail().map(d -> d.getIntegrityValidation()).map(v -> v.getValidationStatus());
    }

    public Optional<ValidationStatusType> getOtherValidationStatus(String type) {
        return this.getProcessDetail().flatMap(d -> d.getOtherValidation().stream().filter(other -> other.getType().equals(type)).findFirst()).map(v -> v.getValidationStatus());
    }

    public Optional<SignatureValidationProcessDetailType> getProcessDetail() {
        return Optional.of(this.processDetail);
    }

    public Optional<ValidationStatusType> getTimestampValidationStatus() {
        return this.getProcessDetail().map(d -> d.getTimestampValidation()).map(v -> v.getValidationStatus());
    }

    public Optional<Boolean> isLtvEnabled() {
        return this.getProcessDetail().map(d -> d.getAdESLevel()).map(v -> AdESLevel.B_LT.getName().equals(v) || AdESLevel.B_LTA.getName().equals(v));
    }

    public Optional<Boolean> isStoredOnSSCD() {
        return this.getProcessDetail().map(d -> d.getCertificateValidation()).map(v -> v.isStoredOnSSCD());
    }

    public Stream<String> listOtherValidationTypes() {
        return this.getProcessDetail().map(d -> d.getOtherValidation().stream()).orElse(Stream.empty()).map(vt -> vt.getType());
    }
}

