/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.report.etsi.view;

import de.intarsys.tools.digest.DigestTools;
import de.intarsys.tools.digest.IDigest;
import java.util.Optional;
import org.etsi.uri._01903.v1_3.DigestAlgAndValueType;
import org.etsi.uri._019102.v1_2.ValidationObjectType;

public class ResolvedValidationObject<T> {
    private ValidationObjectType validationObject;
    private T resolved;

    public ResolvedValidationObject(ValidationObjectType validationObject, T resolved) {
        this.validationObject = validationObject;
        this.resolved = resolved;
    }

    protected IDigest asDigest(DigestAlgAndValueType digestAlgAndValue) {
        String algorithmName = digestAlgAndValue.getDigestMethod().getAlgorithm();
        return DigestTools.createDigest((String)algorithmName, (byte[])digestAlgAndValue.getDigestValue());
    }

    public Optional<IDigest> getDigest() {
        return Optional.of(this.getValidationObject()).map(vot -> vot.getValidationObject()).map(vor -> vor.getDigestAlgAndValue()).map(this::asDigest);
    }

    public T getResolved() {
        return this.resolved;
    }

    public ValidationObjectType getValidationObject() {
        return this.validationObject;
    }
}

