/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.report.etsi.view;

import de.intarsys.evr.v1_2.ConformityCheckReportType;
import de.intarsys.evr.v1_2.DocumentInfoType;
import de.intarsys.evr.v1_2.SAOtherAttributeType;
import de.intarsys.evr.v1_2.SignatureValidationProcessDetailType;
import de.intarsys.security.algorithm.common.SignatureAlgorithm;
import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.report.etsi.view.ConformityCheckReportView;
import de.intarsys.security.report.etsi.view.ResolvedValidationObject;
import de.intarsys.security.report.etsi.view.SignatureValidationReportViewV1;
import de.intarsys.tools.digest.DigestTools;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.function.OnError;
import de.intarsys.tools.function.Predicates;
import jakarta.xml.bind.JAXBElement;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.etsi.uri._01903.v1_3.DigestAlgAndValueType;
import org.etsi.uri._019102.v1_2.AttributeBaseType;
import org.etsi.uri._019102.v1_2.CertificateChainType;
import org.etsi.uri._019102.v1_2.SAContactInfoType;
import org.etsi.uri._019102.v1_2.SANameType;
import org.etsi.uri._019102.v1_2.SAReasonType;
import org.etsi.uri._019102.v1_2.SASignerRoleType;
import org.etsi.uri._019102.v1_2.SATimestampType;
import org.etsi.uri._019102.v1_2.SignatureValidationProcessType;
import org.etsi.uri._019102.v1_2.SignatureValidationReportType;
import org.etsi.uri._019102.v1_2.VOReferenceType;
import org.etsi.uri._019102.v1_2.ValidationObjectType;
import org.etsi.uri._019102.v1_2.ValidationReportDataType;
import org.etsi.uri._019102.v1_2.ValidationStatusType;

public class SignatureValidationReportView {
    private final SignatureValidationReportType report;
    private final SignatureValidationReportViewV1 baseView;

    public SignatureValidationReportView(SignatureValidationReportType report) {
        this.report = report;
        this.baseView = new SignatureValidationReportViewV1(report);
    }

    protected IDigest asDigest(DigestAlgAndValueType digestAlgAndValue) {
        String algorithmName = digestAlgAndValue.getDigestMethod().getAlgorithm();
        return DigestTools.createDigest((String)algorithmName, (byte[])digestAlgAndValue.getDigestValue());
    }

    protected <T extends AttributeBaseType> Stream<T> getAttributes(Class<T> type) {
        return Optional.of(this.getReport()).map(r -> r.getSignatureAttributes()).map(sa -> sa.getSigningTimeOrSigningCertificateOrDataObjectFormat().stream().filter(JAXBElement.class::isInstance).map(e -> ((JAXBElement)e).getValue()).filter(type::isInstance).map(type::cast)).orElseGet(Stream::empty);
    }

    protected Optional<ResolvedValidationObject<IX509PublicKeyCertificate>> getCertificate(VOReferenceType vor) {
        return Optional.of(vor).flatMap(vort -> vort.getVOReference().stream().findFirst()).map(object -> (ValidationObjectType)object).map(OnError.rethrow(vot -> new ResolvedValidationObject<IX509PublicKeyCertificate>((ValidationObjectType)vot, (IX509PublicKeyCertificate)CertificateTools.createCertificate((Object)vot.getValidationObject().getBase64()))));
    }

    public Optional<ConformityCheckReportView> getConformityCheckReport() {
        return Optional.of(this.getReport()).flatMap(r -> r.getAny().stream().findFirst()).map(object -> (JAXBElement)object).map(element -> new ConformityCheckReportView((ConformityCheckReportType)element.getValue()));
    }

    public Optional<String> getContactInfo() {
        return this.getContactInfoAttribute().map(SAContactInfoType::getContactInfoElement);
    }

    public Optional<SAContactInfoType> getContactInfoAttribute() {
        return this.getAttributes(SAContactInfoType.class).findAny();
    }

    public Optional<Instant> getCreationTime() {
        return Optional.of(this.getReport()).map(r -> r.getValidationTimeInfo()).map(vt -> vt.getBestSignatureTime()).map(c -> c.getPOETime().toGregorianCalendar().getTime().toInstant());
    }

    public Optional<SignatureValidationProcessDetailType> getDetail() {
        SignatureValidationProcessType signatureValidationProcess = this.report.getSignatureValidationProcess();
        if (signatureValidationProcess == null || signatureValidationProcess.getAny() == null) {
            return Optional.empty();
        }
        JAXBElement elem = (JAXBElement)signatureValidationProcess.getAny();
        return Optional.ofNullable((SignatureValidationProcessDetailType)elem.getValue());
    }

    public Optional<IDigest> getDocumentDigest() {
        return Optional.of(this.getReport()).map(r -> r.getSignersDocument()).map(sd -> sd.getSignersDocumentRef()).map(sdr -> sdr.getVOReference()).flatMap(vor -> vor.stream().findFirst()).map(ValidationObjectType.class::cast).map(vot -> vot.getValidationObject()).map(vor -> vor.getDigestAlgAndValue()).map(this::asDigest);
    }

    public Optional<String> getDocumentName() {
        return Optional.of(this.getReport()).map(r -> r.getSignersDocument()).map(sd -> sd.getSignersDocumentRef()).map(sdr -> sdr.getAny()).map(JAXBElement.class::cast).map(e -> e.getValue()).filter(DocumentInfoType.class::isInstance).map(DocumentInfoType.class::cast).map(dit -> dit.getName());
    }

    public Optional<ResolvedValidationObject<IX509PublicKeyCertificate>> getIssuerCertificate() {
        ValidationStatusType validationStatus = this.report.getSignatureValidationStatus();
        if (validationStatus.getAssociatedValidationReportData().isEmpty()) {
            return Optional.empty();
        }
        ValidationReportDataType validationReportData = validationStatus.getAssociatedValidationReportData().get(0);
        CertificateChainType certificateChain = validationReportData.getCertificateChain();
        if (certificateChain == null) {
            return Optional.empty();
        }
        VOReferenceType issuerRef = null;
        issuerRef = certificateChain.getIntermediateCertificate().isEmpty() ? certificateChain.getTrustAnchor() : certificateChain.getIntermediateCertificate().get(0);
        if (issuerRef == null) {
            Optional<ResolvedValidationObject<IX509PublicKeyCertificate>> signingCertificate = this.getSignerCertificate();
            if (signingCertificate.isPresent() && CertificateTools.isSelfSigned((IX509Certificate)((IX509Certificate)signingCertificate.get().getResolved()))) {
                return signingCertificate;
            }
            return Optional.empty();
        }
        return this.getCertificate(issuerRef);
    }

    public Optional<String> getName() {
        return this.getNameAttribute().map(SANameType::getNameElement);
    }

    public Optional<SANameType> getNameAttribute() {
        return this.getAttributes(SANameType.class).findAny();
    }

    public Optional<? extends AttributeBaseType> getOtherAttribute(String oid) {
        return this.getAttributes(SAOtherAttributeType.class).filter(a -> oid.equals(a.getType())).findAny();
    }

    public Optional<String> getReason() {
        return this.getReasonAttribute().map(SAReasonType::getReasonElement);
    }

    public Optional<SAReasonType> getReasonAttribute() {
        return this.getAttributes(SAReasonType.class).findAny();
    }

    private SignatureValidationReportType getReport() {
        return this.report;
    }

    public Optional<SignatureAlgorithm> getSignatureAlgorithm() {
        return Optional.empty();
    }

    public List<String> getSignatureQualities() {
        return Optional.of(this.getReport()).map(r -> r.getSignatureQuality()).map(sqt -> sqt.getSignatureQualityInformation()).orElseGet(() -> Collections.emptyList());
    }

    public Optional<SignatureValidationReportView> getSignatureTimestampReport() {
        return this.getSignatureTimestampVO().map(vo -> vo.getValidationReport()).map(vr -> new SignatureValidationReportView((SignatureValidationReportType)vr));
    }

    public Optional<Instant> getSignatureTimestampValue() {
        return this.getTimestampAttribute().map(ta -> ta.getTimeStampValue()).map(vt -> vt.toGregorianCalendar().toInstant());
    }

    protected Optional<ValidationObjectType> getSignatureTimestampVO() {
        return this.getTimestampAttribute().map(ta -> ta.getAttributeObject()).flatMap(ao -> ao.stream().findFirst()).flatMap(vor -> vor.getVOReference().stream().findFirst()).map(vo -> (ValidationObjectType)vo);
    }

    public Optional<IDigest> getSignedDataDigest() {
        return Optional.of(this.getReport()).map(r -> r.getSignatureIdentifier()).map(si -> si.getDigestAlgAndValue()).map(this::asDigest);
    }

    public Optional<ResolvedValidationObject<IX509PublicKeyCertificate>> getSignerCertificate() {
        return Optional.of(this.getReport()).map(r -> r.getSignerInformation()).map(signer -> signer.getSignerCertificate()).flatMap(vor -> this.getCertificate((VOReferenceType)vor));
    }

    public Optional<SASignerRoleType> getSignerRoleAttribute() {
        return this.getAttributes(SASignerRoleType.class).findAny();
    }

    public Optional<ValidationStatusType> getStatus() {
        return this.baseView.getStatus();
    }

    public Optional<SATimestampType> getTimestampAttribute() {
        return this.getAttributes(SATimestampType.class).findFirst();
    }

    public List<String> getTrustServiceTerritories() {
        List territories = this.getValidationProcessDetail().map(vpd -> vpd.getTrustService()).map(trustServices -> trustServices.stream().map(ts -> ts.getTSLInformation()).filter(Predicates.isNotNull()).flatMap(tsli -> tsli.getSchemeTerritory().stream()).distinct().toList()).orElseGet(() -> Collections.emptyList());
        return territories;
    }

    public Optional<Instant> getValidatedAt() {
        return Optional.ofNullable(this.getReport().getValidationTimeInfo()).map(vt -> vt.getValidationTime()).map(vt -> vt.toGregorianCalendar().toInstant());
    }

    public Optional<SignatureValidationProcessDetailType> getValidationProcessDetail() {
        SignatureValidationProcessType signatureValidationProcess = this.report.getSignatureValidationProcess();
        if (signatureValidationProcess == null || signatureValidationProcess.getAny() == null) {
            return Optional.empty();
        }
        JAXBElement elem = (JAXBElement)signatureValidationProcess.getAny();
        return Optional.ofNullable((SignatureValidationProcessDetailType)elem.getValue());
    }

    public Optional<ValidationStatusType> getValidationStatus() {
        return Optional.ofNullable(this.getReport().getSignatureValidationStatus());
    }

    public boolean hasAnySignatureQualification(List<String> signatureQualificationUris) {
        return this.baseView.hasAnySignatureQualification(signatureQualificationUris);
    }

    public boolean isQualified() {
        return this.baseView.isQualified();
    }

    public boolean isQualifiedSignature() {
        return this.baseView.isQualifiedSignature();
    }

    public boolean isRegulated() {
        return this.baseView.isRegulated();
    }

    public boolean isValid() {
        return this.baseView.isValid();
    }

    public boolean usesPseudonym() {
        return this.baseView.usesPseudonym();
    }
}

