/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.report.etsi.view;

import de.intarsys.asn1.cms.CMS;
import de.intarsys.evr.v1_2.ConformityCheckReportType;
import de.intarsys.evr.v1_2.DocumentInfoType;
import de.intarsys.evr.v1_2.SAOtherAttributeType;
import de.intarsys.evr.v1_2.SignatureValidationProcessDetailType;
import de.intarsys.security.algorithm.common.SignatureAlgorithm;
import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.method.cms.timestamp.TimestampToken;
import de.intarsys.security.report.etsi.SignatureQuality;
import de.intarsys.security.report.etsi.StatusMainIndication;
import de.intarsys.security.report.etsi.StatusSubIndication;
import de.intarsys.security.report.etsi.builder.BuilderException;
import de.intarsys.security.timestamp.ITimestampToken;
import de.intarsys.tools.collection.ListTools;
import de.intarsys.tools.digest.DigestTools;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.locator.ByteArrayLocator;
import de.intarsys.tools.locator.ILocator;
import jakarta.xml.bind.JAXBElement;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.security.cert.CertificateException;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.etsi.uri._01903.v1_3.DigestAlgAndValueType;
import org.etsi.uri._019102.v1_2.AttributeBaseType;
import org.etsi.uri._019102.v1_2.CertificateChainType;
import org.etsi.uri._019102.v1_2.SAContactInfoType;
import org.etsi.uri._019102.v1_2.SANameType;
import org.etsi.uri._019102.v1_2.SAReasonType;
import org.etsi.uri._019102.v1_2.SASignerRoleType;
import org.etsi.uri._019102.v1_2.SATimestampType;
import org.etsi.uri._019102.v1_2.SignatureAttributesType;
import org.etsi.uri._019102.v1_2.SignatureValidationProcessType;
import org.etsi.uri._019102.v1_2.SignatureValidationReportType;
import org.etsi.uri._019102.v1_2.VOReferenceType;
import org.etsi.uri._019102.v1_2.ValidationObjectType;
import org.etsi.uri._019102.v1_2.ValidationReportDataType;
import org.etsi.uri._019102.v1_2.ValidationStatusType;

@Deprecated(forRemoval=true)
class SignatureValidationReportViewV1 {
    private SignatureValidationReportType report;
    private SoftReference<ITimestampToken> signatureTimestamp;

    public SignatureValidationReportViewV1(SignatureValidationReportType report) {
        this.report = report;
    }

    protected IDigest asDigest(DigestAlgAndValueType digestAlgAndValue) {
        String algorithmName = digestAlgAndValue.getDigestMethod().getAlgorithm();
        return DigestTools.createDigest((String)algorithmName, (byte[])digestAlgAndValue.getDigestValue());
    }

    protected boolean containsOneOf(List<String> subStatus, StatusSubIndication ... indications) {
        for (StatusSubIndication indication : indications) {
            if (!subStatus.contains(indication.getUri())) continue;
            return true;
        }
        return false;
    }

    public Optional<? extends AttributeBaseType> getAttribute(String oid) {
        return this.getAttributes(SAOtherAttributeType.class).filter(a -> oid.equals(a.getType())).findAny();
    }

    protected <T extends AttributeBaseType> Stream<T> getAttributes(Class<T> type) {
        SignatureAttributesType signatureAttributes = this.report.getSignatureAttributes();
        if (signatureAttributes == null) {
            return null;
        }
        return signatureAttributes.getSigningTimeOrSigningCertificateOrDataObjectFormat().stream().filter(JAXBElement.class::isInstance).map(JAXBElement.class::cast).map(e -> e.getValue()).filter(type::isInstance).map(type::cast);
    }

    public Optional<SAContactInfoType> getContactInfoAttribute() {
        return this.getAttributes(SAContactInfoType.class).findAny();
    }

    public Optional<Date> getCreationTime() {
        return Optional.ofNullable(this.getReport().getValidationTimeInfo()).map(vt -> vt.getBestSignatureTime()).map(c -> c.getPOETime().toGregorianCalendar().getTime());
    }

    public SignatureValidationProcessDetailType getDetail() {
        SignatureValidationProcessType signatureValidationProcess = this.report.getSignatureValidationProcess();
        if (signatureValidationProcess == null || signatureValidationProcess.getAny() == null) {
            return null;
        }
        JAXBElement elem = (JAXBElement)signatureValidationProcess.getAny();
        return (SignatureValidationProcessDetailType)elem.getValue();
    }

    public Optional<IDigest> getDocumentDigest() {
        Optional<List> validationOReference = Optional.ofNullable(this.getReport().getSignersDocument()).map(sd -> sd.getSignersDocumentRef()).map(sdr -> sdr.getVOReference());
        if (validationOReference.isPresent() && !validationOReference.get().isEmpty()) {
            return Optional.ofNullable(validationOReference.get().stream()).map(vor -> vor.findFirst().get()).map(ValidationObjectType.class::cast).map(vot -> vot.getValidationObject()).map(vo -> vo.getDigestAlgAndValue()).map(this::asDigest);
        }
        return Optional.empty();
    }

    public Optional<String> getDocumentName() {
        return Optional.ofNullable(this.report.getSignersDocument()).map(sd -> sd.getSignersDocumentRef()).map(sdr -> sdr.getAny()).map(JAXBElement.class::cast).map(e -> e.getValue()).filter(DocumentInfoType.class::isInstance).map(DocumentInfoType.class::cast).map(dit -> dit.getName());
    }

    public Optional<IX509PublicKeyCertificate> getIssuerCertificate() throws CertificateException {
        ValidationStatusType validationStatus = this.report.getSignatureValidationStatus();
        if (validationStatus.getAssociatedValidationReportData().isEmpty()) {
            return Optional.empty();
        }
        ValidationReportDataType validationReportData = validationStatus.getAssociatedValidationReportData().get(0);
        CertificateChainType certificateChain = validationReportData.getCertificateChain();
        if (certificateChain == null) {
            return Optional.empty();
        }
        VOReferenceType issuerRef = null;
        issuerRef = certificateChain.getIntermediateCertificate().isEmpty() ? certificateChain.getTrustAnchor() : certificateChain.getIntermediateCertificate().get(0);
        if (issuerRef == null) {
            VOReferenceType signingCertificateRef = certificateChain.getSigningCertificate();
            IX509PublicKeyCertificate signingCertificate = this.parseCertificate(signingCertificateRef);
            if (CertificateTools.isSelfSigned((IX509Certificate)signingCertificate)) {
                return Optional.of(signingCertificate);
            }
            return Optional.empty();
        }
        return Optional.ofNullable(this.parseCertificate(issuerRef));
    }

    public Optional<StatusMainIndication> getMainStatus() {
        ValidationStatusType validationStatus = this.report.getSignatureValidationStatus();
        if (validationStatus == null) {
            return Optional.empty();
        }
        return StatusMainIndication.ofUri(validationStatus.getMainIndication());
    }

    public Optional<SANameType> getNameAttribute() {
        return this.getAttributes(SANameType.class).findAny();
    }

    public Optional<SAReasonType> getReasonAttribute() {
        return this.getAttributes(SAReasonType.class).findAny();
    }

    public SignatureValidationReportType getReport() {
        return this.report;
    }

    public Optional<SignatureAlgorithm> getSignatureAlgorithm() {
        return Optional.empty();
    }

    public List<String> getSignatureQuality() {
        if (this.getReport().getSignatureQuality() == null) {
            return Collections.emptyList();
        }
        return this.getReport().getSignatureQuality().getSignatureQualityInformation();
    }

    protected Optional<ITimestampToken> getSignatureTimestamp() throws BuilderException {
        ITimestampToken timestamp;
        ITimestampToken iTimestampToken = timestamp = this.signatureTimestamp == null ? null : this.signatureTimestamp.get();
        if (timestamp != null) {
            return Optional.of(timestamp);
        }
        if (this.getTimestampAttribute().get().getAttributeObject().isEmpty()) {
            return Optional.empty();
        }
        VOReferenceType vor = this.getTimestampAttribute().get().getAttributeObject().iterator().next();
        if (vor.getVOReference().isEmpty()) {
            return Optional.empty();
        }
        ValidationObjectType vo = (ValidationObjectType)vor.getVOReference().get(0);
        byte[] base64 = vo.getValidationObject().getBase64();
        ByteArrayLocator locator = new ByteArrayLocator(Base64.getDecoder().decode(base64), "timestamp.tsr");
        try {
            ITimestampToken token = TimestampToken.create((CMS)CMS.createFromLocator((ILocator)locator));
            this.signatureTimestamp = new SoftReference<ITimestampToken>(token);
            return Optional.of(token);
        }
        catch (IOException e) {
            throw new BuilderException(e);
        }
    }

    public Optional<SignatureValidationReportViewV1> getSignatureTimestampReport() {
        ValidationObjectType timestampVO = this.getSignatureTimestampVO();
        if (timestampVO == null) {
            return Optional.empty();
        }
        SignatureValidationReportType validationReport = timestampVO.getValidationReport();
        if (validationReport == null) {
            return Optional.empty();
        }
        SignatureValidationReportViewV1 view = new SignatureValidationReportViewV1(validationReport);
        return Optional.of(view);
    }

    protected ValidationObjectType getSignatureTimestampVO() {
        if (!this.getTimestampAttribute().isPresent()) {
            return null;
        }
        if (this.getTimestampAttribute().get().getAttributeObject().isEmpty()) {
            return null;
        }
        VOReferenceType vor = this.getTimestampAttribute().get().getAttributeObject().iterator().next();
        if (vor.getVOReference().isEmpty()) {
            return null;
        }
        ValidationObjectType vo = (ValidationObjectType)vor.getVOReference().get(0);
        return vo;
    }

    public Optional<IDigest> getSignedDataDigest() {
        return Optional.ofNullable(this.report.getSignatureIdentifier()).map(si -> si.getDigestAlgAndValue()).map(this::asDigest);
    }

    public Optional<IX509PublicKeyCertificate> getSignerCertificate() throws CertificateException {
        if (this.report.getSignerInformation() == null) {
            return Optional.empty();
        }
        VOReferenceType vor = this.report.getSignerInformation().getSignerCertificate();
        if (vor == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.parseCertificate(vor));
    }

    public Optional<SASignerRoleType> getSignerRoleAttribute() {
        return this.getAttributes(SASignerRoleType.class).findAny();
    }

    public Optional<ValidationStatusType> getStatus() {
        return Optional.ofNullable(this.report.getSignatureValidationStatus());
    }

    public Optional<StatusMainIndication> getStatusCertificate() {
        ValidationStatusType validationStatus = this.report.getSignatureValidationStatus();
        if (validationStatus == null) {
            return Optional.empty();
        }
        Optional<StatusMainIndication> mainStatus = StatusMainIndication.ofUri(validationStatus.getMainIndication());
        if (!mainStatus.isPresent()) {
            return Optional.empty();
        }
        if (mainStatus.get().isPassed()) {
            return Optional.of(StatusMainIndication.PASSED);
        }
        List<String> subStatus = validationStatus.getSubIndication();
        if (mainStatus.get().isFailed()) {
            if (this.containsOneOf(subStatus, StatusSubIndication.EXPIRED, StatusSubIndication.NOT_YET_VALID)) {
                return Optional.of(StatusMainIndication.FAILED);
            }
            return Optional.empty();
        }
        if (this.containsOneOf(subStatus, StatusSubIndication.NO_CERTIFICATE_CHAIN_FOUND, StatusSubIndication.OUT_OF_BOUNDS_NO_POE, StatusSubIndication.REVOKED_NO_POE, StatusSubIndication.CRYPTO_CONSTRAINTS_FAILURE_NO_POE, StatusSubIndication.TRY_LATER, StatusSubIndication.REVOKED_CA_NO_POE, StatusSubIndication.CHAIN_CONSTRAINTS_FAILURE, StatusSubIndication.CERTIFICATE_CHAIN_GENERAL_FAILURE)) {
            return Optional.of(StatusMainIndication.INDETERMINATE);
        }
        return Optional.empty();
    }

    public Optional<StatusMainIndication> getStatusCertificateRevocation() {
        ValidationStatusType validationStatus = this.report.getSignatureValidationStatus();
        if (validationStatus == null) {
            return Optional.empty();
        }
        Optional<StatusMainIndication> mainStatus = StatusMainIndication.ofUri(validationStatus.getMainIndication());
        if (!mainStatus.isPresent()) {
            return Optional.empty();
        }
        if (mainStatus.get().isPassed()) {
            return Optional.of(StatusMainIndication.PASSED);
        }
        List<String> subStatus = validationStatus.getSubIndication();
        if (mainStatus.get().isFailed()) {
            if (this.containsOneOf(subStatus, StatusSubIndication.REVOKED)) {
                return Optional.of(StatusMainIndication.FAILED);
            }
            return Optional.empty();
        }
        if (this.containsOneOf(subStatus, StatusSubIndication.REVOKED_NO_POE)) {
            return Optional.of(StatusMainIndication.INDETERMINATE);
        }
        return Optional.empty();
    }

    public Optional<StatusMainIndication> getStatusConformity() {
        if (this.report.getAny().isEmpty()) {
            return Optional.empty();
        }
        Object signatureConformityCheckReportObj = this.report.getAny().get(0);
        if (signatureConformityCheckReportObj == null) {
            return Optional.empty();
        }
        JAXBElement signatureConformityCheckReportElement = (JAXBElement)signatureConformityCheckReportObj;
        ConformityCheckReportType signatureConformityCheckReport = (ConformityCheckReportType)signatureConformityCheckReportElement.getValue();
        ValidationStatusType validationStatus = signatureConformityCheckReport.getValidationStatus();
        if (validationStatus == null) {
            return Optional.empty();
        }
        return StatusMainIndication.ofUri(validationStatus.getMainIndication());
    }

    public Optional<StatusMainIndication> getStatusIntegrity() {
        ValidationStatusType validationStatus = this.report.getSignatureValidationStatus();
        if (validationStatus == null) {
            return Optional.empty();
        }
        Optional<StatusMainIndication> mainStatus = StatusMainIndication.ofUri(validationStatus.getMainIndication());
        if (!mainStatus.isPresent()) {
            return Optional.empty();
        }
        if (mainStatus.get().isPassed()) {
            return Optional.of(StatusMainIndication.PASSED);
        }
        List<String> subStatus = validationStatus.getSubIndication();
        if (mainStatus.get().isFailed()) {
            if (this.containsOneOf(subStatus, StatusSubIndication.FORMAT_FAILURE, StatusSubIndication.HASH_FAILURE, StatusSubIndication.SIG_CRYPTO_FAILURE)) {
                return Optional.of(StatusMainIndication.FAILED);
            }
            return Optional.empty();
        }
        if (this.containsOneOf(subStatus, StatusSubIndication.SIGNED_DATA_NOT_FOUND)) {
            return Optional.of(StatusMainIndication.INDETERMINATE);
        }
        return Optional.empty();
    }

    public Optional<StatusMainIndication> getStatusTimestamp() {
        return this.getSignatureTimestampReport().map(r -> r.getMainStatus()).orElseGet(() -> Optional.empty());
    }

    public List<String> getSubStatus() {
        List<String> subIndication;
        ValidationStatusType validationStatus = this.report.getSignatureValidationStatus();
        if (validationStatus != null && (subIndication = validationStatus.getSubIndication()) != null) {
            return subIndication;
        }
        return Collections.emptyList();
    }

    public Optional<SATimestampType> getTimestampAttribute() {
        return this.getAttributes(SATimestampType.class).findAny();
    }

    public boolean hasAnySignatureQualification(List<String> signatureQualificationUris) {
        return !Collections.disjoint(this.getSignatureQuality(), signatureQualificationUris);
    }

    public boolean isQualified() {
        return this.hasAnySignatureQualification(ListTools.with((Object[])new String[]{SignatureQuality.QES.getUri(), SignatureQuality.QESIG.getUri(), SignatureQuality.QESEAL.getUri()}));
    }

    public boolean isQualifiedSeal() {
        return this.hasAnySignatureQualification(ListTools.with((Object[])new String[]{SignatureQuality.QES.getUri(), SignatureQuality.QESEAL.getUri()}));
    }

    public boolean isQualifiedSignature() {
        return this.hasAnySignatureQualification(ListTools.with((Object[])new String[]{SignatureQuality.QES.getUri(), SignatureQuality.QESIG.getUri()}));
    }

    public boolean isRegulated() {
        return this.hasAnySignatureQualification(ListTools.with((Object[])new String[]{SignatureQuality.REGES.getUri(), SignatureQuality.REGESIG.getUri(), SignatureQuality.REGESEAL.getUri()}));
    }

    public boolean isRegulatedSeal() {
        return this.hasAnySignatureQualification(ListTools.with((Object[])new String[]{SignatureQuality.REGES.getUri(), SignatureQuality.REGESEAL.getUri()}));
    }

    public boolean isRegulatedSignature() {
        return this.hasAnySignatureQualification(ListTools.with((Object[])new String[]{SignatureQuality.REGES.getUri(), SignatureQuality.REGESIG.getUri()}));
    }

    public boolean isValid() {
        Optional<StatusMainIndication> status = this.getMainStatus();
        if (!status.isPresent()) {
            return false;
        }
        return status.get().isPassed();
    }

    protected IX509PublicKeyCertificate parseCertificate(VOReferenceType vor) throws CertificateException {
        Iterator<Object> iValidationObject = vor.getVOReference().iterator();
        if (!iValidationObject.hasNext()) {
            return null;
        }
        ValidationObjectType vo = (ValidationObjectType)iValidationObject.next();
        byte[] base64 = vo.getValidationObject().getBase64();
        return (IX509PublicKeyCertificate)CertificateTools.createCertificate((Object)base64);
    }

    public boolean usesPseudonym() {
        if (this.report.getSignerInformation() == null) {
            return false;
        }
        Boolean result = this.report.getSignerInformation().isPseudonym();
        return result == null ? false : result;
    }
}

