/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.report.etsi.view;

import de.intarsys.evr.v1_2.DocumentInfoType;
import de.intarsys.security.report.etsi.ValidationObjectType;
import de.intarsys.tools.digest.DigestTools;
import de.intarsys.tools.digest.IDigest;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.etsi.uri._01903.v1_3.DigestAlgAndValueType;
import org.etsi.uri._019102.v1_2.ValidationObjectListType;
import org.etsi.uri._019102.v1_2.ValidationObjectRepresentationType;
import org.etsi.uri._019102.v1_2.ValidationReportType;

public class ValidationReportView {
    private final ValidationReportType report;

    public ValidationReportView(ValidationReportType report) {
        this.report = report;
    }

    protected IDigest asDigest(DigestAlgAndValueType digestAlgAndValue) {
        String algorithmName = digestAlgAndValue.getDigestMethod().getAlgorithm();
        return DigestTools.createDigest((String)algorithmName, (byte[])digestAlgAndValue.getDigestValue());
    }

    public Optional<IDigest> getDocumentDigest() {
        return this.getDocumentObject().map(vor -> vor.getDigestAlgAndValue()).map(this::asDigest);
    }

    public Optional<String> getDocumentName() {
        return this.getDocumentObject().map(dcoObj -> dcoObj.getDirect()).map(DocumentInfoType.class::cast).map(dit -> dit.getName());
    }

    protected Optional<ValidationObjectRepresentationType> getDocumentObject() {
        return Optional.of(this.getReport()).map(r -> r.getSignatureValidationObjects()).map(svo -> svo.getValidationObject()).flatMap(vo -> vo.stream().filter(c -> ValidationObjectType.SIGNEDDATA.getUri().equals(c.getObjectType())).findFirst()).map(vot -> vot.getValidationObject());
    }

    private ValidationReportType getReport() {
        return this.report;
    }

    public List<org.etsi.uri._019102.v1_2.ValidationObjectType> getTimestampObjects() {
        return this.getValidationObjects(ValidationObjectType.TIMESTAMP);
    }

    protected List<org.etsi.uri._019102.v1_2.ValidationObjectType> getValidationObjects(ValidationObjectType type) {
        ValidationObjectListType signatureValidationObjects = this.getReport().getSignatureValidationObjects();
        if (signatureValidationObjects == null) {
            return Collections.emptyList();
        }
        List<org.etsi.uri._019102.v1_2.ValidationObjectType> validationObjects = signatureValidationObjects.getValidationObject();
        return validationObjects.stream().filter(c -> type.getUri().equals(c.getObjectType())).toList();
    }
}

