/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.blacken.service;

import de.intarsys.document.model.IDocument;
import de.intarsys.pdf.app.appearance.AppearanceCreatorRegistry;
import de.intarsys.pdf.app.appearance.IAppearanceCreator;
import de.intarsys.pdf.cds.CDSMatrix;
import de.intarsys.pdf.content.CSContent;
import de.intarsys.pdf.content.CSDeviceBasedInterpreter;
import de.intarsys.pdf.content.CSOperation;
import de.intarsys.pdf.content.CSOperators;
import de.intarsys.pdf.content.ICSDevice;
import de.intarsys.pdf.content.common.CSCreator;
import de.intarsys.pdf.cos.COSCatalog;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.pd.IResourcesProvider;
import de.intarsys.pdf.pd.PDAcroForm;
import de.intarsys.pdf.pd.PDAcroFormField;
import de.intarsys.pdf.pd.PDAcroFormNode;
import de.intarsys.pdf.pd.PDAction;
import de.intarsys.pdf.pd.PDActionAny;
import de.intarsys.pdf.pd.PDActionJavaScript;
import de.intarsys.pdf.pd.PDActionResetForm;
import de.intarsys.pdf.pd.PDActionSubmitForm;
import de.intarsys.pdf.pd.PDAdditionalActions;
import de.intarsys.pdf.pd.PDAnnotation;
import de.intarsys.pdf.pd.PDAppearance;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.pdf.pd.PDForm;
import de.intarsys.pdf.pd.PDOutline;
import de.intarsys.pdf.pd.PDOutlineItem;
import de.intarsys.pdf.pd.PDOutlineNode;
import de.intarsys.pdf.pd.PDPage;
import de.intarsys.processor.document.common.CommonDocumentProcessor;
import de.intarsys.tools.attribute.Attribute;
import de.intarsys.tools.component.ComponentTargetException;
import de.intarsys.tools.factory.IFactory;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class PDFFlattener
extends CommonDocumentProcessor {
    public static final String ARG_SetReadOnly = "setReadOnly";
    public static final String ARG_ActionAllRemove = "actionAllRemove";
    public static final String ARG_ActionJavaScriptRemove = "actionJavaScriptRemove";
    public static final String ARG_ActionSoundRemove = "actionSoundRemove";
    public static final String ARG_ActionMovieRemove = "actionMovieRemove";
    public static final String ARG_ActionSetOCGStateRemove = "actionSetOCGStateRemove";
    public static final String ARG_ActionRenditionRemove = "actionRenditionRemove";
    public static final String ARG_ActionFormRemove = "actionFormRemove";
    public static final String ARG_AnnotationMarkupRemove = "annotationMarkupRemove";
    public static final String ARG_AnnotationMarkupEmbed = "annotationMarkupEmbed";
    public static final String ARG_AnnotationWidgetRemove = "annotationWidgetRemove";
    public static final String ARG_AnnotationWidgetEmbed = "annotationWidgetEmbed";
    public static final String ARG_AnnotationOtherRemove = "annotationOtherRemove";
    public static final String ARG_AnnotationOtherEmbed = "annotationOtherEmbed";
    private static final Attribute ATTR_ENCAPSULATED = new Attribute("encapsulated");
    private boolean actionAllRemove = true;
    private boolean actionFormRemove = true;
    private boolean actionJavaScriptRemove = true;
    private boolean actionMovieRemove = true;
    private boolean actionRenditionRemove = true;
    private boolean actionSetOCGStateRemove = true;
    private boolean actionSoundRemove = true;
    private boolean annotationMarkupRemove = true;
    private boolean annotationMarkupEmbed = true;
    private boolean annotationWidgetRemove = true;
    private boolean annotationWidgetEmbed = true;
    private boolean annotationOtherRemove = true;
    private boolean annotationOtherEmbed = true;
    private boolean setReadOnly = false;

    public PDFFlattener(IFactory factory, IDocument doc) {
        super(factory, doc);
    }

    protected void basicRun() throws Exception {
        try {
            PDDocument pdDoc = (PDDocument)this.getDocument().getImpl();
            if (this.isAnnotationWidgetRemove()) {
                this.doAnnotationRemoveWidget(pdDoc);
            }
            if (this.isAnnotationMarkupRemove()) {
                this.doAnnotationRemoveMarkup(pdDoc);
            }
            if (this.isAnnotationOtherRemove()) {
                this.doAnnotationRemoveOther(pdDoc);
            }
            HashSet<COSName> actionTypes = null;
            if (!this.isActionAllRemove()) {
                actionTypes = new HashSet<COSName>();
                if (this.isActionFormRemove()) {
                    actionTypes.add(PDActionSubmitForm.CN_ActionType_SubmitForm);
                    actionTypes.add(PDActionResetForm.CN_ActionType_ResetForm);
                    actionTypes.add(PDActionAny.CN_ActionType_ImportData);
                }
                if (this.isActionJavaScriptRemove()) {
                    actionTypes.add(PDActionJavaScript.CN_ActionType_JavaScript);
                }
                if (this.isActionMovieRemove()) {
                    actionTypes.add(PDActionAny.CN_ActionType_Movie);
                }
                if (this.isActionRenditionRemove()) {
                    actionTypes.add(PDActionAny.CN_ActionType_Rendition);
                }
                if (this.isActionSetOCGStateRemove()) {
                    actionTypes.add(PDActionAny.CN_ActionType_SetOCGState);
                }
                if (this.isActionSoundRemove()) {
                    actionTypes.add(PDActionAny.CN_ActionType_Sound);
                }
            }
            if (actionTypes == null || !actionTypes.isEmpty()) {
                this.doActionRemove(pdDoc, actionTypes);
            }
            pdDoc.setInfoDict(null);
            pdDoc.save();
        }
        catch (Exception e) {
            throw new ComponentTargetException("Exception in Flattener", (Throwable)e);
        }
    }

    protected void doActionRemove(PDAcroFormNode node, Set types) {
        List fields = node.getGenericChildren();
        for (PDAcroFormField field : fields) {
            this.doActionRemove(field.getAdditionalActions(), types);
            this.doActionRemove((PDAcroFormNode)field, types);
        }
    }

    protected void doActionRemove(PDAction action, Set types) {
        List next = action.getNext();
        if (next != null) {
            for (PDAction nextAction : next) {
                if (nextAction == null) continue;
                if (types == null || types.contains(nextAction.cosGetActionType())) {
                    action.removeNext(nextAction);
                    continue;
                }
                this.doActionRemove(nextAction, types);
            }
        }
    }

    protected void doActionRemove(PDAdditionalActions additionalActions, Set types) {
        if (additionalActions == null) {
            return;
        }
        HashSet names = new HashSet(additionalActions.cosGetDict().keySet());
        for (COSName name : names) {
            PDAction action = additionalActions.getAction(name);
            if (action == null) continue;
            if (types == null || types.contains(action.cosGetActionType())) {
                additionalActions.clearAction(name);
                continue;
            }
            this.doActionRemove(action, types);
        }
    }

    protected void doActionRemove(PDDocument doc, Set types) {
        COSDictionary names;
        COSCatalog catalog;
        if ((types == null || types.contains(PDActionJavaScript.CN_ActionType_JavaScript)) && (catalog = doc.getCatalog()) != null && (names = catalog.cosGetNames()) != null) {
            names.remove(PDActionJavaScript.CN_ActionType_JavaScript);
        }
        this.doActionRemove(doc.getAdditionalActions(), types);
        PDAction action = doc.getOpenAction();
        if (action != null) {
            if (types == null || types.contains(action.cosGetActionType())) {
                doc.setOpenAction(null);
            } else {
                this.doActionRemove(action, types);
            }
        }
        for (PDPage page = doc.getPageTree().getFirstPage(); page != null; page = page.getNextPage()) {
            this.doActionRemove(page, types);
        }
        PDAcroForm acroForm = doc.getAcroForm();
        if (acroForm != null) {
            this.doActionRemove((PDAcroFormNode)acroForm, types);
        }
        PDOutline outline = doc.getOutline();
        this.doActionRemoveChildren((PDOutlineNode)outline, types);
    }

    protected void doActionRemove(PDOutlineItem item, Set types) {
        PDAction action = item.getAction();
        if (action != null) {
            if (types == null || types.contains(action.cosGetActionType())) {
                item.setAction(null);
            } else {
                this.doActionRemove(action, types);
            }
        }
        this.doActionRemoveChildren((PDOutlineNode)item, types);
    }

    protected void doActionRemove(PDPage page, Set types) {
        this.doActionRemove(page.getAdditionalActions(), types);
        List annotations = page.getAnnotations();
        if (annotations != null) {
            for (PDAnnotation annotation : annotations) {
                this.doActionRemove(annotation.getAdditionalActions(), types);
                PDAction action = annotation.getAction();
                if (action == null) continue;
                if (types == null || types.contains(action.cosGetActionType())) {
                    annotation.setAction(null);
                    continue;
                }
                this.doActionRemove(action, types);
            }
        }
    }

    protected void doActionRemoveChildren(PDOutlineNode node, Set types) {
        if (node == null) {
            return;
        }
        for (PDOutlineItem item : node.getChildren()) {
            this.doActionRemove(item, types);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doAnnotationEmbed(PDAnnotation annotation, ICSDevice device, boolean forceCreateAppearance) {
        IAppearanceCreator appearanceCreator;
        if (annotation.isHidden()) {
            return;
        }
        if (!annotation.isPrint()) {
            return;
        }
        if (annotation.getRectangle().getWidth() == 0.0f || annotation.getRectangle().getHeight() == 0.0f) {
            return;
        }
        PDAppearance appearance = annotation.getAppearance();
        if ((appearance == null || !appearance.isDefined() || forceCreateAppearance) && (appearanceCreator = AppearanceCreatorRegistry.get().lookupAppearanceCreator(annotation.cosGetSubtype())) != null) {
            appearance = appearanceCreator.createAppearance(annotation, null);
        }
        if (appearance == null) {
            return;
        }
        COSName appearanceKey = PDAppearance.DK_N;
        COSName state = annotation.getAppearanceState();
        PDForm form = appearance.getAppearance(appearanceKey, state);
        if (form == null) {
            return;
        }
        CDSMatrix matrix = form.getMatrix();
        Rectangle2D tbbox = form.getTransformedBBox();
        device.saveState();
        try {
            Rectangle2D rect = annotation.getRectangle().toNormalizedRectangle();
            device.penRectangle((float)(rect.getX() - 1.5), (float)(rect.getY() - 1.5), (float)(rect.getWidth() + 3.0), (float)(rect.getHeight() + 3.0));
            device.pathClipEvenOdd();
            device.pathEnd();
            AffineTransform transform = new AffineTransform();
            transform.translate(-tbbox.getX(), -tbbox.getY());
            float sx = (float)(rect.getWidth() / tbbox.getWidth());
            float sy = (float)(rect.getHeight() / tbbox.getHeight());
            transform.translate(rect.getMinX(), rect.getMinY());
            transform.scale(sx, sy);
            if (matrix != null) {
                transform.concatenate(matrix.toTransform());
            }
            double[] values = new double[6];
            transform.getMatrix(values);
            device.transform((float)values[0], (float)values[1], (float)values[2], (float)values[3], (float)values[4], (float)values[5]);
            CSContent content = form.getContentStream();
            CSDeviceBasedInterpreter interpreter = new CSDeviceBasedInterpreter(null, device);
            interpreter.process(content, form.getResources());
        }
        finally {
            device.restoreState();
        }
    }

    protected void doAnnotationRemoveMarkup(PDDocument doc) {
        for (PDPage page = doc.getPageTree().getFirstPage(); page != null; page = page.getNextPage()) {
            this.doAnnotationRemoveMarkup(page);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doAnnotationRemoveMarkup(PDPage page) {
        ArrayList annotations = page.getAnnotations();
        if (annotations != null) {
            boolean embed = this.isAnnotationOtherEmbed();
            annotations = new ArrayList(annotations);
            CSCreator creator = null;
            if (embed) {
                this.encapsulatePageContents(page);
                creator = CSCreator.createNewDetached((IResourcesProvider)page);
            }
            for (PDAnnotation annotation : annotations) {
                if (!annotation.isMarkupAnnotation()) continue;
                try {
                    if (!embed) continue;
                    this.doAnnotationEmbed(annotation, (ICSDevice)creator, false);
                }
                catch (RuntimeException runtimeException) {}
                continue;
                finally {
                    page.removeAnnotation(annotation);
                }
            }
            if (embed) {
                creator.flush();
                page.addContentStream(creator.getContent());
            }
        }
    }

    protected void doAnnotationRemoveOther(PDDocument doc) {
        for (PDPage page = doc.getPageTree().getFirstPage(); page != null; page = page.getNextPage()) {
            this.doAnnotationRemoveOther(page);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doAnnotationRemoveOther(PDPage page) {
        ArrayList annotations = page.getAnnotations();
        if (annotations != null) {
            boolean embed = this.isAnnotationOtherEmbed();
            annotations = new ArrayList(annotations);
            CSCreator creator = null;
            if (embed) {
                this.encapsulatePageContents(page);
                creator = CSCreator.createNewDetached((IResourcesProvider)page);
            }
            for (PDAnnotation annotation : annotations) {
                if (annotation.isMarkupAnnotation() || annotation.isWidgetAnnotation()) continue;
                try {
                    if (!embed) continue;
                    this.doAnnotationEmbed(annotation, (ICSDevice)creator, false);
                }
                catch (RuntimeException runtimeException) {}
                continue;
                finally {
                    page.removeAnnotation(annotation);
                }
            }
            if (embed) {
                creator.flush();
                page.addContentStream(creator.getContent());
            }
        }
    }

    protected void doAnnotationRemoveWidget(PDDocument doc) {
        boolean forceCreate = false;
        PDAcroForm form = doc.getAcroForm();
        if (form != null) {
            forceCreate = form.getNeedAppearances();
        }
        for (PDPage page = doc.getPageTree().getFirstPage(); page != null; page = page.getNextPage()) {
            this.doAnnotationRemoveWidget(page, forceCreate);
        }
        doc.setAcroForm(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doAnnotationRemoveWidget(PDPage page, boolean forceCreate) {
        ArrayList annotations = page.getAnnotations();
        if (annotations != null) {
            boolean embed = this.isAnnotationWidgetEmbed();
            annotations = new ArrayList(annotations);
            CSCreator creator = null;
            if (embed) {
                this.encapsulatePageContents(page);
                creator = CSCreator.createNewDetached((IResourcesProvider)page);
            }
            for (PDAnnotation annotation : annotations) {
                if (!annotation.isWidgetAnnotation()) continue;
                try {
                    if (!embed) continue;
                    this.doAnnotationEmbed(annotation, (ICSDevice)creator, forceCreate);
                }
                catch (RuntimeException runtimeException) {}
                continue;
                finally {
                    page.removeAnnotation(annotation);
                }
            }
            if (embed) {
                creator.flush();
                page.addContentStream(creator.getContent());
            }
        }
    }

    protected void encapsulatePageContents(PDPage page) {
        Boolean encapsulated = (Boolean)page.getAttribute((Object)ATTR_ENCAPSULATED);
        if (Boolean.TRUE.equals(encapsulated)) {
            return;
        }
        page.setAttribute((Object)ATTR_ENCAPSULATED, (Object)Boolean.TRUE);
        CSContent content = CSContent.createNew();
        CSOperation operation = new CSOperation(CSOperators.CSO_q);
        content.addOperation(operation);
        page.prependContentStream(content);
        content = CSContent.createNew();
        operation = new CSOperation(CSOperators.CSO_Q);
        content.addOperation(operation);
        page.addContentStream(content);
    }

    public boolean isActionAllRemove() {
        return this.actionAllRemove;
    }

    public boolean isActionFormRemove() {
        return this.actionFormRemove;
    }

    public boolean isActionJavaScriptRemove() {
        return this.actionJavaScriptRemove;
    }

    public boolean isActionMovieRemove() {
        return this.actionMovieRemove;
    }

    public boolean isActionRenditionRemove() {
        return this.actionRenditionRemove;
    }

    public boolean isActionSetOCGStateRemove() {
        return this.actionSetOCGStateRemove;
    }

    public boolean isActionSoundRemove() {
        return this.actionSoundRemove;
    }

    public boolean isAnnotationMarkupEmbed() {
        return this.annotationMarkupEmbed;
    }

    public boolean isAnnotationMarkupRemove() {
        return this.annotationMarkupRemove;
    }

    public boolean isAnnotationOtherEmbed() {
        return this.annotationOtherEmbed;
    }

    public boolean isAnnotationOtherRemove() {
        return this.annotationOtherRemove;
    }

    public boolean isAnnotationWidgetEmbed() {
        return this.annotationWidgetEmbed;
    }

    public boolean isAnnotationWidgetRemove() {
        return this.annotationWidgetRemove;
    }

    public boolean isSetReadOnly() {
        return this.setReadOnly;
    }

    public void setActionAllRemove(boolean actionAllRemove) {
        this.actionAllRemove = actionAllRemove;
    }

    public void setActionFormRemove(boolean actionFormRemove) {
        this.actionFormRemove = actionFormRemove;
    }

    public void setActionJavaScriptRemove(boolean removeJavaScript) {
        this.actionJavaScriptRemove = removeJavaScript;
    }

    public void setActionMovieRemove(boolean actionMovieRemove) {
        this.actionMovieRemove = actionMovieRemove;
    }

    public void setActionRenditionRemove(boolean actionRenditionRemove) {
        this.actionRenditionRemove = actionRenditionRemove;
    }

    public void setActionSetOCGStateRemove(boolean actionSetOCGStateRemove) {
        this.actionSetOCGStateRemove = actionSetOCGStateRemove;
    }

    public void setActionSoundRemove(boolean actionSoundRemove) {
        this.actionSoundRemove = actionSoundRemove;
    }

    public void setAnnotationMarkupEmbed(boolean embeddAnnotations) {
        this.annotationMarkupEmbed = embeddAnnotations;
    }

    public void setAnnotationMarkupRemove(boolean annotationMarkupRemove) {
        this.annotationMarkupRemove = annotationMarkupRemove;
    }

    public void setAnnotationOtherEmbed(boolean annotationAnyEmbed) {
        this.annotationOtherEmbed = annotationAnyEmbed;
    }

    public void setAnnotationOtherRemove(boolean annotationAnyRemove) {
        this.annotationOtherRemove = annotationAnyRemove;
    }

    public void setAnnotationWidgetEmbed(boolean annotationWidgetEmbed) {
        this.annotationWidgetEmbed = annotationWidgetEmbed;
    }

    public void setAnnotationWidgetRemove(boolean annotationWidgetRemove) {
        this.annotationWidgetRemove = annotationWidgetRemove;
    }

    public void setSetReadOnly(boolean setReadOnly) {
        this.setReadOnly = setReadOnly;
    }
}

