/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.blacken.service;

import de.intarsys.cloudsuite.gears.blacken.service.DefaultPDPageInserter;
import de.intarsys.cwt.awt.environment.CwtAwtGraphicsContext;
import de.intarsys.cwt.environment.IGraphicsContext;
import de.intarsys.document.common.DocumentTools;
import de.intarsys.document.model.IDocument;
import de.intarsys.document.type.pdf.PDFDocumentType;
import de.intarsys.pdf.app.image.PDImageFactory;
import de.intarsys.pdf.app.page.MultiPageSelector;
import de.intarsys.pdf.cds.CDSMatrix;
import de.intarsys.pdf.cds.CDSRectangle;
import de.intarsys.pdf.content.IContentStreamProvider;
import de.intarsys.pdf.content.common.CSCreator;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.pdf.pd.PDImage;
import de.intarsys.pdf.pd.PDPage;
import de.intarsys.pdf.pd.PDXObject;
import de.intarsys.pdf.rendering.misc.FieldContentRenderer;
import de.intarsys.pdf.rendering.misc.PageContentRenderer;
import de.intarsys.pdf.rendering.page.IPageRenderer;
import de.intarsys.pdf.st.EnumWriteMode;
import de.intarsys.pdf.tools.kernel.PDFGeometryTools;
import de.intarsys.processor.document.common.CommonDocumentProcessor;
import de.intarsys.tools.enumeration.common.EnumScaleWhen;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.locator.ByteArrayLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.reflect.ObjectCreationException;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PDFSelectivePageFreezer
extends CommonDocumentProcessor {
    private static final Logger Log = LoggerFactory.getLogger(PDFSelectivePageFreezer.class);
    public static final float DEFAULT_COMPRESSIONQUALITY = 0.75f;
    private static final int MAX_INCREMENTAL_SAVE_COUNT = 100;
    private static final int DEFAULT_IMAGES_PER_SAVEPOINT = 50;
    private static final float IMAGE_QUALITY = 0.5f;
    public static final String ARG_PAGE_NUMBERS = "pageNumbers";
    private static final int SCALE_FACTOR = 3;
    private int imagesPerSavepoint = 50;

    public PDFSelectivePageFreezer(IFactory factory, IDocument doc) {
        super(factory, doc);
    }

    protected void basicRun() throws Exception {
        AffineTransform transformPage = new AffineTransform();
        List pageNumberList = ArgTools.getList((IArgs)this.getArgs(), (String)ARG_PAGE_NUMBERS, null);
        PDDocument processedPdDocument = null;
        PDDocument pdDocument = null;
        try {
            processedPdDocument = (PDDocument)this.getDocument().getImpl();
            ByteArrayLocator defaultLocator = new ByteArrayLocator(null, "in-memory");
            IDocument document = DocumentTools.createNew((String)PDFDocumentType.ID, (IArgs)Args.create());
            pdDocument = (PDDocument)document.getImpl();
            pdDocument.setInfoDict(null);
            pdDocument.save((ILocator)defaultLocator);
            MultiPageSelector pageSelector = new MultiPageSelector();
            Iterator pdPages = pageSelector.getPages(pdDocument);
            while (pdPages.hasNext()) {
                PDPage page = (PDPage)pdPages.next();
                DefaultPDPageInserter pageInserter = null;
                pageInserter = new DefaultPDPageInserter(page);
                for (int i = 0; i < processedPdDocument.getPageTree().getCount(); ++i) {
                    IPageRenderer[] pageRenderers;
                    if (!pageNumberList.isEmpty() && !pageNumberList.contains(i)) {
                        PDPage pageCopy = (PDPage)PDPage.META.createFromCos(processedPdDocument.getPageTree().getPageAt(i).cosGetObject().copyDeep());
                        pageInserter.insertPage(pageCopy);
                        page = (PDPage)PDPage.META.createNew();
                        continue;
                    }
                    if (i > 0) {
                        page = (PDPage)PDPage.META.createNew();
                        pageInserter.insertPage(page);
                    }
                    PDPage processedpage = processedPdDocument.getPageTree().getPageAt(i);
                    transformPage.setToIdentity();
                    Rectangle2D normalizedPagerect = processedpage.getCropBox().toNormalizedRectangle();
                    AffineTransform rotateTransform = PDFGeometryTools.createPageSpace((PDPage)processedpage);
                    double[] extent = new double[]{normalizedPagerect.getWidth(), normalizedPagerect.getHeight()};
                    transformPage.deltaTransform(extent, 0, extent, 0, 1);
                    double pageWidth = Math.abs(extent[0]);
                    double pageHeight = Math.abs(extent[1]);
                    int imageWidth = Math.abs((int)(pageWidth * 3.0));
                    int imageHeight = Math.abs((int)(pageHeight * 3.0));
                    BufferedImage bufferedImage = new BufferedImage(imageWidth, imageHeight, 1);
                    Graphics2D graphics = (Graphics2D)bufferedImage.getGraphics();
                    CwtAwtGraphicsContext cwtGraphics = new CwtAwtGraphicsContext(graphics);
                    AffineTransform transform = new AffineTransform();
                    transform.scale(3.0, -3.0);
                    transform.translate(0.0, -pageHeight);
                    transform.concatenate(transformPage);
                    cwtGraphics.transform(transform);
                    for (IPageRenderer renderer : pageRenderers = new IPageRenderer[]{new PageContentRenderer(), new FieldContentRenderer()}) {
                        try {
                            renderer.renderPage(processedpage, null, (IGraphicsContext)cwtGraphics);
                        }
                        catch (RuntimeException ex) {
                            Log.warn("Error rendering page", (Throwable)ex);
                        }
                        cwtGraphics.setTransform(rotateTransform);
                    }
                    PDImageFactory factory = new PDImageFactory();
                    PDImage pdImage = factory.createJpegPDImage(bufferedImage, 0.5f);
                    this.insertImage(page, pdImage);
                    if ((i + 1) % this.imagesPerSavepoint != 0) continue;
                    if (i % (this.imagesPerSavepoint * 100) == 0) {
                        pdDocument.setWriteModeHint(EnumWriteMode.FULL);
                    }
                    pdDocument.save();
                }
            }
            pdDocument.setWriteModeHint(EnumWriteMode.FULL);
            if (!pageNumberList.isEmpty() && !pageNumberList.contains(0)) {
                pdDocument.getPageTree().getPageAt(0).dispose();
            }
            pdDocument.save(processedPdDocument.getLocator());
        }
        catch (Exception ex) {
            throw new ObjectCreationException("Error while adding pdImage", (Throwable)ex);
        }
        finally {
            if (processedPdDocument != null) {
                try {
                    processedPdDocument.close();
                }
                catch (IOException iOException) {}
            }
            if (pdDocument != null) {
                try {
                    pdDocument.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected CDSMatrix fit(PDImage image, CDSRectangle destRect, EnumScaleWhen scaleWhen) {
        float destWidth = destRect.getWidth();
        float destHeight = destRect.getHeight();
        float imageWidth = image.getWidth();
        float imageHeight = image.getHeight();
        float scaleX = destWidth / imageWidth;
        float scaleY = destHeight / imageHeight;
        if (scaleWhen != EnumScaleWhen.ALWAYS) {
            if (scaleWhen == EnumScaleWhen.NEVER) {
                scaleX = 1.0f;
                scaleY = 1.0f;
            } else if (scaleWhen == EnumScaleWhen.TOOBIG) {
                if (scaleX > 1.0f && scaleY > 1.0f) {
                    scaleX = 1.0f;
                    scaleY = 1.0f;
                }
            } else if (scaleWhen == EnumScaleWhen.TOOSMALL && scaleX <= 1.0f && scaleY <= 1.0f) {
                scaleX = 1.0f;
                scaleY = 1.0f;
            }
        }
        float scaledWidth = imageWidth * scaleX;
        float offsetX = Math.max(0.0f, destWidth - scaledWidth) / 2.0f;
        float offsetY = 0.0f;
        CDSMatrix matrix = new CDSMatrix(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
        matrix.translate(destRect.getLowerLeftX(), destRect.getLowerLeftY());
        matrix.translate(offsetX, offsetY);
        matrix.scale((float)image.getWidth(), (float)image.getHeight());
        matrix.scale(new float[]{scaleX, scaleY});
        return matrix;
    }

    protected void insertImage(PDPage page, PDImage pdImage) {
        float scaleFactor = 0.33333334f;
        CDSRectangle pageRect = new CDSRectangle(0.0f, 0.0f, (float)pdImage.getWidth() * scaleFactor, (float)pdImage.getHeight() * scaleFactor);
        page.setMediaBox(pageRect);
        EnumScaleWhen scaleWhen = EnumScaleWhen.ALWAYS;
        CSCreator creator = CSCreator.createNew((IContentStreamProvider)page);
        creator.saveState();
        CDSMatrix fit = this.fit(pdImage, page.getMediaBox(), scaleWhen);
        creator.transform(fit.getA(), fit.getB(), fit.getC(), fit.getD(), fit.getE(), fit.getF());
        creator.doXObject(null, (PDXObject)pdImage);
        creator.restoreState();
        creator.close();
    }
}

