/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.core.action;

import de.intarsys.cloudsuite.gears.action.ActionInvocation;
import de.intarsys.cloudsuite.gears.action.ServerAction;
import de.intarsys.cloudsuite.gears.core.service.common.api.DtoArtifact;
import de.intarsys.cloudsuite.gears.core.service.common.api.DtoResultDocument;
import de.intarsys.cloudsuite.gears.core.service.common.api.TransportDocument;
import de.intarsys.cloudsuite.gears.core.service.common.impl.RepositoryDocumentState;
import de.intarsys.cloudsuite.gears.flow.common.RepositoryBasedFlow;
import de.intarsys.cloudsuite.gears.repository.impl.RepositoryDocument;
import de.intarsys.document.common.DocumentTools;
import de.intarsys.document.model.IDocument;
import de.intarsys.document.type.pdf.PDFDocument;
import de.intarsys.pdf.pd.PDAFSignatureField;
import de.intarsys.pdf.pd.PDAcroFormField;
import de.intarsys.pdf.pd.PDAnnotation;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.conversation.impl.Conversation;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.string.StringTools;

public class AnnotationEdit
extends ServerAction {
    private static final String ARG_NAME = "name";
    private static final String ARG_ACTION = "action";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IConversation<?> basicInvoke(ActionInvocation invocation) throws Exception {
        String action = ArgTools.getString((IArgs)invocation.getArgs(), (String)ARG_ACTION, null);
        if ("clear".equals(action)) {
            IDocument document = null;
            try {
                String name = ArgTools.getString((IArgs)invocation.getArgs(), (String)ARG_NAME, null);
                if (StringTools.isEmpty((String)name)) {
                    IConversation iConversation = Conversation.failed((Throwable)new IllegalArgumentException("name required"));
                    return iConversation;
                }
                RepositoryBasedFlow flow = (RepositoryBasedFlow)invocation.getFlow();
                RepositoryDocument repoDoc = ((RepositoryDocumentState)flow.getRepoDocStates().iterator().next()).getRepoDoc();
                document = DocumentTools.createDocument((Object)repoDoc.getLocator());
                if (!(document instanceof PDFDocument)) {
                    IConversation iConversation = Conversation.failed((Throwable)new IllegalArgumentException("document type '" + document.getType().getDefaultExtension() + "' not supported"));
                    return iConversation;
                }
                PDDocument pdDoc = (PDDocument)((PDFDocument)document).getImpl();
                PDAcroFormField field = pdDoc.getAcroForm().getField(name);
                if (field == null) {
                    IConversation iConversation = Conversation.failed((Throwable)new IllegalArgumentException("field '" + name + "' not found"));
                    return iConversation;
                }
                if (field instanceof PDAFSignatureField) {
                    ((PDAFSignatureField)field).clearSignature();
                    for (PDAnnotation annot : field.getAnnotations()) {
                        annot.setAppearance(null);
                    }
                }
                pdDoc.save();
            }
            finally {
                if (document != null) {
                    document.release(null);
                }
            }
            invocation.getFlow().setArtifact(this.transformDocument(document));
            IConversation conversation = Conversation.completed(null);
            return conversation;
        }
        return Conversation.failed((Throwable)new IllegalArgumentException("action '" + action + "' not supported"));
    }

    protected DtoArtifact transformDocument(IDocument document) {
        DtoResultDocument resultdocument = new DtoResultDocument();
        TransportDocument transformedDoc = new TransportDocument();
        transformedDoc.setContent(document.getLocator());
        transformedDoc.setName(document.getLongName());
        resultdocument.setDocument(transformedDoc);
        return new DtoArtifact((Object)resultdocument);
    }
}

