/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.core.action;

import de.intarsys.cloudsuite.gears.action.ActionInvocation;
import de.intarsys.cloudsuite.gears.action.ServerAction;
import de.intarsys.cloudsuite.gears.blacken.service.PDFFlattenerFactory;
import de.intarsys.cloudsuite.gears.blacken.service.PDFSelectivePageFreezerFactory;
import de.intarsys.cloudsuite.gears.core.service.common.api.BlackeningItem;
import de.intarsys.cloudsuite.gears.core.service.common.api.DtoArtifact;
import de.intarsys.cloudsuite.gears.core.service.common.api.DtoBlackening;
import de.intarsys.cloudsuite.gears.core.service.common.api.DtoResultDocument;
import de.intarsys.cloudsuite.gears.core.service.common.api.TransportDocument;
import de.intarsys.cloudsuite.gears.core.service.common.impl.RepositoryDocumentState;
import de.intarsys.cloudsuite.gears.flow.common.RepositoryBasedFlow;
import de.intarsys.cloudsuite.gears.repository.impl.RepositoryDocument;
import de.intarsys.document.common.DocumentTools;
import de.intarsys.document.model.IDocument;
import de.intarsys.pdf.app.annotation.markup.MarkupSquareFactory;
import de.intarsys.pdf.app.appearance.AppearanceCreatorTools;
import de.intarsys.pdf.pd.PDAnnotation;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.pdf.pd.PDMarkupAnnotation;
import de.intarsys.pdf.st.EnumWriteMode;
import de.intarsys.tools.collection.MapTools;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.conversation.impl.Conversation;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.FunctorTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.reflect.ObjectCreationException;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class Blacken
extends ServerAction {
    public static final String ARG_ITEMS = "items";
    public static final String ARG_HEIGHT = "height";
    public static final String ARG_WIDTH = "width";
    public static final String ARG_PAGE = "page";
    public static final String ARG_X = "x";
    public static final String ARG_Y = "y";
    private static final float[] COLOR_BLACK = new float[]{0.0f, 0.0f, 0.0f};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IConversation<?> basicInvoke(ActionInvocation invocation) throws Exception {
        List itemDefinitions = ArgTools.getList((IArgs)invocation.getArgs(), (String)ARG_ITEMS, Collections.emptyList());
        RepositoryBasedFlow flow = (RepositoryBasedFlow)invocation.getFlow();
        RepositoryDocument repoDoc = ((RepositoryDocumentState)flow.getRepoDocStates().iterator().next()).getRepoDoc();
        IDocument document = DocumentTools.createDocument((Object)repoDoc.getLocator());
        try {
            PDDocument pdDoc = (PDDocument)document.getImpl();
            List<BlackeningItem> items = this.blackenParts(pdDoc, itemDefinitions);
            IArgs argsFlatten = ArgTools.createArgs();
            argsFlatten.put("document", (Object)document);
            FunctorTools.perform((Object)PDFFlattenerFactory.ID, (IArgs)argsFlatten);
            pdDoc.save(pdDoc.getLocator(), MapTools.with((Object[])new Object[]{"writeModeHint", EnumWriteMode.FULL}));
            if (!items.isEmpty()) {
                List modifiedPages = items.stream().map(BlackeningItem::getPage).distinct().collect(Collectors.toList());
                IArgs argsFreeze = ArgTools.createArgs();
                argsFreeze.put("document", (Object)document);
                argsFreeze.put("pageNumbers", modifiedPages);
                FunctorTools.perform((Object)PDFSelectivePageFreezerFactory.ID, (IArgs)argsFreeze);
            }
            DtoArtifact dtoBlackeningArtifact = new DtoArtifact();
            DtoBlackening dtoBlacken = new DtoBlackening();
            dtoBlacken.setItems(items);
            dtoBlackeningArtifact.setValue((Object)dtoBlacken);
            invocation.getFlow().addArtifact(dtoBlackeningArtifact);
            invocation.getFlow().addArtifact(this.transformDocument(document));
            IConversation iConversation = Conversation.completed(null);
            return iConversation;
        }
        finally {
            document.release(null);
        }
    }

    protected List<BlackeningItem> blackenParts(PDDocument pdDoc, List<IArgs> itemDefinitions) throws ObjectCreationException {
        ArrayList<BlackeningItem> items = new ArrayList<BlackeningItem>();
        if (itemDefinitions == null || itemDefinitions.isEmpty()) {
            return items;
        }
        MarkupSquareFactory annotationFactory = new MarkupSquareFactory();
        for (IArgs itemDefinition : itemDefinitions) {
            float x = ArgTools.getFloat((IArgs)itemDefinition, (String)ARG_X, (float)0.0f);
            float y = ArgTools.getFloat((IArgs)itemDefinition, (String)ARG_Y, (float)0.0f);
            float width = ArgTools.getFloat((IArgs)itemDefinition, (String)ARG_WIDTH, (float)0.0f);
            float height = ArgTools.getFloat((IArgs)itemDefinition, (String)ARG_HEIGHT, (float)0.0f);
            int pageNumber = ArgTools.getInt((IArgs)itemDefinition, (String)ARG_PAGE, (int)0);
            Rectangle2D.Double rect = new Rectangle2D.Double(x, y, width, height);
            PDAnnotation pdAnnotation = annotationFactory.createAnnotation(pdDoc.getPageTree().getPageAt(pageNumber), (Rectangle2D)rect, Collections.emptyMap());
            ((PDMarkupAnnotation)pdAnnotation).setInnerColor(COLOR_BLACK);
            pdAnnotation.setColor(COLOR_BLACK);
            AppearanceCreatorTools.createAppearance((PDAnnotation)pdAnnotation);
            BlackeningItem blackeningItem = new BlackeningItem(x, y, height, width, pageNumber);
            items.add(blackeningItem);
        }
        return items;
    }

    protected DtoArtifact transformDocument(IDocument document) {
        DtoArtifact documentArtifact = new DtoArtifact();
        DtoResultDocument resultdocument = new DtoResultDocument();
        TransportDocument transformedDoc = new TransportDocument();
        transformedDoc.setContent(document.getLocator());
        transformedDoc.setName(document.getLongName());
        resultdocument.setDocument(transformedDoc);
        documentArtifact.setValue((Object)resultdocument);
        return documentArtifact;
    }
}

