/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.core.action;

import de.intarsys.cloudsuite.gears.action.ActionInvocation;
import de.intarsys.cloudsuite.gears.action.ServerAction;
import de.intarsys.cloudsuite.gears.core.service.common.api.DtoArtifact;
import de.intarsys.cloudsuite.gears.core.service.common.api.FlowOptions;
import de.intarsys.cloudsuite.gears.core.service.common.api.IOptionSupport;
import de.intarsys.cloudsuite.gears.core.service.common.api.TransportDocument;
import de.intarsys.cloudsuite.gears.core.service.common.impl.RepositoryDocumentState;
import de.intarsys.cloudsuite.gears.core.service.common.impl.SvcCommon;
import de.intarsys.cloudsuite.gears.core.service.signer.api.RequestSignerCreate;
import de.intarsys.cloudsuite.gears.core.service.signer.api.ResultSigner;
import de.intarsys.cloudsuite.gears.core.service.signer.impl.SvcSigner;
import de.intarsys.cloudsuite.gears.flow.common.RepositoryBasedFlow;
import de.intarsys.cloudsuite.gears.repository.impl.RestrictedIdentificationProvider;
import de.intarsys.conversation.service.client.api.ConversationalResponse;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.conversation.impl.Conversation;
import de.intarsys.tools.enumeration.common.EnumScaleWhen;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.string.StringTools;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class Sign
extends ServerAction {
    private static final String ARG_DOCUMENTSIGNER_ARGS_DEPICTION = "documentSigner.args.depiction";
    private static final String ARG_DOCUMENTSIGNER_ARGS_ENDORSEMENT = "documentSigner.args.endorsement";
    public static final String ARG_ALIGN = "align";
    public static final String ARG_SIZE = "size";
    private static final String SHAPE_DECORATOR_FACTORY = "de.intarsys.security.document.type.pdf.signature.shape.ShapeDecoratorFactory";
    private static final String EXTENDED_DECORATOR_FACTORY = "de.intarsys.security.document.type.pdf.signature.ExtendedDecoratorFactory";
    private static final String SAMPLE_DECORATOR_FACTORY = "de.intarsys.security.document.type.pdf.signature.legacy.LegacySampleDecoratorFactory";
    public static final String ARG_0 = "0";
    public static final String ARG_1 = "1";
    public static final String ARG_2 = "2";
    public static final String ARG_3 = "3";
    public static final String ARG_ARGS = "args";
    public static final String ARG_DOCUMENTS = "documents";
    public static final String ARG_DOCUMENTSIGNER_ARGS_FIELD_CREATE = "documentSigner.args.field.create";
    public static final String ARG_DOCUMENTSIGNER_ARGS_FIELD_PAGE_RANGE = "documentSigner.args.field.pageRange";
    public static final String ARG_DOCUMENTSIGNER_ARGS_FIELD_PAGE_RANGE_CONTEXT = "documentSigner.args.field.pageRangeContext";
    public static final String ARG_DOCUMENTSIGNER_ARGS_FIELD_POSITION = "documentSigner.args.field.position";
    public static final String ARG_DOCUMENTSIGNER_ARGS_FIELD_SIZE = "documentSigner.args.field.size";
    public static final String ARG_DOCUMENTSIGNER_ARGS_DECORATOR_ARGS = "documentSigner.args.decorator.args";
    public static final String ARG_DOCUMENTSIGNER_ARGS_DECORATOR_FACTORY = "documentSigner.args.decorator.factory";
    public static final String ARG_FIELD = "field";
    public static final String ARG_HEIGHT = "height";
    public static final String ARG_INPUT = "input";
    public static final String ARG_DEPICTION = "depiction";
    public static final String ARG_FORMAT = "format";
    public static final String ARG_PAGE_RANGE = "pageRange";
    public static final String ARG_PAGE_RANGE_CONTEXT = "pageRangeContext";
    public static final String ARG_REDIRECT_URI = "redirectUri";
    public static final String ARG_SAMPLES = "samples";
    public static final String ARG_SHAPES = "shapes";
    public static final String ARG_SIGNER_CREATE_OPTIONS = "signerCreate.options";
    public static final String ARG_SIGNER_CREATE_VARIABLES = "signerCreate.variables";
    public static final String ARG_SIGNER_CREATE_ARGS = "signerCreate.args";
    public static final String ARG_SIGNER_CREATE_CONFIGURATION = "signerCreate.configuration";
    public static final String ARG_TEXT = "text";
    public static final String ARG_TEXT_SCALE_WHEN = "textScaleWhen";
    public static final String ARG_TRANSFORM = "transform";
    public static final String ARG_TYPE = "type";
    public static final String ARG_WIDTH = "width";
    public static final String ARG_X = "x";
    public static final String ARG_Y = "y";
    private static final String TIMES = "*";
    private static final String SHAPE_TYPE_TEXT = "text";
    private static final String SAMPLES_TYPE_JS_SIGNATURE = "jsSignature";

    protected IConversation<?> basicInvoke(ActionInvocation invocation) {
        try {
            List<RepositoryDocumentState> repoStates;
            IArgs documents = ArgTools.getArgs((IArgs)invocation.getArgs(), (String)ARG_DOCUMENTS, null);
            if (documents == null) {
                repoStates = ((RepositoryBasedFlow)invocation.getFlow()).getRepoDocStates();
            } else {
                repoStates = new ArrayList();
                documents.forEach(binding -> repoStates.add(((RepositoryBasedFlow)invocation.getFlow()).resolveRepoDocState((IArgs)binding.getValue())));
            }
            for (Object e : repoStates) {
                invocation.getFlow().invocationAcquire(invocation, e);
            }
            RequestSignerCreate targetArg = this.createRequestSignerCreate(invocation, repoStates);
            Object object = this.callResource(SvcSigner.class, "create", targetArg);
            IConversation delegateConversation = this.getConversationRegistry().getConversation(((ConversationalResponse)object).getSnapshot().getConversationHandle());
            delegateConversation.thenApply(result -> {
                String ri = FlowOptions.getRestrictedIdentification((IOptionSupport)invocation.getFlow());
                RestrictedIdentificationProvider.enter((Object)ri);
                try {
                    invocation.getFlow().addArtifact(this.transformResultSigner(invocation, (ResultSigner)result));
                    Object var4_4 = null;
                    return var4_4;
                }
                finally {
                    RestrictedIdentificationProvider.leave();
                }
            });
            return delegateConversation;
        }
        catch (Throwable e) {
            return Conversation.failed((Throwable)e);
        }
    }

    protected RequestSignerCreate createRequestSignerCreate(ActionInvocation invocation, List<RepositoryDocumentState> repoStates) {
        String[] inheritedArgs;
        RequestSignerCreate request = new RequestSignerCreate();
        FlowOptions.switchInternalCallTrue((IOptionSupport)request);
        IArgs delegateOptions = request.getOptions();
        ArgTools.putAllDeep((IArgs)delegateOptions, (IArgs)ArgTools.getArgs((IArgs)invocation.getArgs(), (String)ARG_SIGNER_CREATE_OPTIONS, null));
        String redirectUri = ArgTools.getString((IArgs)invocation.getArgs(), (String)ARG_REDIRECT_URI, null);
        FlowOptions.setRedirectUri((IOptionSupport)request, (Object)redirectUri);
        String ri = FlowOptions.getRestrictedIdentification((IOptionSupport)invocation.getFlow());
        FlowOptions.setRestrictedIdentification((IOptionSupport)request, (String)ri);
        Object principal = FlowOptions.getPrincipal((IOptionSupport)invocation.getFlow());
        FlowOptions.setPrincipal((IOptionSupport)request, (Object)principal);
        String lang = FlowOptions.getLang((IOptionSupport)invocation.getFlow());
        FlowOptions.setLang((IOptionSupport)request, (String)lang);
        request.setDocuments(repoStates.stream().map(state -> ((RepositoryBasedFlow)invocation.getFlow()).createTransportDoc(state)).collect(Collectors.toList()));
        IArgs delegateVariables = request.getVariables();
        IArgs callerVariables = invocation.getFlow().getVariables();
        ArgTools.putAllDeep((IArgs)delegateVariables, (IArgs)callerVariables);
        IArgs signerCreateVariables = ArgTools.getArgs((IArgs)invocation.getArgs(), (String)ARG_SIGNER_CREATE_VARIABLES, null);
        ArgTools.putAllDeep((IArgs)delegateVariables, (IArgs)signerCreateVariables);
        Object signerCreateConfiguration = ArgTools.getObject((IArgs)invocation.getArgs(), (String)ARG_SIGNER_CREATE_CONFIGURATION, null);
        request.setConfiguration(signerCreateConfiguration);
        IArgs requestArgs = request.getArgs();
        for (String arg : inheritedArgs = new String[]{"documentTagDetector"}) {
            ArgTools.putPathIfAbsent((IArgs)requestArgs, (String)arg, (Object)ArgTools.getObject((IArgs)invocation.getFlow().getArgs(), (String)arg, null));
        }
        IArgs signerCreateArgs = ArgTools.getArgs((IArgs)invocation.getArgs(), (String)ARG_SIGNER_CREATE_ARGS, null);
        SvcCommon.authorizeArgs((String)"/v1/flow/signer/create", (IArgs)signerCreateArgs);
        ArgTools.putAllDeep((IArgs)requestArgs, (IArgs)signerCreateArgs);
        ArgTools.putPath((IArgs)requestArgs, (String)ARG_DOCUMENTSIGNER_ARGS_ENDORSEMENT, (Object)invocation.getArgs().get("endorsement"));
        ArgTools.putPath((IArgs)requestArgs, (String)ARG_DOCUMENTSIGNER_ARGS_DEPICTION, (Object)invocation.getArgs().get(ARG_DEPICTION));
        this.createRequestSignerCreateArgsField(invocation.getArgs(), requestArgs);
        if (this.isDecoratorSampleDecorator(invocation.getArgs(), requestArgs)) {
            this.createRequestSignerCreateArgsSampleDecorator(invocation.getArgs(), requestArgs);
        } else {
            this.createRequestSignerCreateArgsShapeDecorator(invocation.getArgs(), requestArgs);
        }
        return request;
    }

    protected void createRequestSignerCreateArgsField(IArgs invocationArgs, IArgs requestArgs) {
        IArgs field = ArgTools.getArgs((IArgs)invocationArgs, (String)ARG_FIELD, null);
        if (field != null && field.size() > 0) {
            int height;
            int width;
            int y;
            int x;
            boolean create = ArgTools.getBoolean((IArgs)requestArgs, (String)ARG_DOCUMENTSIGNER_ARGS_FIELD_CREATE, (boolean)true);
            if (!create) {
                throw new IllegalArgumentException("you cannot define both a 'field' and 'documentSigner.args.field.create=false'");
            }
            if (field.isDefined(ARG_X) || field.isDefined(ARG_Y) || field.isDefined(ARG_WIDTH) || field.isDefined(ARG_HEIGHT)) {
                x = ArgTools.getIntStrict((IArgs)field, (String)ARG_X, (int)0);
                y = ArgTools.getIntStrict((IArgs)field, (String)ARG_Y, (int)0);
                width = ArgTools.getIntStrict((IArgs)field, (String)ARG_WIDTH, (int)10);
                height = ArgTools.getIntStrict((IArgs)field, (String)ARG_HEIGHT, (int)10);
            } else {
                x = ArgTools.getIntStrict((IArgs)field, (String)ARG_0, (int)-1);
                y = ArgTools.getIntStrict((IArgs)field, (String)ARG_1, (int)-1);
                width = ArgTools.getIntStrict((IArgs)field, (String)ARG_2, (int)-1);
                height = ArgTools.getIntStrict((IArgs)field, (String)ARG_3, (int)-1);
            }
            ArgTools.putPath((IArgs)requestArgs, (String)ARG_DOCUMENTSIGNER_ARGS_FIELD_CREATE, (Object)"true");
            ArgTools.putPath((IArgs)requestArgs, (String)ARG_DOCUMENTSIGNER_ARGS_FIELD_POSITION, (Object)(x + TIMES + y));
            ArgTools.putPath((IArgs)requestArgs, (String)ARG_DOCUMENTSIGNER_ARGS_FIELD_SIZE, (Object)(width + TIMES + height));
            String pageRange = ArgTools.getString((IArgs)invocationArgs, (String)ARG_PAGE_RANGE, null);
            if (StringTools.isEmpty((String)pageRange)) {
                pageRange = ArgTools.getString((IArgs)requestArgs, (String)ARG_DOCUMENTSIGNER_ARGS_FIELD_PAGE_RANGE, null);
            }
            ArgTools.putPath((IArgs)requestArgs, (String)ARG_DOCUMENTSIGNER_ARGS_FIELD_PAGE_RANGE, (Object)pageRange);
            Object pageRangeContext = ArgTools.getObject((IArgs)invocationArgs, (String)ARG_PAGE_RANGE_CONTEXT, null);
            if (pageRangeContext != null) {
                ArgTools.putPath((IArgs)requestArgs, (String)ARG_DOCUMENTSIGNER_ARGS_FIELD_PAGE_RANGE_CONTEXT, (Object)pageRangeContext);
            }
        }
    }

    protected void createRequestSignerCreateArgsSampleDecorator(IArgs invocationArgs, IArgs requestArgs) {
        String input;
        IArgs decoratorArgs = ArgTools.getArgs((IArgs)requestArgs, (String)ARG_DOCUMENTSIGNER_ARGS_DECORATOR_ARGS, (IArgs)Args.create());
        IArgs argsDepiction = ArgTools.getArgs((IArgs)invocationArgs, (String)ARG_DEPICTION, null);
        if (argsDepiction != null) {
            ArgTools.putPath((IArgs)requestArgs, (String)ARG_DOCUMENTSIGNER_ARGS_DECORATOR_FACTORY, (Object)SAMPLE_DECORATOR_FACTORY);
            ArgTools.putPath((IArgs)requestArgs, (String)ARG_DOCUMENTSIGNER_ARGS_DECORATOR_ARGS, (Object)decoratorArgs);
            ArgTools.putPath((IArgs)decoratorArgs, (String)ARG_FORMAT, (Object)ArgTools.getString((IArgs)argsDepiction, (String)ARG_FORMAT, (String)SAMPLES_TYPE_JS_SIGNATURE));
            ArgTools.putPath((IArgs)decoratorArgs, (String)ARG_SAMPLES, (Object)argsDepiction.get(ARG_SAMPLES));
            ArgTools.putPath((IArgs)decoratorArgs, (String)ARG_TRANSFORM, (Object)argsDepiction.get(ARG_TRANSFORM));
        }
        if (!StringTools.isEmpty((String)(input = ArgTools.getString((IArgs)invocationArgs, (String)ARG_INPUT, null)))) {
            ArgTools.putPathIfAbsent((IArgs)requestArgs, (String)ARG_DOCUMENTSIGNER_ARGS_DECORATOR_FACTORY, (Object)EXTENDED_DECORATOR_FACTORY);
            ArgTools.putPath((IArgs)requestArgs, (String)ARG_DOCUMENTSIGNER_ARGS_DECORATOR_ARGS, (Object)decoratorArgs);
            ArgTools.putPath((IArgs)decoratorArgs, (String)"text", (Object)input);
            ArgTools.putPathIfAbsent((IArgs)decoratorArgs, (String)ARG_TEXT_SCALE_WHEN, (Object)EnumScaleWhen.ALWAYS.getId());
        }
    }

    protected void createRequestSignerCreateArgsShapeDecorator(IArgs invocationArgs, IArgs requestArgs) {
        String input;
        Args shapesArgs = Args.create();
        IArgs argsDepiction = ArgTools.getArgs((IArgs)invocationArgs, (String)ARG_DEPICTION, null);
        if (argsDepiction != null) {
            Args shapeArgs = Args.create();
            ArgTools.putPath((IArgs)shapeArgs, (String)ARG_TYPE, (Object)ARG_SAMPLES);
            ArgTools.putPath((IArgs)shapeArgs, (String)ARG_FORMAT, (Object)ArgTools.getString((IArgs)argsDepiction, (String)ARG_FORMAT, (String)SAMPLES_TYPE_JS_SIGNATURE));
            ArgTools.putPath((IArgs)shapeArgs, (String)ARG_SAMPLES, (Object)argsDepiction.get(ARG_SAMPLES));
            ArgTools.putPath((IArgs)shapeArgs, (String)ARG_TRANSFORM, (Object)argsDepiction.get(ARG_TRANSFORM));
            shapesArgs.add((Object)shapeArgs);
        }
        if (!StringTools.isEmpty((String)(input = ArgTools.getString((IArgs)invocationArgs, (String)ARG_INPUT, null)))) {
            Args shapeArgs = Args.create();
            ArgTools.putPath((IArgs)shapeArgs, (String)ARG_TYPE, (Object)"text");
            ArgTools.putPath((IArgs)shapeArgs, (String)"text", (Object)input);
            ArgTools.putPath((IArgs)shapeArgs, (String)ARG_SIZE, (Object)"100%*100%");
            ArgTools.putPath((IArgs)shapeArgs, (String)ARG_ALIGN, (Object)"center;fill");
            shapesArgs.add((Object)shapeArgs);
        }
        if (shapesArgs.size() > 0) {
            Args decoratorArgs = Args.create();
            ArgTools.putPath((IArgs)decoratorArgs, (String)ARG_SHAPES, (Object)shapesArgs);
            ArgTools.putPath((IArgs)requestArgs, (String)ARG_DOCUMENTSIGNER_ARGS_DECORATOR_FACTORY, (Object)SHAPE_DECORATOR_FACTORY);
            ArgTools.putPath((IArgs)requestArgs, (String)ARG_DOCUMENTSIGNER_ARGS_DECORATOR_ARGS, (Object)decoratorArgs);
        }
    }

    protected boolean isDecoratorSampleDecorator(IArgs invocationArgs, IArgs requestArgs) {
        String decoratorFactory = ArgTools.getString((IArgs)requestArgs, (String)ARG_DOCUMENTSIGNER_ARGS_DECORATOR_FACTORY, null);
        if (EXTENDED_DECORATOR_FACTORY.equals(decoratorFactory)) {
            return true;
        }
        if (SHAPE_DECORATOR_FACTORY.equals(decoratorFactory)) {
            return false;
        }
        IArgs decoratorArgs = ArgTools.getArgs((IArgs)requestArgs, (String)ARG_DOCUMENTSIGNER_ARGS_DECORATOR_ARGS, null);
        String decoratorText = ArgTools.getString((IArgs)decoratorArgs, (String)"text", null);
        return !StringTools.isEmpty((String)decoratorText);
    }

    protected TransportDocument transformResultDocument(RepositoryDocumentState repoDocState, TransportDocument document) {
        TransportDocument transformedDoc = new TransportDocument();
        ILocator resultLocator = document.getLocator();
        transformedDoc.addProperties(document.getProperties());
        if (repoDocState.isImported()) {
            transformedDoc.setContent(resultLocator);
        } else {
            transformedDoc.setHandle(resultLocator);
        }
        return transformedDoc;
    }

    protected DtoArtifact transformResultSigner(ActionInvocation invocation, ResultSigner result) {
        DtoArtifact artifact = new DtoArtifact();
        ResultSigner transformedResult = new ResultSigner();
        transformedResult.setDocumentNames(result.getDocumentNames());
        artifact.setValue((Object)transformedResult);
        if (result.getSignatures() != null) {
            ArrayList<TransportDocument> transformedDocList = new ArrayList<TransportDocument>();
            for (TransportDocument tempDocument : result.getSignatures()) {
                String targetName = (String)tempDocument.getProperty("signature.targetName");
                RepositoryDocumentState repoDocState = ((RepositoryBasedFlow)invocation.getFlow()).resolveRepoDocStateByName(targetName);
                repoDocState.setAttribute((Object)"cs.signed", (Object)true);
                TransportDocument transformedDoc = this.transformResultDocument(repoDocState, tempDocument);
                transformedDocList.add(transformedDoc);
            }
            transformedResult.setSignatures(transformedDocList);
        }
        return artifact;
    }
}

