/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.core.action;

import de.intarsys.cloudsuite.gears.action.ActionInvocation;
import de.intarsys.cloudsuite.gears.action.ServerAction;
import de.intarsys.cloudsuite.gears.core.service.common.api.DtoArtifact;
import de.intarsys.cloudsuite.gears.core.service.common.api.FlowOptions;
import de.intarsys.cloudsuite.gears.core.service.common.api.IOptionSupport;
import de.intarsys.cloudsuite.gears.core.service.common.api.TransportDocument;
import de.intarsys.cloudsuite.gears.core.service.common.impl.RepositoryDocumentState;
import de.intarsys.cloudsuite.gears.core.service.timestamper.api.RequestTimestamperCreate;
import de.intarsys.cloudsuite.gears.core.service.timestamper.api.ResultTimestamper;
import de.intarsys.cloudsuite.gears.core.service.timestamper.impl.SvcTimestamper;
import de.intarsys.cloudsuite.gears.flow.common.RepositoryBasedFlow;
import de.intarsys.cloudsuite.gears.repository.impl.RestrictedIdentificationProvider;
import de.intarsys.conversation.service.client.api.ConversationalResponse;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.conversation.impl.Conversation;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.locator.ILocator;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class Timestamp
extends ServerAction {
    public static final String ARG_TIMESTAMPER_CREATE_CONFIGURATION = "timestamperCreate.configuration";
    public static final String ARG_REDIRECT_URI = "redirectUri";

    protected IConversation<?> basicInvoke(ActionInvocation invocation) {
        try {
            List repoStates = ((RepositoryBasedFlow)invocation.getFlow()).getRepoDocStates();
            for (Object resource : repoStates) {
                invocation.getFlow().invocationAcquire(invocation, resource);
            }
            RequestTimestamperCreate targetArg = this.createRequestTimestamperCreate(invocation, repoStates);
            Object responseCreate = this.callResource(SvcTimestamper.class, "create", targetArg);
            IConversation delegateConversation = this.getConversationRegistry().getConversation(((ConversationalResponse)responseCreate).getSnapshot().getConversationHandle());
            delegateConversation.thenApply(result -> {
                String ri = FlowOptions.getRestrictedIdentification((IOptionSupport)invocation.getFlow());
                RestrictedIdentificationProvider.enter((Object)ri);
                try {
                    invocation.getFlow().addArtifact(this.transformResultTimestamper(invocation, (ResultTimestamper)result));
                    Object var4_4 = null;
                    return var4_4;
                }
                finally {
                    RestrictedIdentificationProvider.leave();
                }
            });
            return delegateConversation;
        }
        catch (Throwable e) {
            return Conversation.failed((Throwable)e);
        }
    }

    RequestTimestamperCreate createRequestTimestamperCreate(ActionInvocation invocation, List<RepositoryDocumentState> repoStates) {
        RequestTimestamperCreate request = new RequestTimestamperCreate();
        FlowOptions.switchInternalCallTrue((IOptionSupport)request);
        String redirectUri = ArgTools.getString((IArgs)invocation.getArgs(), (String)ARG_REDIRECT_URI, null);
        FlowOptions.setRedirectUri((IOptionSupport)request, (Object)redirectUri);
        request.setDocuments(repoStates.stream().map(state -> ((RepositoryBasedFlow)invocation.getFlow()).createTransportDoc(state)).collect(Collectors.toList()));
        Object timestamperCreateConfiguration = ArgTools.getObject((IArgs)invocation.getArgs(), (String)ARG_TIMESTAMPER_CREATE_CONFIGURATION, null);
        request.setConfiguration(timestamperCreateConfiguration);
        return request;
    }

    protected TransportDocument transformResultDocument(RepositoryDocumentState repoDocState, TransportDocument document) {
        TransportDocument transformedDoc = new TransportDocument();
        ILocator resultLocator = document.getLocator();
        transformedDoc.addProperties(document.getProperties());
        if (repoDocState.isImported()) {
            transformedDoc.setContent(resultLocator);
        } else {
            transformedDoc.setHandle(resultLocator);
        }
        return transformedDoc;
    }

    protected DtoArtifact transformResultTimestamper(ActionInvocation invocation, ResultTimestamper result) {
        DtoArtifact artifact = new DtoArtifact();
        ResultTimestamper transformedResult = new ResultTimestamper();
        transformedResult.setDocumentNames(result.getDocumentNames());
        artifact.setValue((Object)transformedResult);
        if (result.getDocumentTimestamps() != null) {
            ArrayList<TransportDocument> transformedDocList = new ArrayList<TransportDocument>();
            for (TransportDocument tempDocument : result.getDocumentTimestamps()) {
                String targetName = (String)tempDocument.getProperty("timestamp.targetName");
                RepositoryDocumentState repoDocState = ((RepositoryBasedFlow)invocation.getFlow()).resolveRepoDocStateByName(targetName);
                TransportDocument transformedDoc = this.transformResultDocument(repoDocState, tempDocument);
                transformedDocList.add(transformedDoc);
            }
            transformedResult.setDocumentTimestamps(transformedDocList);
        }
        return artifact;
    }
}

