/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.core.action;

import de.intarsys.cloudsuite.gears.action.ActionInvocation;
import de.intarsys.cloudsuite.gears.action.ServerAction;
import de.intarsys.cloudsuite.gears.core.service.common.api.DtoArtifact;
import de.intarsys.cloudsuite.gears.core.service.common.api.FlowOptions;
import de.intarsys.cloudsuite.gears.core.service.common.api.IOptionSupport;
import de.intarsys.cloudsuite.gears.core.service.common.api.TransportDocument;
import de.intarsys.cloudsuite.gears.core.service.common.impl.RepositoryDocumentState;
import de.intarsys.cloudsuite.gears.core.service.viewer.api.RequestViewerCreate;
import de.intarsys.cloudsuite.gears.core.service.viewer.api.ResultViewer;
import de.intarsys.cloudsuite.gears.core.service.viewer.impl.SvcViewer;
import de.intarsys.cloudsuite.gears.flow.common.CoreFlow;
import de.intarsys.cloudsuite.gears.flow.common.RepositoryBasedFlow;
import de.intarsys.cloudsuite.gears.repository.impl.RestrictedIdentificationProvider;
import de.intarsys.conversation.service.client.api.ConversationalResponse;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.conversation.impl.Conversation;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.string.StringTools;

public class View
extends ServerAction {
    public static final String OPTION_DEBUG_URL_CLIENT = "debug.urlClient";
    public static final String ARG_REDIRECT_URI = "redirectUri";
    public static final String ARG_READ_ONLY = "readOnly";
    public static final String ARG_DOCUMENT = "document";
    public static final String ARG_VIEWER_CREATE_ARGS = "viewerCreate.args";
    public static final String ARG_VIEWER_CREATE_CONFIGURATION = "viewerCreate.configuration";
    public static final String ARG_VIEWER_CREATE_OPTIONS = "viewerCreate.options";
    public static final String ARG_VIEWER_CREATE_VARIABLES = "viewerCreate.variables";

    protected IConversation<?> basicInvoke(ActionInvocation invocation) {
        try {
            IArgs document = ArgTools.getArgs((IArgs)invocation.getArgs(), (String)ARG_DOCUMENT, null);
            RepositoryDocumentState repoState = ((RepositoryBasedFlow)invocation.getFlow()).resolveRepoDocState(document);
            if (repoState == null) {
                throw new IllegalArgumentException("'document' required");
            }
            boolean readOnly = ArgTools.getBoolStrict((IArgs)invocation.getArgs(), (String)ARG_READ_ONLY, (boolean)false);
            if (!readOnly) {
                try {
                    ((RepositoryBasedFlow)invocation.getFlow()).invocationAcquire(invocation, (Object)repoState);
                }
                catch (Exception e) {
                    return Conversation.failed((Throwable)e);
                }
            }
            RequestViewerCreate request = this.createRequestViewerCreate(invocation, repoState);
            Object responseCreate = this.callResource(SvcViewer.class, "create", request);
            IConversation delegateConversation = this.getConversationRegistry().getConversation(((ConversationalResponse)responseCreate).getSnapshot().getConversationHandle());
            delegateConversation.thenApply(result -> {
                String ri = FlowOptions.getRestrictedIdentification((IOptionSupport)invocation.getFlow());
                RestrictedIdentificationProvider.enter((Object)ri);
                try {
                    ((RepositoryBasedFlow)invocation.getFlow()).addArtifact(this.transformResultViewer(invocation, request, (ResultViewer)result));
                    Object var5_5 = null;
                    return var5_5;
                }
                finally {
                    RestrictedIdentificationProvider.leave();
                }
            });
            return delegateConversation;
        }
        catch (Throwable e) {
            return Conversation.failed((Throwable)e);
        }
    }

    protected RequestViewerCreate createRequestViewerCreate(ActionInvocation invocation, RepositoryDocumentState repoState) {
        CoreFlow flow = invocation.getFlow();
        RequestViewerCreate request = new RequestViewerCreate();
        IArgs delegateOptions = request.getOptions();
        ArgTools.putAllDeep((IArgs)delegateOptions, (IArgs)ArgTools.getArgs((IArgs)invocation.getArgs(), (String)ARG_VIEWER_CREATE_OPTIONS, null));
        String redirectUri = ArgTools.getString((IArgs)invocation.getArgs(), (String)ARG_REDIRECT_URI, null);
        FlowOptions.setRedirectUri((IOptionSupport)request, (Object)redirectUri);
        String ri = FlowOptions.getRestrictedIdentification((IOptionSupport)flow);
        FlowOptions.setRestrictedIdentification((IOptionSupport)request, (String)ri);
        Object principal = FlowOptions.getPrincipal((IOptionSupport)flow);
        FlowOptions.setPrincipal((IOptionSupport)request, (Object)principal);
        String lang = FlowOptions.getLang((IOptionSupport)invocation.getFlow());
        FlowOptions.setLang((IOptionSupport)request, (String)lang);
        String debugUrlClient = (String)flow.getOption(OPTION_DEBUG_URL_CLIENT);
        if (!StringTools.isEmpty((String)debugUrlClient)) {
            request.setOption(OPTION_DEBUG_URL_CLIENT, (Object)debugUrlClient);
        }
        TransportDocument transportDocument = ((RepositoryBasedFlow)flow).createTransportDoc(repoState);
        transportDocument.addProperties(ArgTools.getArgs((IArgs)invocation.getArgs(), (String)"document.properties", null));
        request.setDocument(transportDocument);
        IArgs delegateVariables = request.getVariables();
        IArgs callerVariables = invocation.getFlow().getVariables();
        ArgTools.putAllDeep((IArgs)delegateVariables, (IArgs)callerVariables);
        IArgs signerCreateVariables = ArgTools.getArgs((IArgs)invocation.getArgs(), (String)ARG_VIEWER_CREATE_VARIABLES, null);
        ArgTools.putAllDeep((IArgs)delegateVariables, (IArgs)signerCreateVariables);
        request.setConfiguration((Object)ArgTools.getString((IArgs)invocation.getArgs(), (String)ARG_VIEWER_CREATE_CONFIGURATION, null));
        IArgs delegateArgs = request.getArgs();
        ArgTools.putAllDeep((IArgs)delegateArgs, (IArgs)ArgTools.getArgs((IArgs)invocation.getArgs(), (String)ARG_VIEWER_CREATE_ARGS, null));
        return request;
    }

    protected DtoArtifact transformResultViewer(ActionInvocation invocation, RequestViewerCreate request, ResultViewer result) {
        DtoArtifact artifact = new DtoArtifact();
        ResultViewer transformedResult = new ResultViewer();
        transformedResult.setDocumentName(result.getDocumentName());
        artifact.setValue((Object)transformedResult);
        String name = request.getDocument().getName();
        RepositoryDocumentState repoDocState = ((RepositoryBasedFlow)invocation.getFlow()).resolveRepoDocStateByName(name);
        repoDocState.setAttribute((Object)"cs.viewed", (Object)true);
        return artifact;
    }
}

