/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.core.config;

import de.intarsys.claptz.container.ClaptzContainer;
import de.intarsys.claptz.container.InstrumentJarProvider;
import de.intarsys.claptz.container.InstrumentProvider;
import de.intarsys.claptz.container.InstrumentXFSProvider;
import de.intarsys.document.model.DocumentOutlet;
import de.intarsys.document.model.IDocumentType;
import de.intarsys.security.device.DeviceProviderRegistry;
import de.intarsys.security.environment.SecurityEnvironment;
import de.intarsys.security.validation.ValidationEnvironment;
import de.intarsys.tools.bean.IBeanContainer;
import de.intarsys.tools.bean.IBeanInstallationInstruction;
import de.intarsys.tools.factory.Outlet;
import de.intarsys.tools.license.LicenseLoader;
import de.intarsys.tools.license.LicenseProduct;
import de.intarsys.tools.preferences.IPreferencesFactory;
import de.intarsys.tools.servicelocator.ServiceLocator;
import de.intarsys.tools.string.StringTools;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;

public class ClaptzConfig {
    private static final Logger Log = LoggerFactory.getLogger(ClaptzConfig.class);
    @Autowired(required=false)
    private List<LicenseLoader> licenseLoaders;
    @Autowired(required=false)
    private List<LicenseProduct> licenseProducts;
    @Autowired
    private ApplicationContext context;
    @Autowired
    private GenericApplicationContext applicationContext;
    @Value(value="${claptz.define:}")
    private String claptzDefine;
    private ClaptzContainer container;

    @PreDestroy
    public void destroy() {
        if (this.container != null) {
            this.container.stop();
        }
    }

    @PostConstruct
    public void init() {
        DeviceProviderRegistry.get().clear();
        Outlet.get().clear();
        DocumentOutlet.get().clear();
        ServiceLocator.get().remove(IBeanContainer.class);
        ServiceLocator.get().remove(IPreferencesFactory.class);
        ServiceLocator.get().remove(ValidationEnvironment.class);
        SecurityEnvironment.get();
        this.container = new ClaptzContainer(){

            protected void hookStartBefore() throws Exception {
                super.hookStartBefore();
                Map instructions = ClaptzConfig.this.context.getBeansOfType(IBeanInstallationInstruction.class);
                for (IBeanInstallationInstruction instruction : instructions.values()) {
                    Log.debug("found installation instruction {}", (Object)instruction);
                }
            }
        };
        this.container.addInstrumentProvider((InstrumentProvider)new InstrumentJarProvider());
        this.container.addInstrumentProvider((InstrumentProvider)new InstrumentXFSProvider());
        if (!StringTools.isEmpty((String)this.claptzDefine)) {
            Arrays.stream(this.claptzDefine.split(",")).forEach(arg_0 -> ((ClaptzContainer)this.container).ppDefine(arg_0));
        }
        this.container.start();
        for (IDocumentType type : DocumentOutlet.get().getDocumentTypes()) {
            this.applicationContext.registerBean(type.getClass(), new Object[]{() -> type});
        }
    }
}

